/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.store.crl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.DateUtil;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.server.impl.store.crl.ImportCrl;
import org.xipki.ocsp.server.impl.store.crl.StoreConf;
import org.xipki.ocsp.server.impl.store.db.DbCertStatusStore;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.util.X509Util;

public class CrlDbCertStatusStore
extends DbCertStatusStore {
    public static final String KEY_CA_REVOCATION_TIME = "ca.revocation.time";
    public static final String KEY_CA_INVALIDITY_TIME = "ca.invalidity.time";
    private static final Logger LOG = LoggerFactory.getLogger(CrlDbCertStatusStore.class);
    private final AtomicBoolean crlUpdateInProcess = new AtomicBoolean(false);
    private X509Certificate caCert;
    private X509Certificate issuerCert;
    private String crlFilename;
    private String crlUrl;
    private String certsDirName;
    private boolean useUpdateDatesFromCrl;
    private boolean crlUpdated;
    private boolean crlUpdateFailed;

    @Override
    public void init(String conf, DataSourceWrapper datasource) throws OcspStoreException {
        ParamUtil.requireNonBlank((String)"conf", (String)conf);
        this.datasource = (DataSourceWrapper)ParamUtil.requireNonNull((String)"datasource", (Object)datasource);
        StoreConf storeConf = new StoreConf(conf);
        this.crlFilename = IoUtil.expandFilepath((String)storeConf.crlFile());
        this.crlUrl = storeConf.crlUrl();
        this.certsDirName = storeConf.certsDir() == null ? null : IoUtil.expandFilepath((String)storeConf.certsDir());
        this.caCert = CrlDbCertStatusStore.parseCert(storeConf.caCertFile());
        this.issuerCert = storeConf.issuerCertFile() != null ? CrlDbCertStatusStore.parseCert(storeConf.issuerCertFile()) : null;
        this.useUpdateDatesFromCrl = storeConf.isUseUpdateDatesFromCrl();
        this.initializeStore(datasource);
        super.init(conf, datasource);
    }

    @Override
    protected List<Runnable> getScheduledServices() {
        return Arrays.asList(new CrlUpdateService());
    }

    @Override
    protected boolean isInitialized() {
        return this.crlUpdated && super.isInitialized();
    }

    @Override
    protected boolean isInitializationFailed() {
        return this.crlUpdateFailed || super.isInitializationFailed();
    }

    private static X509Certificate parseCert(String certFile) throws OcspStoreException {
        try {
            return X509Util.parseCert((String)certFile);
        }
        catch (IOException | CertificateException ex) {
            throw new OcspStoreException("could not parse X.509 certificate from file " + certFile + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeStore(DataSourceWrapper datasource) {
        if (this.crlUpdateInProcess.get()) {
            return;
        }
        this.crlUpdateInProcess.set(true);
        Boolean updateCrlSuccessful = null;
        File updateMeFile = new File(this.crlFilename + ".UPDATEME");
        if (!updateMeFile.exists()) {
            LOG.info("The CRL will not be updated. Create new file {} to force the update", (Object)updateMeFile.getAbsolutePath());
            this.crlUpdated = true;
            this.crlUpdateFailed = false;
            return;
        }
        try {
            File fullCrlFile = new File(this.crlFilename);
            if (!fullCrlFile.exists()) {
                LOG.warn("CRL File {} does not exist", (Object)this.crlFilename);
                return;
            }
            LOG.info("UPDATE_CERTSTORE: a newer CRL is available");
            updateCrlSuccessful = false;
            X509CRL crl = X509Util.parseCrl((String)this.crlFilename);
            File revFile = new File(this.crlFilename + ".revocation");
            CertRevocationInfo caRevInfo = null;
            if (revFile.exists()) {
                Properties props = new Properties();
                try (FileInputStream is = new FileInputStream(revFile);){
                    props.load(is);
                }
                String str = props.getProperty(KEY_CA_REVOCATION_TIME);
                if (StringUtil.isNotBlank((String)str)) {
                    Date revocationTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    Date invalidityTime = null;
                    str = props.getProperty(KEY_CA_INVALIDITY_TIME);
                    if (StringUtil.isNotBlank((String)str)) {
                        invalidityTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    }
                    caRevInfo = new CertRevocationInfo(CrlReason.UNSPECIFIED, revocationTime, invalidityTime);
                }
            }
            ImportCrl importCrl = new ImportCrl(datasource, this.useUpdateDatesFromCrl, crl, this.crlUrl, this.caCert, this.issuerCert, caRevInfo, this.certsDirName);
            updateCrlSuccessful = importCrl.importCrlToOcspDb();
            this.crlUpdated = true;
            if (updateCrlSuccessful.booleanValue()) {
                this.crlUpdateFailed = false;
                LOG.info("updated CertStore {} successfully", (Object)this.name);
            } else {
                this.crlUpdateFailed = true;
                LOG.error("updating CertStore {} failed", (Object)this.name);
            }
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not execute initializeStore()");
            this.crlUpdateFailed = true;
            this.crlUpdated = true;
        }
        finally {
            updateMeFile.delete();
            this.crlUpdateInProcess.set(false);
            if (updateCrlSuccessful != null) {
                if (updateCrlSuccessful.booleanValue()) {
                    LOG.info("UPDATE_CRL: successful");
                } else {
                    LOG.warn("UPDATE_CRL: failed");
                }
            }
        }
    }

    private class CrlUpdateService
    implements Runnable {
        private CrlUpdateService() {
        }

        @Override
        public void run() {
            try {
                CrlDbCertStatusStore.this.initializeStore(CrlDbCertStatusStore.this.datasource);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("error while calling initializeStore() for store " + CrlDbCertStatusStore.this.name));
            }
        }
    }
}

