/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.store.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.impl.store.db.IssuerEntry;

public class IssuerStore {
    private final List<IssuerEntry> entries;
    private Set<Integer> ids;

    public IssuerStore(List<IssuerEntry> entries) {
        this.entries = new ArrayList<IssuerEntry>(entries.size());
        HashSet<Integer> idSet = new HashSet<Integer>(entries.size());
        for (IssuerEntry entry : entries) {
            for (IssuerEntry existingEntry : this.entries) {
                if (existingEntry.id() != entry.id()) continue;
                throw new IllegalArgumentException("issuer with the same id " + entry.id() + " already available");
            }
            this.entries.add(entry);
            idSet.add(entry.id());
        }
        this.ids = Collections.unmodifiableSet(idSet);
    }

    public int size() {
        return this.ids.size();
    }

    public Set<Integer> ids() {
        return this.ids;
    }

    public Integer getIssuerIdForFp(RequestIssuer reqIssuer) {
        IssuerEntry issuerEntry = this.getIssuerForFp(reqIssuer);
        return issuerEntry == null ? null : Integer.valueOf(issuerEntry.id());
    }

    public IssuerEntry getIssuerForId(int id) {
        for (IssuerEntry entry : this.entries) {
            if (entry.id() != id) continue;
            return entry;
        }
        return null;
    }

    public IssuerEntry getIssuerForFp(RequestIssuer reqIssuer) {
        for (IssuerEntry entry : this.entries) {
            if (!entry.matchHash(reqIssuer)) continue;
            return entry;
        }
        return null;
    }

    public void addIssuer(IssuerEntry issuer) {
        this.entries.add(issuer);
        HashSet<Integer> newIds = new HashSet<Integer>(this.ids);
        newIds.add(issuer.id());
        this.ids = Collections.unmodifiableSet(newIds);
    }
}

