/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import java.math.BigInteger;
import org.xipki.common.ASN1Type;
import org.xipki.ocsp.api.RequestIssuer;

public class CertID
extends ASN1Type {
    private final RequestIssuer issuer;
    private final BigInteger serialNumber;
    private final int bodyLength;
    private final int encodedLength;

    public CertID(RequestIssuer issuer, BigInteger serialNumber) {
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        int len = issuer.length();
        int snBytesLen = 1 + serialNumber.bitLength() / 8;
        this.bodyLength = len += CertID.getLen((int)snBytesLen);
        this.encodedLength = CertID.getLen((int)this.bodyLength);
    }

    public RequestIssuer issuer() {
        return this.issuer;
    }

    public BigInteger serialNumber() {
        return this.serialNumber;
    }

    public int encodedLength() {
        return this.encodedLength;
    }

    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += CertID.writeHeader((byte)48, (int)this.bodyLength, (byte[])out, (int)idx);
        idx += this.issuer.write(out, idx);
        byte[] snBytes = this.serialNumber.toByteArray();
        idx += CertID.writeHeader((byte)2, (int)snBytes.length, (byte[])out, (int)idx);
        idx += CertID.arraycopy((byte[])snBytes, (byte[])out, (int)idx);
        return idx - offset;
    }
}

