/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.xipki.common.ASN1Type;
import org.xipki.common.util.CompareUtil;
import org.xipki.security.ObjectIdentifiers;

public enum OID {
    ID_PKIX_OCSP_NONCE(OCSPObjectIdentifiers.id_pkix_ocsp_nonce),
    ID_PKIX_OCSP_PREFSIGALGS(ObjectIdentifiers.id_pkix_ocsp_prefSigAlgs),
    ID_PKIX_OCSP_EXTENDEDREVOKE(ObjectIdentifiers.id_pkix_ocsp_extendedRevoke),
    ID_ISISMTT_AT_CERTHASH(ISISMTTObjectIdentifiers.id_isismtt_at_certHash),
    ID_INVALIDITY_DATE(Extension.invalidityDate),
    ID_PKIX_OCSP_ARCHIVE_CUTOFF(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff);

    private String id;
    private byte[] encoded;

    private OID(ASN1ObjectIdentifier oid) {
        this.id = oid.getId();
        try {
            this.encoded = oid.getEncoded();
        }
        catch (IOException ex) {
            throw new IllegalStateException("should not happen", ex);
        }
    }

    public String id() {
        return this.id;
    }

    public int encodedLength() {
        return this.encoded.length;
    }

    public int write(byte[] out, int offset) {
        return ASN1Type.arraycopy((byte[])this.encoded, (byte[])out, (int)offset);
    }

    public static OID getInstanceForEncoded(byte[] data, int offset) {
        for (OID m : OID.values()) {
            if (!CompareUtil.areEqual((byte[])data, (int)offset, (byte[])m.encoded, (int)0, (int)m.encoded.length)) continue;
            return m;
        }
        return null;
    }
}

