/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import java.util.Date;
import org.xipki.common.ASN1Type;
import org.xipki.ocsp.server.impl.type.CertID;
import org.xipki.ocsp.server.impl.type.Extensions;

public class SingleResponse
extends ASN1Type {
    private final CertID certId;
    private final byte[] certStatus;
    private final Date thisUpdate;
    private final Date nextUpdate;
    private final Extensions extensions;
    private final int bodyLength;
    private final int encodedLength;

    public SingleResponse(CertID certId, byte[] certStatus, Date thisUpdate, Date nextUpdate, Extensions extensions) {
        this.certId = certId;
        this.certStatus = certStatus;
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.extensions = extensions;
        int len = certId.encodedLength();
        len += certStatus.length;
        len += 17;
        if (nextUpdate != null) {
            len += 2;
            len += 17;
        }
        if (extensions != null) {
            len += SingleResponse.getLen((int)extensions.encodedLength());
        }
        this.bodyLength = len;
        this.encodedLength = SingleResponse.getLen((int)this.bodyLength);
    }

    public int encodedLength() {
        return this.encodedLength;
    }

    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += SingleResponse.writeHeader((byte)48, (int)this.bodyLength, (byte[])out, (int)idx);
        idx += this.certId.write(out, idx);
        idx += SingleResponse.arraycopy((byte[])this.certStatus, (byte[])out, (int)idx);
        idx += SingleResponse.writeGeneralizedTime((Date)this.thisUpdate, (byte[])out, (int)idx);
        if (this.nextUpdate != null) {
            idx += SingleResponse.writeHeader((byte)-96, (int)17, (byte[])out, (int)idx);
            idx += SingleResponse.writeGeneralizedTime((Date)this.nextUpdate, (byte[])out, (int)idx);
        }
        if (this.extensions != null) {
            idx += SingleResponse.writeHeader((byte)-95, (int)this.extensions.encodedLength(), (byte[])out, (int)idx);
            idx += this.extensions.write(out, idx);
        }
        return idx - offset;
    }
}

