/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.LruCache;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.datasource.DatabaseType;
import org.xipki.datasource.internal.SqlErrorCodes;
import org.xipki.datasource.internal.SqlStateCodes;
import org.xipki.datasource.springframework.dao.CannotAcquireLockException;
import org.xipki.datasource.springframework.dao.CannotSerializeTransactionException;
import org.xipki.datasource.springframework.dao.ConcurrencyFailureException;
import org.xipki.datasource.springframework.dao.DataAccessException;
import org.xipki.datasource.springframework.dao.DataAccessResourceFailureException;
import org.xipki.datasource.springframework.dao.DataIntegrityViolationException;
import org.xipki.datasource.springframework.dao.DeadlockLoserDataAccessException;
import org.xipki.datasource.springframework.dao.PermissionDeniedDataAccessException;
import org.xipki.datasource.springframework.dao.QueryTimeoutException;
import org.xipki.datasource.springframework.dao.TransientDataAccessResourceException;
import org.xipki.datasource.springframework.jdbc.BadSqlGrammarException;
import org.xipki.datasource.springframework.jdbc.DuplicateKeyException;
import org.xipki.datasource.springframework.jdbc.InvalidResultSetAccessException;
import org.xipki.datasource.springframework.jdbc.UncategorizedSqlException;

public abstract class DataSourceWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceWrapper.class);
    protected final HikariDataSource service;
    protected final String name;
    private final Object lastUsedSeqValuesLock = new Object();
    private final ConcurrentHashMap<String, Long> lastUsedSeqValues = new ConcurrentHashMap();
    private final SqlErrorCodes sqlErrorCodes;
    private final SqlStateCodes sqlStateCodes;
    private final DatabaseType databaseType;
    private final LruCache<String, String> cacheSeqNameSqls;

    private DataSourceWrapper(String name, HikariDataSource service, DatabaseType dbType) {
        this.service = (HikariDataSource)ParamUtil.requireNonNull((String)"service", (Object)service);
        this.databaseType = (DatabaseType)((Object)ParamUtil.requireNonNull((String)"dbType", (Object)((Object)dbType)));
        this.name = name;
        this.sqlErrorCodes = SqlErrorCodes.newInstance(dbType);
        this.sqlStateCodes = SqlStateCodes.newInstance(dbType);
        this.cacheSeqNameSqls = new LruCache(100);
    }

    public final String datasourceName() {
        return this.name;
    }

    public final DatabaseType databaseType() {
        return this.databaseType;
    }

    public final int maximumPoolSize() {
        return this.service.getMaximumPoolSize();
    }

    public final Connection getConnection() throws DataAccessException {
        try {
            return this.service.getConnection();
        }
        catch (Exception ex2) {
            SQLException ex2;
            Throwable cause = ex2.getCause();
            if (cause instanceof SQLException) {
                ex2 = (SQLException)cause;
            }
            LogUtil.error((Logger)LOG, (Throwable)ex2, (String)"could not create connection to database");
            if (ex2 instanceof SQLException) {
                throw this.translate(null, ex2);
            }
            throw new DataAccessException("error occured while getting Connection: " + ex2.getMessage(), ex2);
        }
    }

    public void returnConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception ex2) {
            SQLException ex2;
            Throwable cause = ex2.getCause();
            if (cause instanceof SQLException) {
                ex2 = (SQLException)cause;
            }
            LogUtil.error((Logger)LOG, (Throwable)ex2, (String)"could not close connection to database {}");
        }
    }

    public void close() {
        try {
            this.service.close();
        }
        catch (Exception ex) {
            LOG.warn("could not close datasource: {}", (Object)ex.getMessage());
            LOG.debug("could not close datasource", (Throwable)ex);
        }
    }

    public final PrintWriter getLogWriter() throws SQLException {
        return this.service.getLogWriter();
    }

    public Statement createStatement(Connection conn) throws DataAccessException {
        ParamUtil.requireNonNull((String)"conn", (Object)conn);
        try {
            return conn.createStatement();
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
    }

    public PreparedStatement prepareStatement(Connection conn, String sqlQuery) throws DataAccessException {
        ParamUtil.requireNonNull((String)"conn", (Object)conn);
        try {
            return conn.prepareStatement(sqlQuery);
        }
        catch (SQLException ex) {
            throw this.translate(sqlQuery, ex);
        }
    }

    public void releaseResources(Statement ps, ResultSet rs) {
        this.releaseResources(ps, rs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources(Statement ps, ResultSet rs, boolean returnConnection) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable th) {
                LOG.warn("could not close ResultSet", th);
            }
        }
        if (ps != null) {
            Connection conn = null;
            try {
                conn = ps.getConnection();
            }
            catch (SQLException ex) {
                LOG.error("could not get connection from statement: {}", (Object)ex.getMessage());
            }
            try {
                ps.close();
            }
            catch (Throwable th) {
                LOG.warn("could not close statement", th);
            }
            finally {
                if (returnConnection && conn != null) {
                    this.returnConnection(conn);
                }
            }
        }
    }

    private void releaseStatementAndResultSet(Statement ps, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable th) {
                LOG.warn("could not close ResultSet", th);
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Throwable th) {
                LOG.warn("could not close statement", th);
            }
        }
    }

    public String buildSelectFirstSql(int rows, String coreSql) {
        return this.buildSelectFirstSql(rows, null, coreSql);
    }

    public abstract String buildSelectFirstSql(int var1, String var2, String var3);

    public long getMin(Connection conn, String table, String column) throws DataAccessException {
        return this.getMin(conn, table, column, null);
    }

    public long getMin(Connection conn, String table, String column, String condition) throws DataAccessException {
        ParamUtil.requireNonBlank((String)"table", (String)table);
        ParamUtil.requireNonBlank((String)"column", (String)column);
        int size = column.length() + table.length() + 20;
        if (StringUtil.isNotBlank((String)condition)) {
            size += 7 + condition.length();
        }
        StringBuilder sqlBuilder = new StringBuilder(size);
        sqlBuilder.append("SELECT MIN(").append(column).append(") FROM ").append(table);
        if (StringUtil.isNotBlank((String)condition)) {
            sqlBuilder.append(" WHERE ").append(condition);
        }
        String sql = sqlBuilder.toString();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn != null ? conn.createStatement() : this.getConnection().createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            long l = rs.getLong(1);
            if (conn == null) {
                this.releaseResources(stmt, rs);
            } else {
                this.releaseStatementAndResultSet(stmt, rs);
            }
            return l;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                if (conn == null) {
                    this.releaseResources(stmt, rs);
                } else {
                    this.releaseStatementAndResultSet(stmt, rs);
                }
                throw throwable;
            }
        }
    }

    public int getCount(Connection conn, String table) throws DataAccessException {
        ParamUtil.requireNonBlank((String)"table", (String)table);
        StringBuilder sqlBuilder = new StringBuilder(table.length() + 21);
        sqlBuilder.append("SELECT COUNT(*) FROM ").append(table);
        String sql = sqlBuilder.toString();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn != null ? conn.createStatement() : this.getConnection().createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            int n = rs.getInt(1);
            if (conn == null) {
                this.releaseResources(stmt, rs);
            } else {
                this.releaseStatementAndResultSet(stmt, rs);
            }
            return n;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                if (conn == null) {
                    this.releaseResources(stmt, rs);
                } else {
                    this.releaseStatementAndResultSet(stmt, rs);
                }
                throw throwable;
            }
        }
    }

    public long getMax(Connection conn, String table, String column) throws DataAccessException {
        return this.getMax(conn, table, column, null);
    }

    public long getMax(Connection conn, String table, String column, String condition) throws DataAccessException {
        ParamUtil.requireNonBlank((String)"table", (String)table);
        ParamUtil.requireNonBlank((String)"column", (String)column);
        int size = column.length() + table.length() + 20;
        if (StringUtil.isNotBlank((String)condition)) {
            size += 7 + condition.length();
        }
        StringBuilder sqlBuilder = new StringBuilder(size);
        sqlBuilder.append("SELECT MAX(").append(column).append(") FROM ").append(table);
        if (StringUtil.isNotBlank((String)condition)) {
            sqlBuilder.append(" WHERE ").append(condition);
        }
        String sql = sqlBuilder.toString();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn != null ? conn.createStatement() : this.getConnection().createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            long l = rs.getLong(1);
            if (conn == null) {
                this.releaseResources(stmt, rs);
            } else {
                this.releaseStatementAndResultSet(stmt, rs);
            }
            return l;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                if (conn == null) {
                    this.releaseResources(stmt, rs);
                } else {
                    this.releaseStatementAndResultSet(stmt, rs);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFromTable(Connection conn, String table, String idColumn, long id) {
        Connection tmpConn;
        ParamUtil.requireNonBlank((String)"table", (String)table);
        ParamUtil.requireNonBlank((String)"idColumn", (String)idColumn);
        StringBuilder sb = new StringBuilder(table.length() + idColumn.length() + 35);
        sb.append("DELETE FROM ").append(table).append(" WHERE ").append(idColumn).append("=").append(id);
        String sql = sb.toString();
        if (conn != null) {
            tmpConn = conn;
        } else {
            try {
                tmpConn = this.getConnection();
            }
            catch (Throwable th) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("datasource {} could not get connection: {}", (Object)this.name, (Object)th.getMessage());
                }
                return false;
            }
        }
        Statement stmt = null;
        try {
            stmt = tmpConn.createStatement();
            stmt.execute(sql);
        }
        catch (Throwable th) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("datasource {} could not deletefrom table {}: {}", new Object[]{this.name, table, th.getMessage()});
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn == null) {
                this.releaseResources(stmt, null);
            } else {
                this.releaseStatementAndResultSet(stmt, null);
            }
        }
        return true;
    }

    public boolean columnExists(Connection conn, String table, String column, Object value) throws DataAccessException {
        ParamUtil.requireNonBlank((String)"table", (String)table);
        ParamUtil.requireNonBlank((String)"column", (String)column);
        ParamUtil.requireNonNull((String)"value", (Object)value);
        StringBuilder sb = new StringBuilder(2 * column.length() + 15);
        sb.append(column).append(" FROM ").append(table);
        sb.append(" WHERE ").append(column).append("=?");
        String sql = this.buildSelectFirstSql(1, sb.toString());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = stmt = conn != null ? conn.prepareStatement(sql) : this.getConnection().prepareStatement(sql);
            if (value instanceof Integer) {
                stmt.setInt(1, (Integer)value);
            } else if (value instanceof Long) {
                stmt.setLong(1, (Long)value);
            } else if (value instanceof String) {
                stmt.setString(1, (String)value);
            } else {
                stmt.setString(1, value.toString());
            }
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            if (conn == null) {
                this.releaseResources(stmt, rs);
            } else {
                this.releaseStatementAndResultSet(stmt, rs);
            }
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                if (conn == null) {
                    this.releaseResources(stmt, rs);
                } else {
                    this.releaseStatementAndResultSet(stmt, rs);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableHasColumn(Connection conn, String table, String column) throws DataAccessException {
        Statement stmt;
        ParamUtil.requireNonBlank((String)"table", (String)table);
        ParamUtil.requireNonBlank((String)"column", (String)column);
        try {
            stmt = conn != null ? conn.createStatement() : this.getConnection().createStatement();
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
        StringBuilder sqlBuilder = new StringBuilder(column.length() + table.length() + 20);
        sqlBuilder.append(column).append(" FROM ").append(table);
        String sql = this.buildSelectFirstSql(1, sqlBuilder.toString());
        try {
            stmt.execute(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn == null) {
                this.releaseResources(stmt, null);
            } else {
                this.releaseStatementAndResultSet(stmt, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Connection conn, String table) throws DataAccessException {
        Statement stmt;
        ParamUtil.requireNonBlank((String)"table", (String)table);
        try {
            stmt = conn != null ? conn.createStatement() : this.getConnection().createStatement();
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
        StringBuilder sqlBuilder = new StringBuilder(table.length() + 10);
        sqlBuilder.append("1 FROM ").append(table);
        String sql = this.buildSelectFirstSql(1, sqlBuilder.toString());
        try {
            stmt.execute(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn == null) {
                this.releaseResources(stmt, null);
            } else {
                this.releaseStatementAndResultSet(stmt, null);
            }
        }
    }

    protected abstract String buildCreateSequenceSql(String var1, long var2);

    protected abstract String buildDropSequenceSql(String var1);

    protected abstract String buildNextSeqValueSql(String var1);

    protected final String buildAndCacheNextSeqValueSql(String sequenceName) {
        String sql = (String)this.cacheSeqNameSqls.get((Object)sequenceName);
        if (sql == null) {
            sql = this.buildNextSeqValueSql(sequenceName);
            this.cacheSeqNameSqls.put((Object)sequenceName, (Object)sql);
        }
        return sql;
    }

    protected boolean isUseSqlStateAsCode() {
        return false;
    }

    public void dropAndCreateSequence(String sequenceName, long startValue) throws DataAccessException {
        try {
            this.dropSequence(sequenceName);
        }
        catch (DataAccessException ex) {
            LOG.error("could not drop sequence {}: {}", (Object)sequenceName, (Object)ex.getMessage());
        }
        this.createSequence(sequenceName, startValue);
    }

    public void createSequence(String sequenceName, long startValue) throws DataAccessException {
        ParamUtil.requireNonBlank((String)"sequenceName", (String)sequenceName);
        String sql = this.buildCreateSequenceSql(sequenceName, startValue);
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
            LOG.info("datasource {} CREATESEQ {} START {}", new Object[]{this.name, sequenceName, startValue});
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    public void dropSequence(String sequenceName) throws DataAccessException {
        ParamUtil.requireNonBlank((String)"sequenceName", (String)sequenceName);
        String sql = this.buildDropSequenceSql(sequenceName);
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
            LOG.info("datasource {} DROPSEQ {}", (Object)this.name, (Object)sequenceName);
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    public void setLastUsedSeqValue(String sequenceName, long sequenceValue) {
        ParamUtil.requireNonBlank((String)"sequenceName", (String)sequenceName);
        this.lastUsedSeqValues.put(sequenceName, sequenceValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextSeqValue(Connection conn, String sequenceName) throws DataAccessException {
        long next;
        ParamUtil.requireNonBlank((String)"sequenceName", (String)sequenceName);
        String sql = this.buildAndCacheNextSeqValueSql(sequenceName);
        boolean newConn = conn == null;
        Connection tmpConn = conn != null ? conn : this.getConnection();
        Statement stmt = null;
        try {
            stmt = tmpConn.createStatement();
            while (true) {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    if (rs.next()) {
                        next = rs.getLong(1);
                        Object object = this.lastUsedSeqValuesLock;
                        synchronized (object) {
                            block17: {
                                Long lastValue = this.lastUsedSeqValues.get(sequenceName);
                                if (lastValue != null && next <= lastValue) break block17;
                                this.lastUsedSeqValues.put(sequenceName, next);
                                break;
                            }
                            continue;
                        }
                    }
                    throw new DataAccessException("could not increment the sequence " + sequenceName);
                }
                finally {
                    this.releaseStatementAndResultSet(null, rs);
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            if (newConn) {
                this.releaseResources(stmt, null);
            } else {
                this.releaseStatementAndResultSet(stmt, null);
            }
        }
        LOG.debug("datasource {} NEXVALUE({}): {}", new Object[]{this.name, sequenceName, next});
        return next;
    }

    protected String getSqlToDropPrimaryKey(String primaryKeyName, String table) {
        ParamUtil.requireNonBlank((String)"primaryKeyName", (String)primaryKeyName);
        ParamUtil.requireNonBlank((String)"table", (String)table);
        StringBuilder sql = new StringBuilder(table.length() + 30);
        return sql.append("ALTER TABLE ").append(table).append(" DROP PRIMARY KEY ").toString();
    }

    public void dropPrimaryKey(Connection conn, String primaryKeyName, String table) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropPrimaryKey(primaryKeyName, table));
    }

    protected String getSqlToAddPrimaryKey(String primaryKeyName, String table, String ... columns) {
        ParamUtil.requireNonBlank((String)"primaryKeyName", (String)primaryKeyName);
        ParamUtil.requireNonBlank((String)"table", (String)table);
        StringBuilder sb = new StringBuilder(100);
        sb.append("ALTER TABLE ").append(table);
        sb.append(" ADD CONSTRAINT ").append(primaryKeyName);
        sb.append(" PRIMARY KEY (");
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public void addPrimaryKey(Connection conn, String primaryKeyName, String table, String ... columns) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToAddPrimaryKey(primaryKeyName, table, columns));
    }

    protected String getSqlToDropForeignKeyConstraint(String constraintName, String baseTable) throws DataAccessException {
        ParamUtil.requireNonBlank((String)"constraintName", (String)constraintName);
        ParamUtil.requireNonBlank((String)"baseTable", (String)baseTable);
        StringBuilder sb = new StringBuilder(baseTable.length() + constraintName.length() + 30);
        return sb.append("ALTER TABLE ").append(baseTable).append(" DROP CONSTRAINT ").append(constraintName).toString();
    }

    public void dropForeignKeyConstraint(Connection conn, String constraintName, String baseTable) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropForeignKeyConstraint(constraintName, baseTable));
    }

    protected String getSqlToAddForeignKeyConstraint(String constraintName, String baseTable, String baseColumn, String referencedTable, String referencedColumn, String onDeleteAction, String onUpdateAction) {
        ParamUtil.requireNonBlank((String)"constraintName", (String)constraintName);
        ParamUtil.requireNonBlank((String)"baseTable", (String)baseTable);
        ParamUtil.requireNonBlank((String)"baseColumn", (String)baseColumn);
        ParamUtil.requireNonBlank((String)"referencedTable", (String)referencedTable);
        ParamUtil.requireNonBlank((String)"referencedColumn", (String)referencedColumn);
        ParamUtil.requireNonBlank((String)"onDeleteAction", (String)onDeleteAction);
        ParamUtil.requireNonBlank((String)"onUpdateAction", (String)onUpdateAction);
        StringBuilder sb = new StringBuilder(100);
        sb.append("ALTER TABLE ").append(baseTable);
        sb.append(" ADD CONSTRAINT ").append(constraintName);
        sb.append(" FOREIGN KEY (").append(baseColumn).append(")");
        sb.append(" REFERENCES ").append(referencedTable);
        sb.append(" (").append(referencedColumn).append(")");
        sb.append(" ON DELETE ").append(onDeleteAction);
        sb.append(" ON UPDATE ").append(onUpdateAction);
        return sb.toString();
    }

    public void addForeignKeyConstraint(Connection conn, String constraintName, String baseTable, String baseColumn, String referencedTable, String referencedColumn, String onDeleteAction, String onUpdateAction) throws DataAccessException {
        String sql = this.getSqlToAddForeignKeyConstraint(constraintName, baseTable, baseColumn, referencedTable, referencedColumn, onDeleteAction, onUpdateAction);
        this.executeUpdate(conn, sql);
    }

    protected String getSqlToDropIndex(String table, String indexName) {
        ParamUtil.requireNonBlank((String)"indexName", (String)indexName);
        return "DROP INDEX " + indexName;
    }

    public void dropIndex(Connection conn, String table, String indexName) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropIndex(table, indexName));
    }

    protected String getSqlToCreateIndex(String indexName, String table, String ... columns) {
        ParamUtil.requireNonBlank((String)"indexName", (String)indexName);
        ParamUtil.requireNonBlank((String)"table", (String)table);
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("columns must not be null and empty");
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE INDEX ").append(indexName);
        sb.append(" ON ").append(table).append("(");
        for (String column : columns) {
            ParamUtil.requireNonBlank((String)"column", (String)column);
            sb.append(column).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public void createIndex(Connection conn, String indexName, String table, String ... columns) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToCreateIndex(indexName, table, columns));
    }

    protected String getSqlToDropUniqueConstraint(String constraintName, String table) {
        ParamUtil.requireNonBlank((String)"table", (String)table);
        ParamUtil.requireNonBlank((String)"constraintName", (String)constraintName);
        StringBuilder sb = new StringBuilder(table.length() + constraintName.length() + 30);
        return sb.append("ALTER TABLE ").append(table).append(" DROP CONSTRAINT ").append(constraintName).toString();
    }

    public void dropUniqueConstrain(Connection conn, String constraintName, String table) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropUniqueConstraint(constraintName, table));
    }

    protected String getSqlToAddUniqueConstrain(String constraintName, String table, String ... columns) {
        ParamUtil.requireNonBlank((String)"constraintName", (String)constraintName);
        ParamUtil.requireNonBlank((String)"table", (String)table);
        StringBuilder sb = new StringBuilder(100);
        sb.append("ALTER TABLE ").append(table);
        sb.append(" ADD CONSTRAINT ").append(constraintName);
        sb.append(" UNIQUE (");
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public void addUniqueConstrain(Connection conn, String constraintName, String table, String ... columns) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToAddUniqueConstrain(constraintName, table, columns));
    }

    public DataAccessException translate(String sql, SQLException ex) {
        String sqlState;
        String errorCode;
        SQLException nestedSqlEx;
        SQLException sqlEx;
        ParamUtil.requireNonNull((String)"ex", (Object)ex);
        String tmpSql = sql;
        if (tmpSql == null) {
            tmpSql = "";
        }
        if ((sqlEx = ex) instanceof BatchUpdateException && sqlEx.getNextException() != null && ((nestedSqlEx = sqlEx.getNextException()).getErrorCode() > 0 || nestedSqlEx.getSQLState() != null)) {
            LOG.debug("Using nested SQLException from the BatchUpdateException");
            sqlEx = nestedSqlEx;
        }
        if (this.sqlErrorCodes.isUseSqlStateForTranslation()) {
            errorCode = sqlEx.getSQLState();
            sqlState = null;
        } else {
            SQLException current = sqlEx;
            while (current.getErrorCode() == 0 && current.getCause() instanceof SQLException) {
                current = (SQLException)current.getCause();
            }
            errorCode = Integer.toString(current.getErrorCode());
            sqlState = current.getSQLState();
        }
        if (errorCode != null) {
            if (this.sqlErrorCodes.badSqlGrammarCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new BadSqlGrammarException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.invalidResultSetAccessCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new InvalidResultSetAccessException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.duplicateKeyCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new DuplicateKeyException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.dataIntegrityViolationCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new DataIntegrityViolationException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.permissionDeniedCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new PermissionDeniedDataAccessException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.dataAccessResourceFailureCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new DataAccessResourceFailureException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.transientDataAccessResourceCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new TransientDataAccessResourceException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.cannotAcquireLockCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new CannotAcquireLockException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.deadlockLoserCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new DeadlockLoserDataAccessException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.cannotSerializeTransactionCodes().contains(errorCode)) {
                this.logTranslation(tmpSql, sqlEx);
                return new CannotSerializeTransactionException(this.buildMessage(tmpSql, sqlEx), sqlEx);
            }
        }
        if (sqlState != null && sqlState.length() >= 2) {
            String classCode = sqlState.substring(0, 2);
            if (this.sqlStateCodes.badSqlGrammarCodes().contains(classCode)) {
                return new BadSqlGrammarException(this.buildMessage(tmpSql, sqlEx), ex);
            }
            if (this.sqlStateCodes.dataIntegrityViolationCodes().contains(classCode)) {
                return new DataIntegrityViolationException(this.buildMessage(tmpSql, ex), ex);
            }
            if (this.sqlStateCodes.dataAccessResourceFailureCodes().contains(classCode)) {
                return new DataAccessResourceFailureException(this.buildMessage(tmpSql, ex), ex);
            }
            if (this.sqlStateCodes.transientDataAccessResourceCodes().contains(classCode)) {
                return new TransientDataAccessResourceException(this.buildMessage(tmpSql, ex), ex);
            }
            if (this.sqlStateCodes.concurrencyFailureCodes().contains(classCode)) {
                return new ConcurrencyFailureException(this.buildMessage(tmpSql, ex), ex);
            }
        }
        if (ex.getClass().getName().contains("Timeout")) {
            return new QueryTimeoutException(this.buildMessage(tmpSql, ex), ex);
        }
        if (LOG.isDebugEnabled()) {
            String codes = this.sqlErrorCodes.isUseSqlStateForTranslation() ? new StringBuilder(60).append("SQL state '").append(sqlEx.getSQLState()).append("', error code '").append(sqlEx.getErrorCode()).toString() : "Error code '" + sqlEx.getErrorCode() + "'";
            LOG.debug("Unable to translate SQLException with " + codes);
        }
        return new UncategorizedSqlException(this.buildMessage(tmpSql, sqlEx), sqlEx);
    }

    private void logTranslation(String sql, SQLException sqlEx) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Translating SQLException: SQL state '{}', error code '{}', message [{}]; SQL was [{}]", new Object[]{sqlEx.getSQLState(), sqlEx.getErrorCode(), sqlEx.getMessage(), sql});
    }

    private String buildMessage(String sql, SQLException ex) {
        String msg = ex.getMessage();
        StringBuilder sb = new StringBuilder(msg.length() + sql.length() + 8);
        return sb.append("SQL [").append(sql).append("]; ").append(ex.getMessage()).toString();
    }

    private void executeUpdate(Connection conn, String sql) throws DataAccessException {
        Statement stmt = null;
        try {
            stmt = conn != null ? conn.createStatement() : this.getConnection().createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            if (conn == null) {
                this.releaseResources(stmt, null);
            } else {
                this.releaseStatementAndResultSet(stmt, null);
            }
        }
    }

    static DataSourceWrapper createDataSource(String name, Properties props, DatabaseType databaseType) {
        String propName;
        ParamUtil.requireNonNull((String)"props", (Object)props);
        ParamUtil.requireNonNull((String)"databaseType", (Object)((Object)databaseType));
        String datasourceClassName = props.getProperty("dataSourceClassName");
        if (datasourceClassName != null) {
            String upperCaseSchema;
            String schema;
            if (datasourceClassName.contains(".db2.") && (schema = props.getProperty(propName = "dataSource.currentSchema")) != null && !schema.equals(upperCaseSchema = schema.toUpperCase())) {
                props.setProperty(propName, upperCaseSchema);
            }
        } else {
            String sep;
            int idx;
            propName = "jdbcUrl";
            String url = props.getProperty(propName);
            if (StringUtil.startsWithIgnoreCase((String)url, (String)"jdbc:db2:") && (idx = url.indexOf(sep = ":currentSchema=")) != 1) {
                String upperCaseSchema;
                String schema = url.substring(idx + sep.length());
                if (schema.endsWith(";")) {
                    schema = schema.substring(0, schema.length() - 1);
                }
                if (!schema.equals(upperCaseSchema = schema.toUpperCase())) {
                    String newUrl = url.replace(sep + schema, sep + upperCaseSchema);
                    props.setProperty(propName, newUrl);
                }
            }
        }
        if (databaseType == DatabaseType.DB2 || databaseType == DatabaseType.H2 || databaseType == DatabaseType.HSQL || databaseType == DatabaseType.MYSQL || databaseType == DatabaseType.MARIADB || databaseType == DatabaseType.ORACLE || databaseType == DatabaseType.POSTGRES) {
            HikariConfig conf = new HikariConfig(props);
            HikariDataSource service = new HikariDataSource(conf);
            switch (databaseType) {
                case DB2: {
                    return new DB2(name, service);
                }
                case H2: {
                    return new H2(name, service);
                }
                case HSQL: {
                    return new HSQL(name, service);
                }
                case MYSQL: {
                    return new MySQL(name, service);
                }
                case MARIADB: {
                    return new MariaDB(name, service);
                }
                case ORACLE: {
                    return new Oracle(name, service);
                }
            }
            return new PostgreSQL(name, service);
        }
        throw new IllegalArgumentException("unknown datasource type " + (Object)((Object)databaseType));
    }

    private static class HSQL
    extends DataSourceWrapper {
        HSQL(String name, HikariDataSource service) {
            super(name, service, DatabaseType.HSQL);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            int size = coreSql.length() + 18;
            if (StringUtil.isNotBlank((String)orderBy)) {
                size += 10;
                size += orderBy.length();
            }
            StringBuilder sql = new StringBuilder(size);
            sql.append("SELECT ").append(coreSql);
            if (StringUtil.isNotBlank((String)orderBy)) {
                sql.append(" ORDER BY ").append(orderBy);
            }
            return sql.append(" LIMIT ").append(rows).toString();
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 70);
            sql.append("CREATE SEQUENCE ").append(sequenceName);
            sql.append(" AS BIGINT START WITH ").append(startValue);
            return sql.append(" INCREMENT BY 1").toString();
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 14);
            return sql.append("DROP SEQUENCE ").append(sequenceName).toString();
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 20);
            return sql.append("SELECT NEXTVAL ('").append(sequenceName).append("')").toString();
        }
    }

    private static class H2
    extends DataSourceWrapper {
        H2(String name, HikariDataSource service) {
            super(name, service, DatabaseType.H2);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            int size = coreSql.length() + 18;
            if (StringUtil.isNotBlank((String)orderBy)) {
                size += 10;
                size += orderBy.length();
            }
            StringBuilder sql = new StringBuilder(size);
            sql.append("SELECT ").append(coreSql);
            if (StringUtil.isNotBlank((String)orderBy)) {
                sql.append(" ORDER BY ").append(orderBy);
            }
            sql.append(" LIMIT ").append(rows);
            return sql.toString();
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 80);
            sql.append("CREATE SEQUENCE ").append(sequenceName);
            sql.append(" START WITH ").append(startValue);
            return sql.append(" INCREMENT BY 1 NO CYCLE NO CACHE").toString();
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 14);
            return sql.append("DROP SEQUENCE ").append(sequenceName).toString();
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 20);
            return sql.append("SELECT NEXTVAL ('").append(sequenceName).append("')").toString();
        }
    }

    private static class Oracle
    extends DataSourceWrapper {
        Oracle(String name, HikariDataSource service) {
            super(name, service, DatabaseType.ORACLE);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            int size = coreSql.length() + 18;
            size += StringUtil.isBlank((String)orderBy) ? 14 : orderBy.length() + 40;
            StringBuilder sql = new StringBuilder(size += 14);
            if (StringUtil.isBlank((String)orderBy)) {
                sql.append("SELECT ").append(coreSql);
                if (coreSql.contains(" WHERE")) {
                    sql.append(" AND");
                } else {
                    sql.append(" WHERE");
                }
            } else {
                sql.append("SELECT * FROM (SELECT ");
                sql.append(coreSql);
                sql.append(" ORDER BY ").append(orderBy).append(" ) WHERE");
            }
            return sql.append(" ROWNUM<").append(rows + 1).toString();
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 59);
            sql.append("CREATE SEQUENCE ").append(sequenceName);
            sql.append(" START WITH ").append(startValue);
            return sql.append(" INCREMENT BY 1 NOCYCLE NOCACHE").toString();
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 14);
            return sql.append("DROP SEQUENCE ").append(sequenceName).toString();
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 21);
            sql.append("SELECT ").append(sequenceName).append(".NEXTVAL FROM DUAL");
            return sql.toString();
        }

        @Override
        protected String getSqlToDropPrimaryKey(String primaryKeyName, String table) {
            return this.getSqlToDropUniqueConstraint(primaryKeyName, table);
        }

        @Override
        protected String getSqlToDropUniqueConstraint(String contraintName, String table) {
            StringBuilder sql = new StringBuilder(table.length() + contraintName.length() + 40);
            return sql.append("ALTER TABLE ").append(table).append(" DROP CONSTRAINT ").append(contraintName).append(" DROP INDEX").toString();
        }

        @Override
        protected String getSqlToAddForeignKeyConstraint(String constraintName, String baseTable, String baseColumn, String referencedTable, String referencedColumn, String onDeleteAction, String onUpdateAction) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("ALTER TABLE ").append(baseTable);
            sb.append(" ADD CONSTRAINT ").append(constraintName);
            sb.append(" FOREIGN KEY (").append(baseColumn).append(")");
            sb.append(" REFERENCES ").append(referencedTable);
            sb.append(" (").append(referencedColumn).append(")");
            return sb.append(" ON DELETE ").append(onDeleteAction).toString();
        }

        @Override
        protected String getSqlToAddPrimaryKey(String primaryKeyName, String table, String ... columns) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("ALTER TABLE ").append(table);
            sb.append(" ADD CONSTRAINT ").append(primaryKeyName);
            sb.append(" PRIMARY KEY(");
            int n = columns.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(columns[i]);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    private static class PostgreSQL
    extends DataSourceWrapper {
        PostgreSQL(String name, HikariDataSource service) {
            super(name, service, DatabaseType.POSTGRES);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            int size = coreSql.length() + 34;
            if (StringUtil.isNotBlank((String)orderBy)) {
                size += 10;
                size += orderBy.length();
            }
            StringBuilder sql = new StringBuilder(size);
            sql.append("SELECT ").append(coreSql);
            if (StringUtil.isNotBlank((String)orderBy)) {
                sql.append(" ORDER BY ").append(orderBy);
            }
            return sql.append(" FETCH FIRST ").append(rows).append(" ROWS ONLY").toString();
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 70);
            sql.append("CREATE SEQUENCE ").append(sequenceName).append(" START WITH ");
            return sql.append(startValue).append(" INCREMENT BY 1 NO CYCLE").toString();
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 14);
            return sql.append("DROP SEQUENCE ").append(sequenceName).toString();
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 20);
            return sql.append("SELECT NEXTVAL ('").append(sequenceName).append("')").toString();
        }

        @Override
        protected boolean isUseSqlStateAsCode() {
            return true;
        }

        @Override
        protected String getSqlToDropPrimaryKey(String primaryKeyName, String table) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("DO $$ DECLARE constraint_name varchar;\n");
            sb.append("BEGIN\n");
            sb.append("  SELECT tc.CONSTRAINT_NAME into strict constraint_name\n");
            sb.append("  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc\n");
            sb.append("  WHERE CONSTRAINT_TYPE='PRIMARY KEY'\n");
            sb.append("  AND TABLE_NAME='").append(table.toLowerCase()).append("' AND TABLE_SCHEMA='public';\n");
            sb.append("  EXECUTE 'alter table public.").append(table.toLowerCase()).append(" drop constraint ' || constraint_name;\n");
            sb.append("END $$;");
            return sb.toString();
        }
    }

    private static class DB2
    extends DataSourceWrapper {
        DB2(String name, HikariDataSource service) {
            super(name, service, DatabaseType.DB2);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            int size = coreSql.length() + 36;
            if (StringUtil.isNotBlank((String)orderBy)) {
                size += 10;
                size += orderBy.length();
            }
            StringBuilder sql = new StringBuilder(size);
            sql.append("SELECT ").append(coreSql);
            if (StringUtil.isNotBlank((String)orderBy)) {
                sql.append(" ORDER BY ").append(orderBy);
            }
            return sql.append(" FETCH FIRST ").append(rows).append(" ROWS ONLY").toString();
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 80);
            sql.append("CREATE SEQUENCE ").append(sequenceName).append(" AS BIGINT START WITH ");
            return sql.append(startValue).append(" INCREMENT BY 1 NO CYCLE NO CACHE").toString();
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 14);
            return sql.append("DROP SEQUENCE ").append(sequenceName).toString();
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 44);
            sql.append("SELECT NEXT VALUE FOR ").append(sequenceName).append(" FROM sysibm.sysdummy1");
            return sql.toString();
        }
    }

    private static class MariaDB
    extends MySQL {
        MariaDB(String name, HikariDataSource service) {
            super(name, service, DatabaseType.MARIADB);
        }
    }

    private static class MySQL
    extends DataSourceWrapper {
        MySQL(String name, HikariDataSource service) {
            super(name, service, DatabaseType.MYSQL);
        }

        MySQL(String name, HikariDataSource service, DatabaseType type) {
            super(name, service, type);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            int size = coreSql.length() + 18;
            if (StringUtil.isNotBlank((String)orderBy)) {
                size += 10;
                size += orderBy.length();
            }
            StringBuilder sql = new StringBuilder(size);
            sql.append("SELECT ").append(coreSql);
            if (StringUtil.isNotBlank((String)orderBy)) {
                sql.append(" ORDER BY ").append(orderBy);
            }
            return sql.append(" LIMIT ").append(rows).toString();
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 75);
            sql.append("INSERT INTO SEQ_TBL (SEQ_NAME,SEQ_VALUE) VALUES('");
            return sql.append(sequenceName).append("', ").append(startValue).append(")").toString();
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 40);
            sql.append("DELETE FROM SEQ_TBL WHERE SEQ_NAME='").append(sequenceName).append("'");
            return sql.toString();
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            StringBuilder sql = new StringBuilder(sequenceName.length() + 75);
            sql.append("UPDATE SEQ_TBL SET SEQ_VALUE=(@cur_value:=SEQ_VALUE)+1 WHERE SEQ_NAME='");
            return sql.append(sequenceName).append("'").toString();
        }

        @Override
        public long nextSeqValue(Connection conn, String sequenceName) throws DataAccessException {
            long ret;
            block8: {
                ResultSet rs;
                Statement stmt;
                block7: {
                    String sqlUpdate = this.buildAndCacheNextSeqValueSql(sequenceName);
                    String sqlSelect = "SELECT @cur_value";
                    String sql = null;
                    boolean newConn = conn == null;
                    Connection tmpConn = conn != null ? conn : this.getConnection();
                    stmt = null;
                    rs = null;
                    try {
                        stmt = tmpConn.createStatement();
                        sql = sqlUpdate;
                        stmt.executeUpdate(sql);
                        sql = "SELECT @cur_value";
                        rs = stmt.executeQuery(sql);
                        if (!rs.next()) {
                            throw new DataAccessException("could not increment the sequence " + sequenceName);
                        }
                        ret = rs.getLong(1);
                        if (!newConn) break block7;
                    }
                    catch (SQLException ex) {
                        try {
                            throw this.translate(sqlUpdate, ex);
                        }
                        catch (Throwable throwable) {
                            if (newConn) {
                                this.releaseResources(stmt, rs);
                            } else {
                                ((DataSourceWrapper)this).releaseStatementAndResultSet(stmt, rs);
                            }
                            throw throwable;
                        }
                    }
                    this.releaseResources(stmt, rs);
                    break block8;
                }
                ((DataSourceWrapper)this).releaseStatementAndResultSet(stmt, rs);
            }
            LOG.debug("datasource {} NEXVALUE({}): {}", new Object[]{this.name, sequenceName, ret});
            return ret;
        }

        @Override
        protected String getSqlToDropForeignKeyConstraint(String constraintName, String baseTable) throws DataAccessException {
            StringBuilder sb = new StringBuilder(baseTable.length() + constraintName.length() + 30);
            return sb.append("ALTER TABLE ").append(baseTable).append(" DROP FOREIGN KEY ").append(constraintName).toString();
        }

        @Override
        protected String getSqlToDropIndex(String table, String indexName) {
            StringBuilder sb = new StringBuilder(indexName.length() + table.length() + 15);
            return sb.append("DROP INDEX ").append(indexName).append(" ON ").append(table).toString();
        }

        @Override
        protected String getSqlToDropUniqueConstraint(String constraintName, String table) {
            StringBuilder sb = new StringBuilder(constraintName.length() + table.length() + 22);
            return sb.append("ALTER TABLE ").append(table).append(" DROP KEY ").append(constraintName).toString();
        }
    }
}

