/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlbeam.AutoList;
import org.xmlbeam.DomChangeTracker;
import org.xmlbeam.ProjectionInvocationHandler;
import org.xmlbeam.dom.DOMAccess;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.exceptions.XBPathException;
import org.xmlbeam.types.TypeConverter;
import org.xmlbeam.types.XBAutoList;
import org.xmlbeam.types.XBAutoMap;
import org.xmlbeam.util.intern.DOMHelper;
import org.xmlbeam.util.intern.duplex.DuplexExpression;
import org.xmlbeam.util.intern.duplex.DuplexXPathParser;
import org.xmlbeam.util.intern.duplex.ExpressionType;

public class AutoMap<T>
extends AbstractMap<String, T>
implements XBAutoMap<T>,
DOMAccess {
    private static final Comparator<Map.Entry<String, ?>> ENTRY_COMPARATOR = new Comparator<Map.Entry<String, ?>>(){

        @Override
        public int compare(Map.Entry<String, ?> o1, Map.Entry<String, ?> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };
    private final InvocationContext invocationContext;
    private final Node baseNode;
    private Node boundNode;
    private final TypeConverter typeConverter;
    private final DomChangeTracker domChangeTracker = new DomChangeTracker(){

        @Override
        void refresh(boolean forWrite) throws XPathExpressionException {
            if (AutoMap.this.invocationContext.getxPathExpression() == null) {
                AutoMap.this.boundNode = AutoMap.this.baseNode;
                return;
            }
            NodeList nodes = (NodeList)AutoMap.this.invocationContext.getxPathExpression().evaluate(AutoMap.this.baseNode, XPathConstants.NODESET);
            if (nodes.getLength() == 0 && forWrite) {
                AutoMap.this.boundNode = AutoMap.this.invocationContext.getDuplexExpression().ensureExistence(AutoMap.this.baseNode);
            } else {
                AutoMap.this.boundNode = nodes.getLength() == 0 ? null : (Element)nodes.item(0);
            }
        }
    };
    private final Class<?> valueType;

    public AutoMap(Node baseNode, InvocationContext invocationContext, Class<?> valueType) {
        this.invocationContext = invocationContext;
        this.baseNode = baseNode;
        this.invocationContext.getProjector().addDOMChangeListener(this.domChangeTracker);
        this.typeConverter = invocationContext.getProjector().config().getTypeConverter();
        this.valueType = valueType;
    }

    @Override
    public void clear() {
        this.domChangeTracker.refreshForReadIfNeeded();
        if (this.boundNode != null) {
            DOMHelper.removeAllChildren(this.boundNode);
        }
    }

    @Override
    @Deprecated
    public T get(Object path) {
        if (!(path instanceof CharSequence)) {
            throw new IllegalArgumentException("parameter path must be a CharSequence containing a relative XPath expression.");
        }
        return this.get((CharSequence)CharSequence.class.cast(path));
    }

    @Override
    public T get(CharSequence path) {
        return (T)this.get(path, this.invocationContext.getTargetComponentType());
    }

    @Override
    public <E> E get(CharSequence path, Class<E> asType) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Parameter path must not be empty or null");
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        if (this.boundNode == null) {
            return null;
        }
        Document document = DOMHelper.getOwnerDocumentFor(this.baseNode);
        DuplexExpression duplexExpression = new DuplexXPathParser(this.invocationContext.getProjector().config().getUserDefinedNamespaceMapping()).compile(path);
        try {
            XPathExpression expression = this.invocationContext.getProjector().config().createXPath(document).compile(duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            Node prevNode = (Node)expression.evaluate(this.boundNode, XPathConstants.NODE);
            InvocationContext tempContext = new InvocationContext(this.invocationContext.getResolvedXPath(), this.invocationContext.getxPath(), expression, duplexExpression, null, asType, this.invocationContext.getProjector());
            Object value = DefaultXPathEvaluator.convertToComponentType(tempContext, prevNode, asType);
            return value;
        }
        catch (XPathExpressionException e) {
            throw new XBPathException(e, path);
        }
    }

    @Override
    public XBAutoList<T> getList(CharSequence path) {
        return this.getList(path, this.invocationContext.getTargetComponentType());
    }

    @Override
    public <E> XBAutoList<E> getList(CharSequence path, Class<E> oType) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Parameter path must not be empty or null");
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        if (this.boundNode == null) {
            return AutoList.emptyList();
        }
        Document document = DOMHelper.getOwnerDocumentFor(this.baseNode);
        DuplexExpression duplexExpression = new DuplexXPathParser(this.invocationContext.getProjector().config().getUserDefinedNamespaceMapping()).compile(path);
        try {
            XPathExpression expression = this.invocationContext.getProjector().config().createXPath(document).compile(duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            InvocationContext tempContext = new InvocationContext(this.invocationContext.getResolvedXPath(), this.invocationContext.getxPath(), expression, duplexExpression, null, oType, this.invocationContext.getProjector());
            return new AutoList(this.boundNode, tempContext);
        }
        catch (XPathExpressionException e) {
            throw new XBPathException(e, path);
        }
    }

    @Override
    @Deprecated
    public boolean containsKey(Object path) {
        if (!(path instanceof CharSequence)) {
            throw new IllegalArgumentException("parameter path must be a CharSequence containing a relative XPath expression.");
        }
        return this.containsKey((CharSequence)CharSequence.class.cast(path));
    }

    @Override
    public boolean containsKey(CharSequence path) {
        return this.get(path) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return super.containsValue(value);
    }

    @Override
    public T put(String path, T value) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter path must not be null");
        }
        if (value == null) {
            return this.remove(path);
        }
        if (this.boundNode == null) {
            this.domChangeTracker.domChanged();
        }
        this.domChangeTracker.refreshForWriteIfNeeded();
        assert (this.boundNode != null) : "Bound node does not exist. No evaluation possible";
        Document document = DOMHelper.getOwnerDocumentFor(this.baseNode);
        DuplexExpression duplexExpression = new DuplexXPathParser(this.invocationContext.getProjector().config().getUserDefinedNamespaceMapping()).compile(path);
        if (ExpressionType.ATTRIBUTE == duplexExpression.getExpressionType() && ProjectionInvocationHandler.isStructureChangingType(this.valueType)) {
            throw new IllegalArgumentException("Value of type " + this.valueType + "can not be written to XML attributes. Choose a different xpath expression or use a different map component type");
        }
        try {
            XPathExpression expression = this.invocationContext.getProjector().config().createXPath(document).compile(duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            Node prevNode = (Node)expression.evaluate(this.boundNode, XPathConstants.NODE);
            Object previousValue = DefaultXPathEvaluator.convertToComponentType(this.invocationContext, prevNode, this.invocationContext.getTargetComponentType());
            if (ProjectionInvocationHandler.isStructureChangingValue(value)) {
                Element parent = duplexExpression.ensureParentExistence(this.boundNode);
                if (Node.class.isAssignableFrom(this.invocationContext.getTargetComponentType())) {
                    if (!(value instanceof Node)) {
                        throw new IllegalArgumentException("Parameter value is not a DOM node.");
                    }
                    parent.appendChild((Node)value);
                    return (T)previousValue;
                }
                if (this.invocationContext.getTargetComponentType().isInterface()) {
                    if (!(value instanceof DOMAccess)) {
                        throw new IllegalArgumentException("Parameter value is not a subprojection.");
                    }
                    DOMHelper.appendClone(parent, ((DOMAccess)DOMAccess.class.cast(value)).getDOMNode());
                }
                return (T)previousValue;
            }
            assert (this.boundNode != null) : "Without bound node, there is no context where something could be created in.";
            Node node = duplexExpression.ensureExistence(this.boundNode);
            node.setTextContent(value.toString());
            return (T)previousValue;
        }
        catch (XPathExpressionException e) {
            throw new XBPathException(e, path);
        }
    }

    @Override
    @Deprecated
    public T remove(Object path) {
        if (!(path instanceof CharSequence)) {
            throw new IllegalArgumentException("parameter path must be a CharSequence or String containing a relative XPath expression.");
        }
        return this.remove((CharSequence)CharSequence.class.cast(path));
    }

    public T remove(CharSequence xpath) {
        if (xpath == null || xpath.length() == 0) {
            throw new IllegalArgumentException("Parameter path must not be empty or null");
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        Document document = DOMHelper.getOwnerDocumentFor(this.baseNode);
        DuplexExpression duplexExpression = new DuplexXPathParser(this.invocationContext.getProjector().config().getUserDefinedNamespaceMapping()).compile(xpath);
        try {
            XPathExpression expression = this.invocationContext.getProjector().config().createXPath(document).compile(duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            Node prevNode = (Node)expression.evaluate(this.boundNode, XPathConstants.NODE);
            if (prevNode == null) {
                return null;
            }
            Object value = DefaultXPathEvaluator.convertToComponentType(this.invocationContext, prevNode, this.invocationContext.getTargetComponentType());
            duplexExpression.deleteAllMatchingChildren(prevNode.getParentNode());
            return (T)value;
        }
        catch (XPathExpressionException e) {
            throw new XBPathException(e, xpath);
        }
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        this.domChangeTracker.refreshForReadIfNeeded();
        if (this.boundNode == null) {
            return Collections.emptySet();
        }
        TreeSet set = new TreeSet<Map.Entry<String, T>>(ENTRY_COMPARATOR){};
        if (this.invocationContext.getTargetComponentType().isInterface() || Node.class.isAssignableFrom(this.invocationContext.getTargetComponentType())) {
            this.collectChildren(set, this.boundNode, ".");
        } else {
            this.collectChildrenValues(set, this.boundNode, ".");
        }
        return set;
    }

    private <E> void collectChildren(Set<Map.Entry<String, E>> set, Node n, String path) {
        if (n.getNodeType() == 2) {
            return;
        }
        NodeList childNodes = n.getChildNodes();
        if (childNodes == null) {
            return;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            String childPath = path + "/" + child.getNodeName();
            Object value = DefaultXPathEvaluator.convertToComponentType(this.invocationContext, child, this.invocationContext.getTargetComponentType());
            if (value != null) {
                set.add(new AbstractMap.SimpleEntry(childPath, value));
            }
            this.collectChildren(set, child, childPath);
        }
    }

    private <E> void collectChildrenValues(Set<Map.Entry<String, E>> set, Node n, String path) {
        NodeList childNodes;
        int i;
        NamedNodeMap attributes;
        if (n.getNodeType() == 3) {
            return;
        }
        if (String.class.isAssignableFrom(this.invocationContext.getTargetComponentType()) && (attributes = n.getAttributes()) != null) {
            for (i = 0; i < attributes.getLength(); ++i) {
                set.add(new AbstractMap.SimpleEntry<String, String>(path + "/@" + attributes.item(i).getNodeName(), attributes.item(i).getNodeValue()));
            }
        }
        if ((childNodes = n.getChildNodes()) == null) {
            return;
        }
        for (i = 0; i < childNodes.getLength(); ++i) {
            Object value;
            String stringContent;
            Node child = childNodes.item(i);
            if (child.getNodeType() == 3) continue;
            String childPath = path + "/" + child.getNodeName();
            if (this.typeConverter.isConvertable(this.invocationContext.getTargetComponentType()) && (stringContent = DOMHelper.directTextContent(child)) != null && !stringContent.isEmpty() && (value = this.typeConverter.convertTo(this.invocationContext.getTargetComponentType(), stringContent, this.invocationContext.getExpressionFormatPattern())) != null) {
                set.add(new AbstractMap.SimpleEntry(childPath, value));
            }
            this.collectChildrenValues(set, child, childPath);
        }
    }

    public Node getNode() {
        this.domChangeTracker.refreshForReadIfNeeded();
        return this.boundNode;
    }

    @Override
    public Class<?> getProjectionInterface() {
        return XBAutoMap.class;
    }

    @Override
    public Node getDOMNode() {
        return this.boundNode;
    }

    @Override
    public Document getDOMOwnerDocument() {
        return DOMHelper.getOwnerDocumentFor(this.boundNode);
    }

    @Override
    public Element getDOMBaseElement() {
        if (this.baseNode.getNodeType() == 9) {
            return ((Document)this.baseNode).getDocumentElement();
        }
        return (Element)this.baseNode;
    }

    @Override
    public String asString() {
        return this.invocationContext.getProjector().asString(this);
    }

    @Override
    public DOMAccess create(String path, Object value) {
        if (!this.valueType.isInstance(value)) {
            throw new IllegalArgumentException("value must be the component type");
        }
        this.put(path, value);
        return this;
    }
}

