/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.xel.zel.ELFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expressions {
    private static final Logger log = LoggerFactory.getLogger(Expressions.class);
    public static final FunctionMapper EMPTY_MAPPER = new EmptyMapper();
    public static final VariableResolver EMPTY_RESOLVER = new EmptyResolver();
    public static final Expression DUMMY_EXPRESSION = new DummyExpr();
    private static Class<? extends ExpressionFactory> _expfcls;
    private static final FactoryProvider _provider;

    public static final ExpressionFactory newExpressionFactory() throws XelException {
        return Expressions.newExpressionFactory(_expfcls);
    }

    public static final ExpressionFactory newExpressionFactory(Class<? extends ExpressionFactory> expfcls) {
        if (expfcls == null) {
            expfcls = _expfcls;
        }
        if (expfcls != null) {
            try {
                return expfcls.newInstance();
            }
            catch (Throwable ex) {
                throw XelException.Aide.wrap(ex, "Unable to instantiate " + expfcls);
            }
        }
        return Expressions.newDefautFactory();
    }

    private static final ExpressionFactory newDefautFactory() {
        return _provider.newFactory();
    }

    public static final Object evaluate(XelContext ctx, String expression, Class<?> expectedType) throws XelException {
        return Expressions.newExpressionFactory().evaluate(ctx, expression, expectedType);
    }

    public static final void setExpressionFactoryClass(Class<? extends ExpressionFactory> expfcls) {
        if (expfcls != null && !ExpressionFactory.class.isAssignableFrom(expfcls)) {
            throw new IllegalArgumentException(expfcls + " must implement " + ExpressionFactory.class);
        }
        _expfcls = expfcls;
    }

    public static final Class<? extends ExpressionFactory> getExpressionFactoryClass() {
        return _expfcls;
    }

    static {
        boolean useZel = true;
        try {
            Classes.forNameByThread("org.zkoss.zel.impl.ExpressionFactoryImpl");
        }
        catch (Throwable e) {
            useZel = false;
        }
        _provider = useZel ? new FactoryProvider(){

            public ExpressionFactory newFactory() {
                return new ELFactory();
            }
        } : new FactoryProvider(){

            public ExpressionFactory newFactory() {
                return new org.zkoss.xel.el.ELFactory();
            }
        };
    }

    private static class DummyExpr
    implements Expression,
    Serializable {
        private DummyExpr() {
        }

        public Object evaluate(XelContext ctx) throws XelException {
            return null;
        }
    }

    private static class EmptyResolver
    implements VariableResolver,
    Serializable {
        private EmptyResolver() {
        }

        public Object resolveVariable(String name) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyMapper
    implements FunctionMapper,
    Serializable {
        private EmptyMapper() {
        }

        @Override
        public Function resolveFunction(String prefix, String name) {
            return null;
        }

        public Collection<String> getClassNames() {
            return Collections.emptyList();
        }

        public Class<?> resolveClass(String name) {
            return null;
        }
    }

    private static interface FactoryProvider {
        public ExpressionFactory newFactory();
    }
}

