/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.media;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import org.zkoss.io.RepeatableInputStream;
import org.zkoss.io.RepeatableReader;
import org.zkoss.util.media.Media;

public class RepeatableMedia
implements Media,
Serializable {
    private final Media _media;
    private InputStream _isdata;
    private Reader _rddata;

    private RepeatableMedia(Media media, InputStream data) {
        this._media = media;
        this._isdata = data;
    }

    private RepeatableMedia(Media media, Reader data) {
        this._media = media;
        this._rddata = data;
    }

    public static Media getInstance(Media media) {
        if (media != null && !media.inMemory() && !(media instanceof RepeatableMedia)) {
            if (media.isBinary()) {
                InputStream after;
                InputStream data = media.getStreamData();
                if (data != (after = RepeatableInputStream.getInstance(data))) {
                    return new RepeatableMedia(media, after);
                }
            } else {
                Reader after;
                Reader data = media.getReaderData();
                if (data != (after = RepeatableReader.getInstance(data))) {
                    return new RepeatableMedia(media, after);
                }
            }
        }
        return media;
    }

    public Reader getReaderData() {
        return this._rddata;
    }

    public InputStream getStreamData() {
        return this._isdata;
    }

    public byte[] getByteData() {
        return this._media.getByteData();
    }

    public String getContentType() {
        return this._media.getContentType();
    }

    public String getFormat() {
        return this._media.getFormat();
    }

    public String getName() {
        return this._media.getName();
    }

    public String getStringData() {
        return this._media.getStringData();
    }

    public boolean inMemory() {
        return this._media.inMemory();
    }

    public boolean isBinary() {
        return this._media.isBinary();
    }

    public boolean isContentDisposition() {
        return this._media.isContentDisposition();
    }
}

