/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerApplication;
import ro.pippo.controller.ControllerRouteHandler;
import ro.pippo.controller.DELETE;
import ro.pippo.controller.GET;
import ro.pippo.controller.HEAD;
import ro.pippo.controller.HttpMethod;
import ro.pippo.controller.OPTIONS;
import ro.pippo.controller.Order;
import ro.pippo.controller.PATCH;
import ro.pippo.controller.POST;
import ro.pippo.controller.PUT;
import ro.pippo.controller.Path;
import ro.pippo.controller.util.ClassUtils;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.util.LangUtils;
import ro.pippo.core.util.StringUtils;

public class ControllerRegistry {
    private static final Logger log = LoggerFactory.getLogger(ControllerRegistry.class);
    private final Set<Class<? extends Annotation>> httpMethodAnnotationClasses = new HashSet<Class>(Arrays.asList(DELETE.class, GET.class, HEAD.class, OPTIONS.class, PATCH.class, POST.class, PUT.class));
    private final ControllerApplication application;
    private final List<Route> routes;

    public ControllerRegistry(ControllerApplication application) {
        this.application = application;
        this.routes = new ArrayList<Route>();
    }

    public void register(Package ... packages) {
        List<String> packageNames = Arrays.stream(packages).map(Package::getName).collect(Collectors.toList());
        this.register(packageNames.toArray(new String[packageNames.size()]));
    }

    public void register(String ... packageNames) {
        Collection<Class<? extends Controller>> classes = this.getControllerClasses(packageNames);
        if (classes.isEmpty()) {
            log.warn("No annotated controllers found in package(s) '{}'", (Object)Arrays.toString(packageNames));
            return;
        }
        log.debug("Found {} controller classes in {} package(s)", (Object)classes.size(), (Object)packageNames.length);
        for (Class<? extends Controller> controllerClass : classes) {
            this.register(controllerClass);
        }
    }

    public void register(Class<? extends Controller> ... controllerClasses) {
        for (Class<? extends Controller> controllerClass : controllerClasses) {
            this.register(controllerClass);
        }
    }

    public void register(Controller ... controllers) {
        for (Controller controller : controllers) {
            this.register(controller);
        }
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    private void register(Class<? extends Controller> controllerClass) {
        Map<Method, Class<? extends Annotation>> controllerMethods = this.getControllerMethods(controllerClass);
        if (controllerMethods.isEmpty()) {
            log.warn("No annotated controller methods found in class '{}'", controllerClass);
            return;
        }
        log.debug("Found {} annotated controller method(s)", (Object)controllerMethods.size());
        this.registerControllerMethods(controllerMethods, null);
        log.debug("Added {} annotated routes from '{}'", (Object)this.routes.size(), controllerClass);
    }

    public void register(Controller controller) {
        Class<?> controllerClass = controller.getClass();
        Map<Method, Class<? extends Annotation>> controllerMethods = this.getControllerMethods(controllerClass);
        if (controllerMethods.isEmpty()) {
            log.warn("No annotated controller methods found in class '{}'", controllerClass);
            return;
        }
        this.registerControllerMethods(controllerMethods, controller);
        log.debug("Found {} annotated controller method(s)", (Object)controllerMethods.size());
    }

    private void registerControllerMethods(Map<Method, Class<? extends Annotation>> controllerMethods, Controller controller) {
        List<Route> controllerRoutes = this.createControllerRoutes(controllerMethods);
        for (Route controllerRoute : controllerRoutes) {
            if (controller == null) continue;
            ((ControllerRouteHandler)controllerRoute.getRouteHandler()).setController(controller);
            controllerRoute.bind("__controller", (Object)controller);
        }
        this.routes.addAll(controllerRoutes);
    }

    private List<Route> createControllerRoutes(Map<Method, Class<? extends Annotation>> controllerMethods) {
        ArrayList<Route> routes = new ArrayList<Route>();
        Class<?> controllerClass = controllerMethods.keySet().iterator().next().getDeclaringClass();
        Set<String> controllerPaths = this.getControllerPaths(controllerClass);
        Collection<Method> methods = this.sortControllerMethods(controllerMethods.keySet());
        for (Method method : methods) {
            Class<? extends Annotation> httpMethodAnnotationClass = controllerMethods.get(method);
            Annotation httpMethodAnnotation = method.getAnnotation(httpMethodAnnotationClass);
            String httpMethod = httpMethodAnnotation.annotationType().getAnnotation(HttpMethod.class).value();
            String[] methodPaths = (String[])ClassUtils.executeDeclaredMethod(httpMethodAnnotation, "value", new Object[0]);
            if (controllerPaths.isEmpty()) {
                controllerPaths.add("");
            }
            for (String controllerPath : controllerPaths) {
                if (methodPaths.length == 0) {
                    String fullPath = StringUtils.addStart((String)controllerPath, (String)"/");
                    ControllerRouteHandler handler = new ControllerRouteHandler(this.application, method);
                    Route route = new Route(httpMethod, fullPath, (RouteHandler)handler).bind("__controllerClass", controllerClass).bind("__controllerMethod", (Object)method);
                    routes.add(route);
                    continue;
                }
                for (String methodPath : methodPaths) {
                    String path = Stream.of(StringUtils.removeEnd((String)controllerPath, (String)"/"), StringUtils.removeStart((String)methodPath, (String)"/")).filter(Objects::nonNull).collect(Collectors.joining("/"));
                    String fullPath = StringUtils.addStart((String)path, (String)"/");
                    ControllerRouteHandler handler = new ControllerRouteHandler(this.application, method);
                    Route route = new Route(httpMethod, fullPath, (RouteHandler)handler).bind("__controllerClass", controllerClass).bind("__controllerMethod", (Object)method);
                    routes.add(route);
                }
            }
        }
        return routes;
    }

    private Collection<Class<? extends Controller>> getControllerClasses(String ... packageNames) {
        log.debug("Discovering annotated controller in package(s) '{}'", (Object)Arrays.toString(packageNames));
        return ClassUtils.getSubTypesOf(Controller.class, packageNames);
    }

    private Map<Method, Class<? extends Annotation>> getControllerMethods(Class<? extends Controller> controllerClass) {
        LinkedHashMap<Method, Class<? extends Annotation>> controllerMethods = new LinkedHashMap<Method, Class<? extends Annotation>>();
        block0: for (Method method : ClassUtils.getDeclaredMethods(controllerClass)) {
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (!this.httpMethodAnnotationClasses.contains(annotationClass)) continue;
                controllerMethods.put(method, annotationClass);
                continue block0;
            }
        }
        return controllerMethods;
    }

    private Set<String> getControllerPaths(Class<?> controllerClass) {
        Set<Object> parentPaths = Collections.emptySet();
        if (controllerClass.getSuperclass() != null) {
            parentPaths = this.getControllerPaths(controllerClass.getSuperclass());
        }
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        Path controllerPath = controllerClass.getAnnotation(Path.class);
        if (controllerPath != null && controllerPath.value().length > 0) {
            if (parentPaths.isEmpty()) {
                paths.addAll(Arrays.asList(controllerPath.value()));
            } else {
                for (String string : parentPaths) {
                    for (String path : controllerPath.value()) {
                        paths.add(StringUtils.removeEnd((String)string, (String)"/") + "/" + StringUtils.removeStart((String)path, (String)"/"));
                    }
                }
            }
        } else {
            paths.addAll(parentPaths);
        }
        return paths;
    }

    private Collection<Method> sortControllerMethods(Set<Method> controllerMethods) {
        ArrayList<Method> list = new ArrayList<Method>(controllerMethods);
        list.sort((m1, m2) -> {
            int o1 = Integer.MAX_VALUE;
            Order order1 = ClassUtils.getAnnotation(m1, Order.class);
            if (order1 != null) {
                o1 = order1.value();
            }
            int o2 = Integer.MAX_VALUE;
            Order order2 = ClassUtils.getAnnotation(m2, Order.class);
            if (order2 != null) {
                o2 = order2.value();
            }
            if (o1 == o2) {
                String s1 = LangUtils.toString((Method)m1);
                String s2 = LangUtils.toString((Method)m2);
                return s1.compareTo(s2);
            }
            return o1 < o2 ? -1 : 1;
        });
        return list;
    }
}

