/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerFactory;
import ro.pippo.controller.DefaultControllerFactory;

public class SingletonControllerFactory
implements ControllerFactory {
    private static final Logger log = LoggerFactory.getLogger(SingletonControllerFactory.class);
    private final ControllerFactory decoratedFactory;
    private final List<String> controllerClassNames;
    private final Map<String, Controller> cache;

    public SingletonControllerFactory() {
        this(new DefaultControllerFactory(), new String[0]);
    }

    public SingletonControllerFactory(String ... controllerClassNames) {
        this(new DefaultControllerFactory(), controllerClassNames);
    }

    public SingletonControllerFactory(ControllerFactory decoratedFactory, String ... controllerClassNames) {
        this.decoratedFactory = decoratedFactory;
        this.controllerClassNames = Arrays.asList(controllerClassNames);
        this.cache = new ConcurrentHashMap<String, Controller>();
    }

    @Override
    public <T extends Controller> T createController(Class<T> controllerClass) {
        String controllerClassName = controllerClass.getName();
        Controller controller = this.cache.get(controllerClassName);
        if (controller == null) {
            log.debug("Create instance of '{}'", (Object)controllerClassName);
            controller = this.decoratedFactory.createController(controllerClass);
            if (this.controllerClassNames.isEmpty() || this.controllerClassNames.contains(controllerClassName)) {
                this.cache.put(controllerClassName, controller);
            }
        }
        return (T)controller;
    }
}

