/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller.extractor;

import java.lang.reflect.Method;
import java.util.Collection;
import ro.pippo.controller.MethodParameter;
import ro.pippo.controller.extractor.Header;
import ro.pippo.controller.extractor.MethodParameterExtractor;
import ro.pippo.core.ParameterValue;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.util.LangUtils;
import ro.pippo.core.util.StringUtils;

public class HeaderExtractor
implements MethodParameterExtractor {
    @Override
    public boolean isApplicable(MethodParameter parameter) {
        return parameter.isAnnotationPresent(Header.class);
    }

    @Override
    public Object extract(MethodParameter parameter, RouteContext routeContext) {
        Header annotation = parameter.getAnnotation(Header.class);
        String name = this.getParameterName(parameter, annotation);
        String pattern = annotation.pattern();
        ParameterValue parameterValue = new ParameterValue(routeContext.getRequest().getLocale(), new String[]{routeContext.getHeader(name)});
        Class<?> parameterType = parameter.getParameterType();
        if (Collection.class.isAssignableFrom(parameterType)) {
            Class<?> collectionType = parameterType;
            Class<?> objectType = parameter.getParameterGenericType();
            return parameterValue.toCollection(collectionType, objectType, pattern);
        }
        return parameterValue.to(parameterType, pattern);
    }

    private String getParameterName(MethodParameter parameter, Header annotation) {
        String name = annotation.value();
        if (StringUtils.isNullOrEmpty((String)name)) {
            name = parameter.getParameterName();
        }
        if (name == null) {
            throw new PippoRuntimeException("Method '{}' parameter {} does not specify a name!", new Object[]{LangUtils.toString((Method)parameter.getMethod()), parameter.getParameterIndex()});
        }
        return name;
    }
}

