/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;

public class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static <T> Class<T> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new PippoRuntimeException("Failed to get class '{}'", new Object[]{className});
        }
    }

    public static Collection<Class<?>> getClasses(String ... packageNames) {
        ArrayList classes = new ArrayList();
        for (String packageName : packageNames) {
            String packagePath = packageName.replace('.', '/');
            String packagePrefix = packageName + '.';
            List<URL> packageUrls = ClassUtils.getResources(packagePath);
            for (URL packageUrl : packageUrls) {
                Throwable throwable;
                if (packageUrl.getProtocol().equals("jar")) {
                    log.debug("Scanning jar {} for classes", (Object)packageUrl);
                    try {
                        String jar = packageUrl.toString().substring("jar:".length()).split("!")[0];
                        File file = new File(new URI(jar));
                        JarInputStream is = new JarInputStream(new FileInputStream(file));
                        throwable = null;
                        try {
                            JarEntry entry;
                            while ((entry = is.getNextJarEntry()) != null) {
                                String className;
                                if (entry.isDirectory() || !entry.getName().endsWith(".class") || !(className = entry.getName().replace(".class", "").replace('/', '.')).startsWith(packagePrefix)) continue;
                                Class aClass = ClassUtils.getClass(className);
                                classes.add(aClass);
                            }
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            is.close();
                            continue;
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        throw new PippoRuntimeException("Failed to get classes for package '{}'", new Object[]{e, packageName});
                    }
                }
                log.debug("Scanning filesystem {} for classes", (Object)packageUrl);
                log.debug(packageUrl.getProtocol());
                try {
                    InputStream is = packageUrl.openStream();
                    Throwable throwable4 = null;
                    try {
                        Objects.requireNonNull(is, String.format("Package url %s stream is null!", packageUrl));
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                        throwable = null;
                        try {
                            classes.addAll(reader.lines().filter(line -> line != null && line.endsWith(".class")).map(line -> {
                                String className = line.replace(".class", "").replace('/', '.');
                                try {
                                    return ClassUtils.getClass(packagePrefix + className);
                                }
                                catch (Exception e) {
                                    log.error("Failed to find {}", line, (Object)e);
                                    return null;
                                }
                            }).collect(Collectors.toList()));
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable4 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable4 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable8) {
                                throwable4.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new PippoRuntimeException("Failed to get classes for package '{}'", new Object[]{e, packageName});
                }
            }
        }
        return Collections.unmodifiableCollection(classes);
    }

    public static <T> Collection<Class<? extends T>> getSubTypesOf(Class<T> type, String ... packageNames) {
        List classes = ClassUtils.getClasses(packageNames).stream().filter(aClass -> type.isAssignableFrom((Class<?>)aClass)).map(aClass -> aClass).collect(Collectors.toList());
        return Collections.unmodifiableCollection(classes);
    }

    public static Collection<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotationClass, String ... packageNames) {
        List classes = ClassUtils.getClasses(packageNames).stream().filter(aClass -> aClass.isAnnotationPresent(annotationClass)).collect(Collectors.toList());
        return Collections.unmodifiableCollection(classes);
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ClassUtils.getAnnotation(method.getDeclaringClass(), annotationClass);
        }
        return annotation;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> objectClass, Class<T> annotationClass) {
        if (objectClass == null || Object.class == objectClass) {
            return null;
        }
        T annotation = objectClass.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return ClassUtils.getAnnotation(objectClass.getSuperclass(), annotationClass);
    }

    public static List<Method> getDeclaredMethods(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> !method.isBridge()).collect(Collectors.toList());
    }

    public static <T extends Annotation> List<T> collectNestedAnnotation(Method method, Class<T> annotationClass) {
        ArrayList<T> list = new ArrayList<T>();
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(annotationClass)) continue;
            T nestedAnnotation = annotation.annotationType().getAnnotation(annotationClass);
            list.add(nestedAnnotation);
        }
        list.addAll(ClassUtils.collectNestedAnnotation(method.getDeclaringClass(), annotationClass));
        return list;
    }

    public static <T extends Annotation> List<T> collectNestedAnnotation(Class<?> objectClass, Class<T> annotationClass) {
        if (objectClass == null || objectClass == Object.class) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Annotation annotation : objectClass.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(annotationClass)) continue;
            T nestedAnnotation = annotation.annotationType().getAnnotation(annotationClass);
            list.add(nestedAnnotation);
        }
        list.addAll(ClassUtils.collectNestedAnnotation(objectClass.getSuperclass(), annotationClass));
        return list;
    }

    public static <T> T executeDeclaredMethod(Object o, String methodName, Object ... args) {
        try {
            Method method;
            if (args != null && args.length > 0) {
                Class[] types = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    types[i] = args[i].getClass();
                }
                method = o.getClass().getDeclaredMethod(methodName, types);
                Objects.requireNonNull(method, String.format("Failed to find declared controllerMethod '%s' for args '{}' in type '%s'!", methodName, types, o.getClass().getName()));
            } else {
                method = o.getClass().getDeclaredMethod(methodName, new Class[0]);
                Objects.requireNonNull(method, String.format("Failed to find declared controllerMethod '%s' in type '%s'!", methodName, o.getClass().getName()));
            }
            return (T)method.invoke(o, args);
        }
        catch (Exception e) {
            throw new PippoRuntimeException("Failed to execute controllerMethod '{}' on object '{}'!", new Object[]{e, methodName});
        }
    }

    public static List<URL> getResources(String name) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = ClassUtils.class.getClassLoader().getResources(name);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                list.add(url);
            }
        }
        catch (IOException e) {
            throw new PippoRuntimeException((Throwable)e);
        }
        return list;
    }

    public static boolean isAssignable(Object value, Class<?> type) {
        if (type.isInstance(value)) {
            return true;
        }
        if (Boolean.TYPE == type && value instanceof Boolean) {
            return true;
        }
        return type.isPrimitive() && value instanceof Number;
    }
}

