/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.n2oapp.platform.i18n.Message;

public class Result {
    private int successCount;
    private int allCount;
    private List<Message> errors;

    public Result(int successCount, int allCount, List<Message> errors) {
        this.successCount = successCount;
        this.allCount = allCount;
        this.errors = errors;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getAllCount() {
        return this.allCount;
    }

    public List<Message> getErrors() {
        return this.errors;
    }

    public Result addResult(Result result) {
        LinkedHashSet<Message> totalErrors = new LinkedHashSet<Message>();
        if (this.errors == null && result.getErrors() != null) {
            totalErrors.addAll(result.getErrors());
        } else if (this.errors != null && result.getErrors() == null) {
            totalErrors.addAll(this.errors);
        } else if (this.errors != null && result.getErrors() != null) {
            totalErrors.addAll(this.errors);
            totalErrors.addAll(result.getErrors());
        }
        return new Result(this.successCount + result.getSuccessCount(), this.getAllCount() + result.getAllCount(), new ArrayList<Message>(totalErrors));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (this.successCount != result.successCount) {
            return false;
        }
        if (this.allCount != result.allCount) {
            return false;
        }
        return Objects.equals(this.errors, result.errors);
    }

    public int hashCode() {
        int result = this.successCount;
        result = 31 * result + this.allCount;
        result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Result{");
        sb.append("successCount=").append(this.successCount);
        sb.append(", allCount=").append(this.allCount);
        sb.append(", errors=").append(this.errors);
        sb.append('}');
        return sb.toString();
    }
}

