/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.platform.i18n.Message;
import net.n2oapp.platform.i18n.UserException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.util.json.JsonUtil;
import ru.i_novus.platform.datastorage.temporal.enums.FieldType;

@ApiModel(value="\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430")
@JsonPropertyOrder(value={"references", "attributes"})
public class Structure
implements Serializable {
    public static final Structure EMPTY = new Structure();
    private static final String PRIMARY_ATTRIBUTE_NOT_FOUND_EXCEPTION_CODE = "primary.attribute.not.found";
    private static final String PRIMARY_ATTRIBUTE_IS_MULTIPLE_EXCEPTION_CODE = "primary.attribute.is.multiple";
    @ApiParam(value="\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b")
    private List<Attribute> attributes;
    @ApiParam(value="\u0421\u0441\u044b\u043b\u043a\u0438")
    private List<Reference> references;

    public Structure() {
        this(new ArrayList<Attribute>(0), new ArrayList<Reference>(0));
    }

    public Structure(List<Attribute> attributes, List<Reference> references) {
        this.attributes = Structure.getOrCreateList(attributes);
        this.references = Structure.getOrCreateList(references);
    }

    public Structure(Structure structure) {
        this.attributes = Structure.copyList(structure.attributes, Attribute::new);
        this.references = Structure.copyList(structure.references, Reference::new);
    }

    @JsonGetter
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = Structure.getOrCreateList(attributes);
    }

    @JsonGetter
    public List<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(List<Reference> references) {
        this.references = Structure.getOrCreateList(references);
    }

    public Attribute getAttribute(String code) {
        if (CollectionUtils.isEmpty(this.attributes)) {
            return null;
        }
        return this.attributes.stream().filter(attribute -> attribute.getCode().equals(code)).findAny().orElse(null);
    }

    public Reference getReference(String attributeCode) {
        if (CollectionUtils.isEmpty(this.references)) {
            return null;
        }
        return this.references.stream().filter(reference -> reference.getAttribute().equals(attributeCode)).findAny().orElse(null);
    }

    public boolean hasPrimary() {
        return this.attributes.stream().anyMatch(Attribute::hasIsPrimary);
    }

    @JsonIgnore
    public List<Attribute> getPrimaries() {
        return this.attributes.stream().filter(Attribute::hasIsPrimary).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Attribute> getLocalizables() {
        return this.attributes.stream().filter(Attribute::isLocalizable).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<String> getAttributeCodes() {
        return Structure.getAttributeCodes(this.getAttributes()).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<String> getReferenceAttributeCodes() {
        return Structure.getReferenceAttributeCodes(this.getReferences()).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<String> getPrimaryCodes() {
        return Structure.getAttributeCodes(this.getPrimaries()).collect(Collectors.toList());
    }

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.attributes);
    }

    public void clearPrimary() {
        if (CollectionUtils.isEmpty(this.attributes)) {
            return;
        }
        this.attributes.forEach(a -> {
            if (a.hasIsPrimary()) {
                a.setIsPrimary(Boolean.FALSE);
            }
        });
    }

    public void add(Attribute attribute, Reference reference) {
        if (attribute == null || StringUtils.isEmpty((Object)attribute.getCode())) {
            return;
        }
        this.getAttributes().add(attribute);
        if (reference == null) {
            return;
        }
        if (!attribute.getCode().equals(reference.getAttribute())) {
            return;
        }
        this.getReferences().add(reference);
    }

    public void update(Attribute oldAttribute, Attribute newAttribute) {
        if (oldAttribute == null || newAttribute == null || StringUtils.isEmpty((Object)newAttribute.getCode())) {
            return;
        }
        int index = this.getAttributes().indexOf(oldAttribute);
        this.getAttributes().set(index, newAttribute);
    }

    public void update(Reference oldReference, Reference newReference) {
        if (newReference != null && !StringUtils.isEmpty((Object)newReference.getAttribute())) {
            if (oldReference != null) {
                int index = this.getReferences().indexOf(oldReference);
                this.getReferences().set(index, newReference);
            } else {
                this.getReferences().add(newReference);
            }
        } else if (oldReference != null) {
            this.getReferences().remove(oldReference);
        }
    }

    public void remove(String attributeCode) {
        Attribute attribute = this.getAttribute(attributeCode);
        if (attribute == null) {
            return;
        }
        this.getAttributes().remove(attribute);
        if (!attribute.isReferenceType()) {
            return;
        }
        Reference reference = this.getReference(attributeCode);
        if (reference == null) {
            return;
        }
        this.getReferences().remove(reference);
    }

    public List<Reference> getRefCodeReferences(String referenceCode) {
        if (StringUtils.isEmpty((Object)referenceCode) || CollectionUtils.isEmpty(this.references)) {
            return Collections.emptyList();
        }
        return this.references.stream().filter(reference -> reference.getReferenceCode().equals(referenceCode)).collect(Collectors.toList());
    }

    public List<Attribute> getRefCodeAttributes(String referenceCode) {
        if (StringUtils.isEmpty((Object)referenceCode) || CollectionUtils.isEmpty(this.attributes)) {
            return Collections.emptyList();
        }
        return this.getRefCodeReferences(referenceCode).stream().map(ref -> this.getAttribute(ref.getAttribute())).collect(Collectors.toList());
    }

    private static <T> List<T> getOrCreateList(List<T> list) {
        return list == null ? new ArrayList(0) : list;
    }

    private static <T> List<T> copyList(List<T> values, UnaryOperator<T> copy) {
        if (CollectionUtils.isEmpty(values)) {
            return new ArrayList(0);
        }
        return values.stream().map(copy).collect(Collectors.toList());
    }

    public static Stream<String> getAttributeCodes(List<Attribute> attributes) {
        return attributes.stream().map(Attribute::getCode);
    }

    public static Stream<String> getReferenceAttributeCodes(List<Reference> references) {
        return references.stream().map(Reference::getAttribute);
    }

    public boolean storageEquals(Structure that) {
        if (that == null) {
            return false;
        }
        List<Attribute> others = that.getAttributes();
        return CollectionUtils.isEmpty(this.attributes) ? CollectionUtils.isEmpty(others) : this.attributes.size() == others.size() && this.attributes.stream().noneMatch(attribute -> others.stream().noneMatch(attribute::storageEquals));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Structure that = (Structure)o;
        return Objects.equals(this.attributes, that.attributes) && Objects.equals(this.references, that.references);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.references);
    }

    public String toString() {
        return JsonUtil.toJsonString(this);
    }

    @ApiModel(value="\u0410\u0442\u0440\u0438\u0431\u0443\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430")
    public static class Attribute
    implements Serializable {
        @ApiModelProperty(value="\u041a\u043e\u0434 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
        private String code;
        @ApiModelProperty(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
        private String name;
        @ApiModelProperty(value="\u0422\u0438\u043f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
        private FieldType type;
        @ApiModelProperty(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0433\u043e \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
        private Boolean isPrimary = Boolean.FALSE;
        @ApiModelProperty(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0438\u043c\u043e\u0433\u043e \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
        private Boolean localizable = Boolean.FALSE;
        @ApiModelProperty(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
        private String description;

        public Attribute() {
        }

        public Attribute(Attribute attribute) {
            this.code = attribute.code;
            this.name = attribute.name;
            this.type = attribute.type;
            this.isPrimary = attribute.isPrimary;
            this.localizable = attribute.localizable;
            this.description = attribute.description;
        }

        public static Attribute build(Attribute attribute) {
            return attribute != null ? new Attribute(attribute) : new Attribute();
        }

        public static Attribute build(String code, String name, FieldType type, String description) {
            return Attribute.create(code, name, type, description);
        }

        public static Attribute buildPrimary(String code, String name, FieldType type, String description) {
            Attribute attribute = Attribute.create(code, name, type, description);
            attribute.setIsPrimary(Boolean.TRUE);
            return attribute;
        }

        public static Attribute buildLocalizable(String code, String name, FieldType type, String description) {
            Attribute attribute = Attribute.create(code, name, type, description);
            attribute.setLocalizable(Boolean.TRUE);
            return attribute;
        }

        private static Attribute create(String code, String name, FieldType type, String description) {
            Attribute attribute = new Attribute();
            attribute.setCode(code);
            attribute.setName(name);
            attribute.setType(type);
            attribute.setDescription(description);
            return attribute;
        }

        @JsonGetter
        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        @JsonGetter
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonGetter
        public FieldType getType() {
            return this.type;
        }

        public void setType(FieldType type) {
            this.type = type;
        }

        @JsonGetter
        public Boolean getIsPrimary() {
            return this.isPrimary;
        }

        public void setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary != null && isPrimary != false;
        }

        @JsonGetter
        public Boolean getLocalizable() {
            return this.localizable;
        }

        public void setLocalizable(Boolean localizable) {
            this.localizable = localizable != null && localizable != false;
        }

        @JsonGetter
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean hasIsPrimary() {
            return this.getIsPrimary();
        }

        @JsonIgnore
        public boolean isLocalizable() {
            return this.getLocalizable();
        }

        @JsonIgnore
        public boolean isReferenceType() {
            return FieldType.REFERENCE.equals((Object)this.getType());
        }

        public boolean storageEquals(Attribute that) {
            return that != null && Objects.equals(this.code, that.code) && Objects.equals(this.type, that.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute that = (Attribute)o;
            return Objects.equals(this.code, that.code) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.isPrimary, that.isPrimary) && Objects.equals(this.localizable, that.localizable) && Objects.equals(this.description, that.description);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.name, this.type, this.isPrimary, this.localizable, this.description);
        }

        public String toString() {
            return JsonUtil.toJsonString(this);
        }
    }

    @ApiModel(value="\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430")
    public static class Reference
    implements Serializable {
        @ApiModelProperty(value="\u041a\u043e\u0434 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f")
        private String attribute;
        @ApiModelProperty(value="\u041a\u043e\u0434 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u0441\u044b\u043b\u0430\u044e\u0442\u0441\u044f")
        private String referenceCode;
        @ApiModelProperty(value="\u0412\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0441\u044b\u043b\u043e\u0447\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f")
        private String displayExpression;

        public Reference() {
        }

        public Reference(Reference reference) {
            this(reference.attribute, reference.referenceCode, reference.displayExpression);
        }

        public Reference(String attribute, String referenceCode, String displayExpression) {
            this.attribute = attribute;
            this.referenceCode = referenceCode;
            this.displayExpression = displayExpression;
        }

        public static Reference build(Reference reference) {
            return reference != null ? new Reference(reference) : new Reference();
        }

        @JsonGetter
        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @JsonGetter
        public String getReferenceCode() {
            return this.referenceCode;
        }

        public void setReferenceCode(String referenceCode) {
            this.referenceCode = referenceCode;
        }

        @JsonGetter
        public String getDisplayExpression() {
            return this.displayExpression;
        }

        public void setDisplayExpression(String displayExpression) {
            this.displayExpression = displayExpression;
        }

        public Attribute findReferenceAttribute(Structure referenceStructure) {
            List<Attribute> primaries = referenceStructure.getPrimaries();
            if (CollectionUtils.isEmpty(primaries)) {
                throw new UserException(new Message(Structure.PRIMARY_ATTRIBUTE_NOT_FOUND_EXCEPTION_CODE));
            }
            if (primaries.size() > 1) {
                throw new UserException(new Message(Structure.PRIMARY_ATTRIBUTE_IS_MULTIPLE_EXCEPTION_CODE));
            }
            return primaries.get(0);
        }

        @JsonIgnore
        public boolean isNull() {
            return StringUtils.isEmpty((Object)this.attribute) || StringUtils.isEmpty((Object)this.referenceCode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reference that = (Reference)o;
            return Objects.equals(this.attribute, that.attribute) && Objects.equals(this.referenceCode, that.referenceCode) && Objects.equals(this.displayExpression, that.displayExpression);
        }

        public int hashCode() {
            return Objects.hash(this.attribute, this.referenceCode, this.displayExpression);
        }

        public String toString() {
            return JsonUtil.toJsonString(this);
        }
    }
}

