/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.compare;

import java.util.Objects;
import ru.i_novus.ms.rdm.api.model.compare.ComparableField;
import ru.i_novus.ms.rdm.api.model.compare.RdmComparable;
import ru.i_novus.platform.datastorage.temporal.enums.DiffStatusEnum;
import ru.i_novus.platform.datastorage.temporal.model.value.DiffFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;

public class ComparableFieldValue
extends RdmComparable {
    private ComparableField comparableField;
    private Object oldValue;
    private Object newValue;

    public ComparableFieldValue() {
    }

    public ComparableFieldValue(ComparableField comparableField, Object oldValue, Object newValue, DiffStatusEnum status) {
        this.comparableField = comparableField;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.setStatus(status);
    }

    public ComparableFieldValue(ComparableField comparableField, DiffFieldValue diffFieldValue, RowValue oldRowValue, RowValue newRowValue, DiffStatusEnum rowStatus) {
        String fieldCode = comparableField.getCode();
        this.comparableField = comparableField;
        if (comparableField.getStatus() == null) {
            if (diffFieldValue != null) {
                this.newValue = diffFieldValue.getNewValue();
                this.oldValue = diffFieldValue.getStatus() != null || oldRowValue == null ? diffFieldValue.getOldValue() : diffFieldValue.getNewValue();
            } else {
                this.oldValue = this.getValueFromRowValue(fieldCode, oldRowValue);
                this.newValue = this.getValueFromRowValue(fieldCode, newRowValue);
            }
        } else {
            switch (comparableField.getStatus()) {
                case DELETED: {
                    this.oldValue = this.getValueFromRowValue(fieldCode, oldRowValue);
                    this.newValue = null;
                    break;
                }
                case UPDATED: {
                    this.oldValue = this.getValueFromRowValue(fieldCode, oldRowValue);
                    this.newValue = this.getValueFromRowValue(fieldCode, newRowValue);
                    break;
                }
                case INSERTED: {
                    this.oldValue = null;
                    this.newValue = this.getValueFromRowValue(fieldCode, newRowValue);
                    break;
                }
            }
        }
        this.setStatus(this.calculateFieldValueStatus(rowStatus, comparableField.getStatus(), diffFieldValue, this.oldValue, this.newValue));
    }

    private DiffStatusEnum calculateFieldValueStatus(DiffStatusEnum rowStatus, DiffStatusEnum fieldStatus, DiffFieldValue diffFieldValue, Object oldValue, Object newValue) {
        if (DiffStatusEnum.DELETED.equals((Object)rowStatus) || DiffStatusEnum.DELETED.equals((Object)fieldStatus)) {
            return DiffStatusEnum.DELETED;
        }
        if (DiffStatusEnum.INSERTED.equals((Object)rowStatus) || DiffStatusEnum.INSERTED.equals((Object)fieldStatus)) {
            return DiffStatusEnum.INSERTED;
        }
        if (diffFieldValue != null && DiffStatusEnum.UPDATED.equals((Object)diffFieldValue.getStatus()) || DiffStatusEnum.UPDATED.equals((Object)fieldStatus) && !Objects.equals(String.valueOf(oldValue), String.valueOf(newValue))) {
            return DiffStatusEnum.UPDATED;
        }
        return null;
    }

    private Object getValueFromRowValue(String fieldCode, RowValue rowValue) {
        return rowValue != null ? rowValue.getFieldValue(fieldCode).getValue() : null;
    }

    public ComparableField getComparableField() {
        return this.comparableField;
    }

    public void setComparableField(ComparableField comparableField) {
        this.comparableField = comparableField;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableFieldValue that = (ComparableFieldValue)o;
        if (this.comparableField != null ? !this.comparableField.equals(that.comparableField) : that.comparableField != null) {
            return false;
        }
        if (this.oldValue != null ? that.oldValue == null || !this.oldValue.toString().equals(that.oldValue.toString()) : that.oldValue != null) {
            return false;
        }
        if (this.getStatus() != that.getStatus()) {
            return false;
        }
        return this.newValue != null ? that.newValue != null && this.newValue.toString().equals(that.newValue.toString()) : that.newValue == null;
    }

    public int hashCode() {
        return Objects.hash(this.comparableField, this.oldValue, this.newValue);
    }
}

