/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.validation;

import java.math.BigDecimal;
import java.util.Objects;
import net.n2oapp.platform.i18n.UserException;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidationType;

public class FloatRangeAttributeValidation
extends AttributeValidation {
    private BigDecimal min;
    private BigDecimal max;

    public FloatRangeAttributeValidation() {
        super(AttributeValidationType.FLOAT_RANGE);
    }

    public FloatRangeAttributeValidation(BigDecimal min, BigDecimal max) {
        this();
        this.min = min;
        this.max = max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    @Override
    public String valuesToString() {
        return (this.min != null ? this.min.toPlainString() : "") + ";" + (this.max != null ? this.max.toPlainString() : "");
    }

    @Override
    public FloatRangeAttributeValidation valueFromString(String value) {
        if (value == null || !value.matches("(-?((\\d*\\.)?\\d+))?;(-?((\\d*\\.)?\\d+))?")) {
            throw new UserException("attribute.validation.value.invalid");
        }
        String[] split = value.split(";");
        if (!StringUtils.isEmpty((Object)split[0])) {
            this.min = new BigDecimal(split[0]);
        }
        if (!StringUtils.isEmpty((Object)split[1])) {
            this.max = new BigDecimal(split[1]);
        }
        if (this.min != null && this.max != null && this.min.compareTo(this.max) > 0) {
            throw new UserException("invalid.range");
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FloatRangeAttributeValidation that = (FloatRangeAttributeValidation)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.min, this.max);
    }
}

