/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.validation;

import java.util.Objects;
import net.n2oapp.platform.i18n.UserException;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidationType;

public class FloatSizeAttributeValidation
extends AttributeValidation {
    private int intPartSize;
    private int fracPartSize;

    public FloatSizeAttributeValidation() {
        super(AttributeValidationType.FLOAT_SIZE);
    }

    public FloatSizeAttributeValidation(int intPartSize, int fracPartSize) {
        this();
        this.intPartSize = intPartSize;
        this.fracPartSize = fracPartSize;
    }

    public int getIntPartSize() {
        return this.intPartSize;
    }

    public void setIntPartSize(int intPartSize) {
        this.intPartSize = intPartSize;
    }

    public int getFracPartSize() {
        return this.fracPartSize;
    }

    public void setFracPartSize(int fracPartSize) {
        this.fracPartSize = fracPartSize;
    }

    @Override
    public String valuesToString() {
        return this.intPartSize + ";" + this.fracPartSize;
    }

    @Override
    public FloatSizeAttributeValidation valueFromString(String value) {
        if (value == null || !value.matches("(\\d+)?;(\\d+)?")) {
            throw new UserException("attribute.validation.value.invalid");
        }
        String[] split = value.split(";");
        if (!StringUtils.isEmpty((Object)split[0])) {
            this.intPartSize = Integer.parseInt(split[0]);
        }
        if (!StringUtils.isEmpty((Object)split[1])) {
            this.fracPartSize = Integer.parseInt(split[1]);
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FloatSizeAttributeValidation that = (FloatSizeAttributeValidation)o;
        return this.intPartSize == that.intPartSize && this.fracPartSize == that.fracPartSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.intPartSize, this.fracPartSize);
    }
}

