/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.version;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Objects;
import javax.ws.rs.QueryParam;
import ru.i_novus.platform.datastorage.temporal.enums.FieldType;
import ru.i_novus.platform.datastorage.temporal.model.criteria.SearchTypeEnum;

public class AttributeFilter {
    @QueryParam(value="attribute")
    private String attributeName;
    @QueryParam(value="value")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=LocalDate.class, name="DATE"), @JsonSubTypes.Type(value=BigInteger.class, name="INTEGER"), @JsonSubTypes.Type(value=BigDecimal.class, name="FLOAT")})
    private Serializable value;
    @QueryParam(value="type")
    private FieldType fieldType;
    @QueryParam(value="searchType")
    private SearchTypeEnum searchType;

    public AttributeFilter() {
    }

    public AttributeFilter(String attributeName, Serializable value, FieldType fieldType) {
        this.attributeName = attributeName;
        this.value = value;
        this.fieldType = fieldType;
    }

    public AttributeFilter(String attributeName, Serializable value, FieldType fieldType, SearchTypeEnum searchTypeEnum) {
        this(attributeName, value, fieldType);
        this.searchType = searchTypeEnum;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public SearchTypeEnum getSearchType() {
        if (this.searchType != null) {
            return this.searchType;
        }
        if (FieldType.STRING.equals((Object)this.fieldType)) {
            return SearchTypeEnum.LIKE;
        }
        return SearchTypeEnum.EXACT;
    }

    public void setSearchType(SearchTypeEnum searchType) {
        this.searchType = searchType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeFilter that = (AttributeFilter)o;
        return Objects.equals(this.attributeName, that.attributeName) && Objects.equals(this.value, that.value) && Objects.equals(this.fieldType, that.fieldType) && this.searchType == that.searchType;
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.value, this.fieldType, this.searchType);
    }
}

