/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.util;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import ru.i_novus.ms.rdm.api.model.AbstractCriteria;

public class PageIterator<T, C extends AbstractCriteria>
implements Iterator<Page<? extends T>> {
    private final Function<? super C, Page<? extends T>> pageSource;
    private final C criteria;
    private int currentPage;
    private Page<? extends T> nextPage;

    public PageIterator(Function<? super C, Page<? extends T>> pageSource, C criteria) {
        this(pageSource, (C)criteria, false);
    }

    public PageIterator(Function<? super C, Page<? extends T>> pageSource, C criteria, boolean defaultSortProvied) {
        if (!defaultSortProvied && criteria.getSort() == null) {
            throw new IllegalArgumentException("You must either ensure that default sort is provided by pageSource or set some sorting in your criteria.");
        }
        this.pageSource = pageSource;
        this.criteria = criteria;
        this.currentPage = criteria.getPageNumber() - 1;
    }

    @Override
    public boolean hasNext() {
        this.criteria.setPageNumber(this.currentPage + 1);
        this.nextPage = this.pageSource.apply(this.criteria);
        List content = this.nextPage.getContent();
        return !content.isEmpty();
    }

    @Override
    public Page<? extends T> next() {
        Page<? extends T> result;
        if (this.nextPage != null) {
            result = this.nextPage;
            this.nextPage = null;
        } else {
            this.criteria.setPageNumber(this.currentPage + 1);
            result = this.pageSource.apply(this.criteria);
        }
        ++this.currentPage;
        return result;
    }
}

