/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cxf.common.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import ru.i_novus.ms.rdm.api.model.Structure;
import ru.i_novus.ms.rdm.api.model.refdata.RefBookRowValue;
import ru.i_novus.ms.rdm.api.model.refdata.Row;
import ru.i_novus.ms.rdm.api.model.version.AttributeFilter;
import ru.i_novus.ms.rdm.api.util.FieldValueUtils;
import ru.i_novus.ms.rdm.api.util.TimeUtils;
import ru.i_novus.platform.datastorage.temporal.enums.FieldType;
import ru.i_novus.platform.datastorage.temporal.model.FieldValue;
import ru.i_novus.platform.datastorage.temporal.model.Reference;
import ru.i_novus.platform.datastorage.temporal.model.criteria.SearchTypeEnum;
import ru.i_novus.platform.datastorage.temporal.model.value.ReferenceFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;

public class RowUtils {
    private RowUtils() {
    }

    public static boolean isEmptyData(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmptyRow(Row row) {
        return row == null || RowUtils.isEmptyData(row.getData()) || row.getData().values().stream().allMatch(ObjectUtils::isEmpty);
    }

    public static void prepareRowValues(Row row) {
        if (RowUtils.isEmptyRow(row)) {
            return;
        }
        row.getData().entrySet().stream().filter(e -> e.getValue() instanceof Date).forEach(e -> e.setValue(TimeUtils.parseLocalDate(e.getValue())));
    }

    public static boolean equalsValues(Object newDataValue, FieldValue<?> oldFieldValue) {
        if (newDataValue == null != (oldFieldValue == null)) {
            return false;
        }
        if (newDataValue == null) {
            return true;
        }
        Serializable oldDataValue = oldFieldValue.getValue();
        if (newDataValue instanceof Reference && oldDataValue instanceof Reference && !Objects.equals(((Reference)newDataValue).getValue(), ((Reference)oldDataValue).getValue())) {
            return false;
        }
        return Objects.equals(newDataValue, oldDataValue);
    }

    public static boolean equalsValuesByAttributes(Row newRow, RefBookRowValue oldRowValue, List<Structure.Attribute> attributes) {
        return attributes.stream().allMatch(attribute -> {
            Object newDataValue = newRow.getData().get(attribute.getCode());
            FieldValue oldFieldValue = oldRowValue.getFieldValue(attribute.getCode());
            return RowUtils.equalsValues(newDataValue, oldFieldValue);
        });
    }

    public static String toNamedValues(Map<String, Object> rowData, List<Structure.Attribute> attributes) {
        return attributes.stream().map(attribute -> RowUtils.toNamedValue(rowData, attribute)).collect(Collectors.joining("\", \""));
    }

    private static String toNamedValue(Map<String, Object> rowData, Structure.Attribute attribute) {
        return attribute.getName() + "\" - \"" + rowData.get(attribute.getCode());
    }

    public static <T> List<T> toSystemIds(Collection<? extends RowValue> rowValues) {
        return rowValues.stream().map(rowValue -> rowValue.getSystemId()).collect(Collectors.toList());
    }

    public static List<Long> toLongSystemIds(Collection<Object> systemIds) {
        return systemIds.stream().map(systemId -> (Long)systemId).collect(Collectors.toList());
    }

    public static boolean hasSystemId(RowValue<?> rowValue, Object systemId) {
        return systemId.equals(rowValue.getSystemId());
    }

    public static RowValue getBySystemId(Collection<RowValue> rowValues, Object systemId) {
        return rowValues.stream().filter(rowValue -> RowUtils.hasSystemId(rowValue, systemId)).findFirst().orElse(null);
    }

    public static boolean containsSystemId(Collection<RowValue> rowValues, Object systemId) {
        return !CollectionUtils.isEmpty(rowValues) && rowValues.stream().anyMatch(rowValue -> RowUtils.hasSystemId(rowValue, systemId));
    }

    public static Serializable toSearchValue(Structure.Attribute primary, RowValue rowValue) {
        FieldValue fieldValue = rowValue.getFieldValue(primary.getCode());
        return FieldValueUtils.castFieldValue(fieldValue, primary.getType());
    }

    public static List<String> toReferenceValues(List<Structure.Attribute> primaries, Collection<RowValue> rowValues) {
        return rowValues.stream().map(rowValue -> RowUtils.toReferenceValue(primaries, rowValue)).collect(Collectors.toList());
    }

    public static String toReferenceValue(List<Structure.Attribute> primaries, RowValue rowValue) {
        FieldValue fieldValue = rowValue.getFieldValue(primaries.get(0).getCode());
        Serializable value = FieldValueUtils.castFieldValue(fieldValue, FieldType.STRING);
        return value != null ? value.toString() : null;
    }

    public static Map<String, RowValue> toReferredRowValues(List<Structure.Attribute> primaries, Collection<RowValue> rowValues) {
        return rowValues.stream().collect(Collectors.toMap(rowValue -> RowUtils.toReferenceValue(primaries, rowValue), Function.identity()));
    }

    public static Reference getFieldReference(Collection<? extends RowValue> rowValues, Long systemId, String fieldCode) {
        RowValue foundRowValue = rowValues.stream().filter(rowValue -> Objects.equals(rowValue.getSystemId(), systemId)).findFirst().orElse(null);
        return foundRowValue != null ? RowUtils.getFieldReference(foundRowValue, fieldCode) : null;
    }

    public static Reference getFieldReference(RowValue rowValue, String fieldCode) {
        FieldValue fieldValue = rowValue.getFieldValue(fieldCode);
        return fieldValue instanceof ReferenceFieldValue ? (Reference)((ReferenceFieldValue)fieldValue).getValue() : null;
    }

    public static List<String> getFieldReferenceValues(Collection<? extends RowValue> rowValues, String fieldCode) {
        return rowValues.stream().map(rowValue -> RowUtils.getFieldReferenceValue(rowValue, fieldCode)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static String getFieldReferenceValue(RowValue rowValue, String fieldCode) {
        FieldValue fieldValue = rowValue.getFieldValue(fieldCode);
        Serializable value = fieldValue != null ? fieldValue.getValue() : null;
        return value != null ? ((Reference)value).getValue() : null;
    }

    public static List<AttributeFilter> toPrimaryKeyValueFilters(Row row, List<Structure.Attribute> primaries) {
        return primaries.stream().map(primary -> RowUtils.toPrimaryKeyFilter(row, primary)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static AttributeFilter toPrimaryKeyFilter(Row row, Structure.Attribute primary) {
        Object value = (Serializable)row.getData().get(primary.getCode());
        if (value == null) {
            return null;
        }
        if (value instanceof Reference) {
            value = ((Reference)value).getValue();
        }
        return new AttributeFilter(primary.getCode(), (Serializable)value, primary.getType(), SearchTypeEnum.EXACT);
    }
}

