/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.util;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.model.Structure;
import ru.i_novus.platform.datastorage.temporal.model.DisplayExpression;

public class StructureUtils {
    private StructureUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isReference(Structure.Reference reference) {
        return reference != null && !reference.isNull();
    }

    public static boolean isDisplayExpressionEquals(Structure.Reference reference1, Structure.Reference reference2) {
        return reference1 != null && reference2 != null && Objects.equals(reference1.getDisplayExpression(), reference2.getDisplayExpression());
    }

    public static boolean containsAnyPlaceholder(String displayExpression, List<String> placeholders) {
        if (StringUtils.isEmpty((Object)displayExpression) || CollectionUtils.isEmpty(placeholders)) {
            return false;
        }
        DisplayExpression expression = new DisplayExpression(displayExpression);
        return CollectionUtils.containsAny(expression.getPlaceholders().keySet(), placeholders);
    }

    public static boolean hasAbsentPlaceholder(String displayExpression, Structure structure) {
        if (StringUtils.isEmpty((Object)displayExpression)) {
            return false;
        }
        DisplayExpression expression = new DisplayExpression(displayExpression);
        return expression.getPlaceholders().keySet().stream().anyMatch(placeholder -> structure.getAttribute((String)placeholder) == null);
    }

    public static List<String> getAbsentPlaceholders(String displayExpression, Structure structure) {
        if (StringUtils.isEmpty((Object)displayExpression)) {
            return Collections.emptyList();
        }
        DisplayExpression expression = new DisplayExpression(displayExpression);
        return expression.getPlaceholders().keySet().stream().filter(placeholder -> structure.getAttribute((String)placeholder) == null).collect(Collectors.toList());
    }

    public static String displayExpressionToPlaceholder(String displayExpression) {
        String placeholder;
        if (StringUtils.isEmpty((Object)displayExpression)) {
            return null;
        }
        DisplayExpression expression = new DisplayExpression(displayExpression);
        Set placeholders = expression.getPlaceholders().keySet();
        if (placeholders.size() == 1 && DisplayExpression.toPlaceholder((String)(placeholder = (String)placeholders.iterator().next())).equals(displayExpression)) {
            return placeholder;
        }
        return null;
    }
}

