/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.rest;

import java.util.List;
import net.n2oapp.platform.loader.server.ServerLoader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import ru.i_novus.ms.rdm.rest.loader.RefBookDataServerLoaderRunner;

@Configuration
@ComponentScan(value={"ru.i_novus.ms.rdm.rest.loader", "net.n2oapp.platform.loader.server"})
public class AppConfig {
    @Value(value="${rdm.loader.max.file-size:20000000}")
    private long maxFileSize;

    @Bean
    @ConditionalOnMissingBean
    public RefBookDataServerLoaderRunner refBookDataServerLoaderRunner(List<ServerLoader> loaders) {
        return new RefBookDataServerLoaderRunner(loaders);
    }

    @Bean
    public MultipartResolver multipartResolver() {
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        resolver.setMaxUploadSize(this.maxFileSize);
        resolver.setResolveLazily(false);
        return resolver;
    }
}

