/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.jms.ConnectionFactory;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.jaxrs.LocalDateTimeISOParameterConverter;
import net.n2oapp.platform.jaxrs.TypedParamConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.core.JmsTemplate;
import ru.i_novus.ms.audit.client.SourceApplicationAccessor;
import ru.i_novus.ms.audit.client.UserAccessor;
import ru.i_novus.ms.audit.client.model.User;
import ru.i_novus.ms.rdm.api.provider.AttributeFilterConverter;
import ru.i_novus.ms.rdm.api.provider.ExportFileProvider;
import ru.i_novus.ms.rdm.api.provider.IllegalArgumentExceptionMapper;
import ru.i_novus.ms.rdm.api.provider.MskUtcLocalDateTimeParamConverter;
import ru.i_novus.ms.rdm.api.provider.NotFoundExceptionMapper;
import ru.i_novus.ms.rdm.api.provider.OffsetDateTimeParamConverter;
import ru.i_novus.ms.rdm.api.provider.RdmMapperConfigurer;
import ru.i_novus.ms.rdm.api.provider.UserExceptionMapper;
import ru.i_novus.ms.rdm.api.util.json.LocalDateTimeMapperPreparer;
import ru.i_novus.ms.rdm.rest.provider.StaleStateExceptionMapper;
import ru.i_novus.ms.rdm.rest.service.PublishListener;
import ru.i_novus.ms.rdm.rest.util.SecurityContextUtils;
import ru.i_novus.platform.datastorage.temporal.service.FieldFactory;

@Configuration
public class BackendConfiguration {
    @Autowired
    private FieldFactory fieldFactory;
    @Value(value="${spring.activemq.broker-url}")
    private String brokerUrl;

    @Bean
    MskUtcLocalDateTimeParamConverter mskUtcLocalDateTimeParamConverter() {
        return new MskUtcLocalDateTimeParamConverter((TypedParamConverter)new LocalDateTimeISOParameterConverter());
    }

    @Bean
    public AttributeFilterConverter attributeFilterConverter(@Autowired @Qualifier(value="cxfObjectMapper") ObjectMapper objectMapper) {
        return new AttributeFilterConverter(objectMapper);
    }

    @Bean
    public OffsetDateTimeParamConverter offsetDateTimeParamConverter() {
        return new OffsetDateTimeParamConverter();
    }

    @Bean
    LocalDateTimeMapperPreparer localDateTimeMapperPreparer() {
        return new LocalDateTimeMapperPreparer();
    }

    @Bean
    ExportFileProvider exportFileProvider() {
        return new ExportFileProvider();
    }

    @Bean
    RdmMapperConfigurer rdmMapperConfigurer() {
        return new RdmMapperConfigurer();
    }

    @Bean
    @ConditionalOnClass(value={Messages.class})
    NotFoundExceptionMapper notFoundExceptionMapper(Messages messages) {
        return new NotFoundExceptionMapper(messages);
    }

    @Bean
    @ConditionalOnClass(value={Messages.class})
    IllegalArgumentExceptionMapper illegalArgumentExceptionMapper(Messages messages) {
        return new IllegalArgumentExceptionMapper(messages);
    }

    @Bean
    @ConditionalOnClass(value={Messages.class})
    StaleStateExceptionMapper staleStateExceptionMapper(Messages messages) {
        return new StaleStateExceptionMapper(messages);
    }

    @Bean
    @Primary
    @ConditionalOnClass(value={Messages.class})
    UserExceptionMapper userExceptionMapper(Messages messages) {
        return new UserExceptionMapper(messages);
    }

    @Bean
    @Qualifier(value="topicJmsTemplate")
    @ConditionalOnProperty(name={"rdm.enable.publish.topic"}, havingValue="true")
    public JmsTemplate topicJmsTemplate(ConnectionFactory connectionFactory) {
        JmsTemplate jmsTemplate = new JmsTemplate(connectionFactory);
        jmsTemplate.setPubSubDomain(true);
        jmsTemplate.setExplicitQosEnabled(true);
        long oneHour = 3600000L;
        jmsTemplate.setTimeToLive(oneHour);
        return jmsTemplate;
    }

    @Bean
    @Qualifier(value="queueJmsTemplate")
    public JmsTemplate queueJmsTemplate(ConnectionFactory connectionFactory) {
        return new JmsTemplate(connectionFactory);
    }

    @Bean
    public DefaultJmsListenerContainerFactory internalAsyncOperationContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setSessionTransacted(Boolean.valueOf(true));
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"rdm.enable.publish.topic"}, havingValue="true")
    public DefaultJmsListenerContainerFactory publishTopicListenerContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(true));
        factory.setSubscriptionShared(Boolean.valueOf(false));
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"rdm.enable.publish.topic"}, havingValue="true")
    public PublishListener publishListener() {
        return new PublishListener();
    }

    @Bean
    public UserAccessor userAccessor() {
        return () -> this.createAuditUser(SecurityContextUtils.getUserId(), SecurityContextUtils.getUserName());
    }

    private User createAuditUser(String id, String name) {
        return new User(id != null ? id : name, name);
    }

    @Bean
    @Value(value="${rdm.audit.application.name}")
    public SourceApplicationAccessor applicationAccessor(String appName) {
        return () -> appName;
    }
}

