/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.rest.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.impl.ContainerRequestContextImpl;
import org.apache.cxf.message.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@PreMatching
@Provider
@Component
public class PlainDataRequestFilter
implements ContainerRequestFilter {
    public static final String FILTER_PREFIX = "filter.";
    public static final String PLAIN_DATA_URL_PREFIX = "plainData";
    public static final String PLAIN_FILTER_QUERY_PARAM = "plainAttributeFilter";
    @Autowired
    @Qualifier(value="cxfObjectMapper")
    private ObjectMapper objectMapper;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!requestContext.getUriInfo().getPath().startsWith(PLAIN_DATA_URL_PREFIX)) {
            return;
        }
        Map<String, String> attributeFilters = requestContext.getUriInfo().getQueryParameters().entrySet().stream().filter((? super T e) -> ((String)e.getKey()).startsWith(FILTER_PREFIX)).filter((? super T e) -> !CollectionUtils.isEmpty((Collection)((Collection)e.getValue())) && StringUtils.isNotBlank((CharSequence)((CharSequence)((List)e.getValue()).get(0)))).collect(Collectors.toMap(e -> ((String)e.getKey()).replace(FILTER_PREFIX, ""), e -> (String)((List)e.getValue()).get(0)));
        if (CollectionUtils.isEmpty(attributeFilters)) {
            return;
        }
        Message message = ((ContainerRequestContextImpl)requestContext).getMessage();
        String plainAttributeFilter = this.objectMapper.writeValueAsString(attributeFilters);
        Object query = (String)message.get((Object)Message.QUERY_STRING);
        query = (String)query + "&plainAttributeFilter=" + URLEncoder.encode(plainAttributeFilter, StandardCharsets.UTF_8);
        message.put((Object)Message.QUERY_STRING, query);
    }
}

