/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.rest.loader;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import net.n2oapp.platform.loader.server.BaseLoaderRunner;
import net.n2oapp.platform.loader.server.LoaderDataInfo;
import net.n2oapp.platform.loader.server.ServerLoader;
import net.n2oapp.platform.loader.server.ServerLoaderRestService;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.model.FileModel;
import ru.i_novus.ms.rdm.api.service.FileStorageService;
import ru.i_novus.ms.rdm.rest.loader.RefBookDataRequest;

@Service
@Api(value="\u0417\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u0438 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432")
public class RefBookDataServerLoaderRunner
extends BaseLoaderRunner
implements ServerLoaderRestService {
    @Autowired
    private FileStorageService fileStorageService;
    @Value(value="${rdm.loader.enabled}")
    private boolean loaderEnabled;

    public RefBookDataServerLoaderRunner(List<ServerLoader> loaders) {
        super(loaders);
    }

    @POST
    @Path(value="/json/{subject}/{target}")
    @ApiOperation(value="\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c json-\u0434\u0430\u043d\u043d\u044b\u0435")
    @ApiResponse(code=200, message="\u0414\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0431\u0435\u0437 \u043e\u0448\u0438\u0431\u043e\u043a")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void run(@ApiParam(value="\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445") @PathParam(value="subject") String subject, @ApiParam(value="\u0412\u0438\u0434 \u0434\u0430\u043d\u043d\u044b\u0445") @PathParam(value="target") String target, InputStream body) {
        super.run(subject, target, body);
    }

    protected List<Object> read(InputStream body, LoaderDataInfo<?> info) {
        throw new IllegalArgumentException(String.format("Unsupported format for %s", info.getTarget()));
    }

    @POST
    @Path(value="/{subject}/{target}")
    @ApiOperation(value="\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a")
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0431\u0435\u0437 \u043e\u0448\u0438\u0431\u043e\u043a"), @ApiResponse(code=400, message="\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441"), @ApiResponse(code=404, message="\u041d\u0435\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430")})
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public void run(@ApiParam(value="\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445") @PathParam(value="subject") String subject, @ApiParam(value="\u0412\u0438\u0434 \u0434\u0430\u043d\u043d\u044b\u0445") @PathParam(value="target") String target, @ApiParam(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435") MultipartBody body) {
        if (!this.loaderEnabled) {
            return;
        }
        ServerLoader loader = this.find(target);
        RefBookDataRequest request = this.toRequest(body, (LoaderDataInfo<?>)loader);
        if (request == null) {
            return;
        }
        this.execute(subject, List.of(request), loader);
    }

    private RefBookDataRequest toRequest(MultipartBody body, LoaderDataInfo<?> info) {
        if (CollectionUtils.isEmpty((Collection)body.getAllAttachments())) {
            return null;
        }
        RefBookDataRequest request = new RefBookDataRequest();
        request.setPassport(new HashMap());
        for (Attachment attachment : body.getAllAttachments()) {
            this.parseAttachment(attachment, info, request);
        }
        return request;
    }

    private void parseAttachment(Attachment attachment, LoaderDataInfo<?> info, RefBookDataRequest request) {
        String fileName = this.getFileName(attachment);
        if (!StringUtils.isEmpty((Object)fileName)) {
            FileModel fileModel = this.readFile(attachment, fileName, info);
            request.setFileModel(fileModel);
            return;
        }
        String name = attachment.getDataHandler().getDataSource().getName();
        String value = (String)attachment.getObject(String.class);
        if (value == null) {
            value = this.readString(attachment, name, info);
        }
        if ("code".equals(name)) {
            request.setCode(value);
        }
        if ("name".equals(name)) {
            request.getPassport().put("name", value);
        }
        if ("structure".equals(name)) {
            request.setStructure(value);
        }
        if ("data".equals(name)) {
            request.setData(value);
        }
    }

    private String getFileName(Attachment attachment) {
        List contentDispositionHeaders = attachment.getHeaderAsList("Content-Disposition");
        if (CollectionUtils.isEmpty((Collection)contentDispositionHeaders) || StringUtils.isEmpty(contentDispositionHeaders.get(0))) {
            return null;
        }
        ContentDisposition contentDisposition = new ContentDisposition((String)contentDispositionHeaders.get(0));
        return contentDisposition.getFilename();
    }

    private FileModel readFile(Attachment attachment, String fileName, LoaderDataInfo<?> info) {
        try {
            return this.fileStorageService.save(attachment.getDataHandler().getDataSource().getInputStream(), fileName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot read attachment '%s' for %s", fileName, info.getTarget()), e);
        }
    }

    private String readString(Attachment attachment, String name, LoaderDataInfo<?> info) {
        try {
            InputStream inputStream = attachment.getDataHandler().getDataSource().getInputStream();
            if (inputStream == null) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot read attachment '%s' for %s", name, info.getTarget()), e);
        }
    }
}

