/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.rest.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.util.json.JsonUtil;

public class SecurityContextUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecurityContextUtils.class);
    private static final String DEFAULT_USER_ID = "UNKNOWN";
    private static final String DEFAULT_USER_NAME = "UNKNOWN";

    private SecurityContextUtils() {
        throw new UnsupportedOperationException();
    }

    public static String getUserId() {
        Jwt tokenValue = SecurityContextUtils.getTokenValue();
        String claims = tokenValue != null ? tokenValue.getClaims() : null;
        JsonNode jsonNode = SecurityContextUtils.claimsToJson(claims);
        JsonNode jsonValue = jsonNode != null ? jsonNode.get("email") : null;
        return jsonValue != null ? jsonValue.asText() : "UNKNOWN";
    }

    private static Jwt getTokenValue() {
        Authentication authentication = SecurityContextUtils.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object details = authentication.getDetails();
        String tokenValue = details instanceof OAuth2AuthenticationDetails ? ((OAuth2AuthenticationDetails)details).getTokenValue() : null;
        return StringUtils.isEmpty((Object)tokenValue) ? null : JwtHelper.decode((String)tokenValue);
    }

    private static JsonNode claimsToJson(String claims) {
        JsonNode jsonNode;
        if (StringUtils.isEmpty((Object)claims)) {
            return null;
        }
        try {
            jsonNode = JsonUtil.getMapper().readTree(claims);
        }
        catch (IOException e) {
            logger.error(String.format("Error reading token value claims from%n%s", claims), (Throwable)e);
            jsonNode = null;
        }
        return jsonNode;
    }

    public static String getUserName() {
        Object principal = SecurityContextUtils.getPrincipal();
        if (principal instanceof String) {
            return (String)principal;
        }
        return "UNKNOWN";
    }

    private static Object getPrincipal() {
        Authentication authentication = SecurityContextUtils.getAuthentication();
        if (authentication == null) {
            return null;
        }
        return authentication.getPrincipal();
    }

    private static Authentication getAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return null;
        }
        Authentication authentication = context.getAuthentication();
        return authentication instanceof AnonymousAuthenticationToken ? null : authentication;
    }
}

