/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import net.n2oapp.platform.jaxrs.LocalDateTimeISOParameterConverter;
import net.n2oapp.platform.jaxrs.TypedParamConverter;
import net.n2oapp.platform.jaxrs.autoconfigure.MissingGenericBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.model.version.AttributeFilter;
import ru.i_novus.ms.rdm.api.provider.AttributeFilterConverter;
import ru.i_novus.ms.rdm.api.provider.ExportFileProvider;
import ru.i_novus.ms.rdm.api.provider.IsoLocalDateParamConverter;
import ru.i_novus.ms.rdm.api.provider.MskUtcLocalDateTimeParamConverter;
import ru.i_novus.ms.rdm.api.provider.OffsetDateTimeParamConverter;
import ru.i_novus.ms.rdm.api.provider.RdmMapperConfigurer;
import ru.i_novus.ms.rdm.api.service.RefBookService;
import ru.i_novus.ms.rdm.sync.RdmClientSyncConfig;
import ru.i_novus.ms.rdm.sync.RdmClientSyncLiquibaseParameters;
import ru.i_novus.ms.rdm.sync.RdmClientSyncProperties;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.api.service.LocalRdmDataService;
import ru.i_novus.ms.rdm.sync.api.service.RdmSyncService;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDaoImpl;
import ru.i_novus.ms.rdm.sync.service.LocalRdmDataServiceImpl;
import ru.i_novus.ms.rdm.sync.service.LockingRdmSyncService;
import ru.i_novus.ms.rdm.sync.service.PublishListener;
import ru.i_novus.ms.rdm.sync.service.RdmLoggingService;
import ru.i_novus.ms.rdm.sync.service.RdmMappingService;
import ru.i_novus.ms.rdm.sync.service.RdmMappingServiceImpl;
import ru.i_novus.ms.rdm.sync.service.RdmSyncLocalRowStateService;
import ru.i_novus.ms.rdm.sync.service.RdmSyncServiceImpl;
import ru.i_novus.ms.rdm.sync.service.change_data.AsyncRdmChangeDataClient;
import ru.i_novus.ms.rdm.sync.service.change_data.RdmChangeDataClient;
import ru.i_novus.ms.rdm.sync.service.change_data.RdmChangeDataListener;
import ru.i_novus.ms.rdm.sync.service.change_data.RdmChangeDataRequestCallback;
import ru.i_novus.ms.rdm.sync.service.change_data.SyncRdmChangeDataClient;
import ru.i_novus.ms.rdm.sync.service.init.LocalRefBookCreator;
import ru.i_novus.ms.rdm.sync.service.init.LocalRefBookCreatorLocator;
import ru.i_novus.ms.rdm.sync.service.persister.PersisterService;
import ru.i_novus.ms.rdm.sync.service.updater.NotVersionedRefBookUpdater;
import ru.i_novus.ms.rdm.sync.service.updater.RdmNotVersionedRefBookUpdater;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookUpdater;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookUpdaterLocator;
import ru.i_novus.ms.rdm.sync.service.updater.SimpleVersionedRefBookUpdater;

@Configuration
@ConditionalOnClass(value={RdmSyncServiceImpl.class})
@ConditionalOnProperty(value={"rdm-sync.enabled"}, matchIfMissing=true)
@ComponentScan(value={"ru.i_novus.ms.rdm", "ru.i_novus.ms.fnsi"})
@EnableConfigurationProperties(value={RdmClientSyncProperties.class})
@AutoConfigureAfter(value={LiquibaseAutoConfiguration.class})
@EnableJms
public class RdmClientSyncAutoConfiguration {
    @Autowired
    @Qualifier(value="cxfObjectMapper")
    private ObjectMapper objectMapper;

    @Bean
    @ConditionalOnMissingBean
    public RdmClientSyncConfig rdmClientSyncConfig(RdmClientSyncProperties properties) {
        String url = properties.getUrl();
        if (StringUtils.isEmpty((Object)url)) {
            throw new IllegalArgumentException("Rdm client synchronizer properties not configured properly: url is missing");
        }
        RdmClientSyncConfig config = new RdmClientSyncConfig();
        config.put("url", url);
        return config;
    }

    @Bean
    @DependsOn(value={"liquibase"})
    public SpringLiquibase liquibaseRdm(DataSource dataSource, RdmClientSyncLiquibaseParameters parameters) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setDatabaseChangeLogLockTable("databasechangeloglock_rdms");
        liquibase.setChangeLog("classpath*:/rdm-sync-db/baseChangelog.xml");
        HashMap<String, String> changeLogParameters = new HashMap<String, String>(2);
        changeLogParameters.put("quartz_schema_name", parameters.getQuartzSchemaName());
        changeLogParameters.put("quartz_table_prefix", parameters.getQuartzTablePrefix());
        liquibase.setChangeLogParameters(changeLogParameters);
        return liquibase;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory"})
    @ConditionalOnProperty(name={"rdm-sync.publish.listener.enable"}, havingValue="true")
    public RdmSyncService lockingRdmSyncRest() {
        return new LockingRdmSyncService();
    }

    @Bean
    @ConditionalOnMissingBean
    public RdmSyncService rdmSyncRest() {
        return new RdmSyncServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public RdmMappingService rdmMappingService() {
        return new RdmMappingServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public RdmLoggingService rdmLoggingService() {
        return new RdmLoggingService();
    }

    @Bean
    @ConditionalOnMissingBean
    public RdmSyncDao rdmSyncDao() {
        return new RdmSyncDaoImpl();
    }

    @Bean
    @Conditional(value={MissingGenericBean.class})
    public TypedParamConverter<LocalDateTime> mskUtcLocalDateTimeParamConverter() {
        return new MskUtcLocalDateTimeParamConverter((TypedParamConverter)new LocalDateTimeISOParameterConverter());
    }

    @Bean
    @Conditional(value={MissingGenericBean.class})
    public TypedParamConverter<LocalDate> isoLocaldateParamConverter() {
        return new IsoLocalDateParamConverter();
    }

    @Bean
    @Conditional(value={MissingGenericBean.class})
    public TypedParamConverter<AttributeFilter> attributeFilterConverter() {
        return new AttributeFilterConverter(this.objectMapper);
    }

    @Bean
    @Conditional(value={MissingGenericBean.class})
    public TypedParamConverter<OffsetDateTime> offsetDateTimeParamConverter() {
        return new OffsetDateTimeParamConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExportFileProvider exportFileProvider() {
        return new ExportFileProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public RdmMapperConfigurer rdmMapperConfigurer() {
        return new RdmMapperConfigurer();
    }

    @Bean(name={"publishDictionaryTopicMessageListenerContainerFactory"})
    @ConditionalOnProperty(name={"rdm-sync.publish.listener.enable"}, havingValue="true")
    @ConditionalOnClass(name={"org.apache.activemq.ActiveMQConnectionFactory"})
    public DefaultJmsListenerContainerFactory unsharedPublishContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(true));
        factory.setSubscriptionShared(Boolean.valueOf(false));
        return factory;
    }

    @Bean(name={"publishDictionaryTopicMessageListenerContainerFactory"})
    @ConditionalOnProperty(name={"rdm-sync.publish.listener.enable"}, havingValue="true")
    @ConditionalOnClass(name={"org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory"})
    public DefaultJmsListenerContainerFactory sharedPublishContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(true));
        factory.setSubscriptionShared(Boolean.valueOf(true));
        return factory;
    }

    @Bean
    @ConditionalOnProperty(value={"rdm-sync.change_data.mode"}, havingValue="async")
    public DefaultJmsListenerContainerFactory rdmChangeDataQueueMessageListenerContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setSessionTransacted(Boolean.valueOf(true));
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"rdm-sync.publish.listener.enable"}, havingValue="true")
    public PublishListener publishListener(RdmSyncService rdmSyncService) {
        return new PublishListener(rdmSyncService);
    }

    @Bean
    @ConditionalOnProperty(name={"rdm-sync.change_data.mode"}, havingValue="async")
    public RdmChangeDataListener rdmChangeDataListener(RefBookService refBookService, RdmChangeDataRequestCallback rdmChangeDataRequestCallback) {
        return new RdmChangeDataListener(refBookService, rdmChangeDataRequestCallback);
    }

    @Bean
    @ConditionalOnProperty(value={"rdm-sync.change_data.mode"}, havingValue="sync")
    public RdmChangeDataClient syncRdmChangeDataClient(RefBookService refBookService) {
        return new SyncRdmChangeDataClient(refBookService);
    }

    @Bean
    @ConditionalOnProperty(value={"rdm-sync.change_data.mode"}, havingValue="async")
    public RdmChangeDataClient asyncRdmChangeDataClient(JmsTemplate jmsTemplate, @Value(value="${rdm-sync.change_data.queue:rdmChangeData}") String rdmChangeDataQueue) {
        return new AsyncRdmChangeDataClient(jmsTemplate, rdmChangeDataQueue);
    }

    @Bean
    public RdmChangeDataRequestCallback rdmChangeDataRequestCallback() {
        return new RdmChangeDataRequestCallback.DefaultRdmChangeDataRequestCallback();
    }

    @Bean
    @ConditionalOnMissingBean
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate(JdbcTemplate jdbcTemplate) {
        return new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
    }

    @Bean
    public RdmSyncLocalRowStateService rdmSyncLocalRowStateService() {
        return new RdmSyncLocalRowStateService(this.rdmSyncDao());
    }

    @Bean
    public LocalRdmDataService localRdmDataService() {
        return new LocalRdmDataServiceImpl();
    }

    @Bean
    public RefBookUpdater notVersionedRefBookUpdater(RdmSyncDao rdmSyncDao, SyncSourceService syncSourceService, @Qualifier(value="notVersionedPersisterService") PersisterService persisterService, RdmLoggingService rdmLoggingService) {
        return new NotVersionedRefBookUpdater(rdmSyncDao, syncSourceService, persisterService, rdmLoggingService);
    }

    @Bean
    public RefBookUpdater rdmNotVersionedRefBookUpdater(RdmSyncDao rdmSyncDao, SyncSourceService syncSourceService, @Qualifier(value="notVersionedPersisterService") PersisterService persisterService, RdmLoggingService rdmLoggingService) {
        return new RdmNotVersionedRefBookUpdater(rdmSyncDao, syncSourceService, persisterService, rdmLoggingService);
    }

    @Bean
    public RefBookUpdater simpleVersionedRefBookUpdater(RdmSyncDao rdmSyncDao, SyncSourceService syncSourceService, @Qualifier(value="simpleVersionedPersisterService") PersisterService persisterService, RdmLoggingService rdmLoggingService) {
        return new SimpleVersionedRefBookUpdater(rdmSyncDao, syncSourceService, persisterService, rdmLoggingService);
    }

    @Bean
    public RefBookUpdaterLocator refBookUpdaterLocator(@Qualifier(value="notVersionedRefBookUpdater") RefBookUpdater notVersionedRefBookUpdater, @Qualifier(value="rdmNotVersionedRefBookUpdater") RefBookUpdater rdmNotVersionedRefBookUpdater, @Qualifier(value="simpleVersionedRefBookUpdater") RefBookUpdater simpleVersionedRefBookUpdater) {
        return new RefBookUpdaterLocator(Map.of(SyncTypeEnum.NOT_VERSIONED, notVersionedRefBookUpdater, SyncTypeEnum.RDM_NOT_VERSIONED, rdmNotVersionedRefBookUpdater, SyncTypeEnum.SIMPLE_VERSIONED, simpleVersionedRefBookUpdater, SyncTypeEnum.NOT_VERSIONED_WITH_NATURAL_PK, notVersionedRefBookUpdater, SyncTypeEnum.RDM_NOT_VERSIONED_WITH_NATURAL_PK, rdmNotVersionedRefBookUpdater));
    }

    @Bean
    public LocalRefBookCreatorLocator localRefBookCreatorLocator(@Qualifier(value="notVersionedLocalRefBookCreator") LocalRefBookCreator notVersionedLocalRefBookCreator, @Qualifier(value="versionedLocalRefBookCreator") LocalRefBookCreator versionedLocalRefBookCreator, @Qualifier(value="naturalPKLocalRefBookCreator") LocalRefBookCreator naturalPKLocalRefBookCreator, @Qualifier(value="simpleVersionedLocalRefBookCreator") LocalRefBookCreator simpleVersionedLocalRefBookCreator) {
        return new LocalRefBookCreatorLocator(Map.of(SyncTypeEnum.NOT_VERSIONED, notVersionedLocalRefBookCreator, SyncTypeEnum.SIMPLE_VERSIONED, simpleVersionedLocalRefBookCreator, SyncTypeEnum.RDM_NOT_VERSIONED, notVersionedLocalRefBookCreator, SyncTypeEnum.NOT_VERSIONED_WITH_NATURAL_PK, naturalPKLocalRefBookCreator, SyncTypeEnum.RDM_NOT_VERSIONED_WITH_NATURAL_PK, naturalPKLocalRefBookCreator));
    }
}

