/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.dao;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Pair;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.api.model.AbstractCriteria;
import ru.i_novus.ms.rdm.api.util.StringUtils;
import ru.i_novus.ms.rdm.sync.api.log.Log;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.LoadedVersion;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.api.model.SyncRefBook;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.dao.builder.SqlFilterBuilder;
import ru.i_novus.ms.rdm.sync.dao.criteria.BaseDataCriteria;
import ru.i_novus.ms.rdm.sync.dao.criteria.LocalDataCriteria;
import ru.i_novus.ms.rdm.sync.dao.criteria.VersionedLocalDataCriteria;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.model.filter.FieldFilter;
import ru.i_novus.ms.rdm.sync.service.RdmMappingService;
import ru.i_novus.ms.rdm.sync.service.RdmSyncLocalRowState;

public class RdmSyncDaoImpl
implements RdmSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(RdmSyncDaoImpl.class);
    private static final String INTERNAL_FUNCTION = "rdm_sync_internal_update_local_row_state()";
    private static final String LOCAL_ROW_STATE_UPDATE_FUNC = "CREATE OR REPLACE FUNCTION %1$s\n  RETURNS trigger AS \n$BODY$ \n  BEGIN \n    NEW.%2$s='%3$s'; \n    RETURN NEW; \n  END; \n$BODY$ LANGUAGE 'plpgsql' \n";
    private static final String RECORD_SYS_COL = "_sync_rec_id";
    private static final String RECORD_SYS_COL_INFO = "bigserial PRIMARY KEY";
    private static final String VERSIONS_SYS_COL = "_versions";
    private static final String LOADED_VERSION_REF = "version_id";
    private static final String HASH_SYS_COL = "_hash";
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    private RdmMappingService rdmMappingService;

    @Override
    public List<VersionMapping> getVersionMappings() {
        String sql = "SELECT m.id, code, name, version, \n       sys_table, sys_pk_field, (SELECT s.code FROM rdm_sync.source s WHERE s.id = r.source_id), unique_sys_field, deleted_field, \n       mapping_last_updated, mapping_version, mapping_id, sync_type, range \n  FROM rdm_sync.version v \n INNER JOIN rdm_sync.mapping m ON m.id = v.mapping_id \n INNER JOIN rdm_sync.refbook r ON r.id = v.ref_id \n";
        return this.namedParameterJdbcTemplate.query("SELECT m.id, code, name, version, \n       sys_table, sys_pk_field, (SELECT s.code FROM rdm_sync.source s WHERE s.id = r.source_id), unique_sys_field, deleted_field, \n       mapping_last_updated, mapping_version, mapping_id, sync_type, range \n  FROM rdm_sync.version v \n INNER JOIN rdm_sync.mapping m ON m.id = v.mapping_id \n INNER JOIN rdm_sync.refbook r ON r.id = v.ref_id \n", (rs, rowNum) -> new VersionMapping(Integer.valueOf(rs.getInt(1)), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(9), this.toLocalDateTime(rs, 10, LocalDateTime.MIN), rs.getInt(11), Integer.valueOf(rs.getInt(12)), SyncTypeEnum.valueOf((String)rs.getString(13)), rs.getString(14)));
    }

    @Override
    public LoadedVersion getLoadedVersion(String code, String version) {
        List result = this.namedParameterJdbcTemplate.query("select * from rdm_sync.loaded_version where code = :code and version = :version", Map.of("code", code, "version", version), (rs, rowNum) -> new LoadedVersion(Integer.valueOf(rs.getInt("id")), rs.getString("code"), rs.getString("version"), rs.getTimestamp("publication_dt").toLocalDateTime(), this.toLocalDateTime(rs.getTimestamp("close_dt")), rs.getTimestamp("load_dt").toLocalDateTime(), Boolean.valueOf(rs.getBoolean("is_actual"))));
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        return (LoadedVersion)result.get(0);
    }

    @Override
    public List<LoadedVersion> getLoadedVersions(String code) {
        return this.namedParameterJdbcTemplate.query("select * from rdm_sync.loaded_version where code = :code ", Map.of("code", code), (rs, rowNum) -> new LoadedVersion(Integer.valueOf(rs.getInt("id")), rs.getString("code"), rs.getString("version"), rs.getTimestamp("publication_dt").toLocalDateTime(), this.toLocalDateTime(rs.getTimestamp("close_dt")), rs.getTimestamp("load_dt").toLocalDateTime(), Boolean.valueOf(rs.getBoolean("is_actual"))));
    }

    @Override
    public LoadedVersion getActualLoadedVersion(String code) {
        List result = this.namedParameterJdbcTemplate.query("select * from rdm_sync.loaded_version where code = :code and is_actual = true", Map.of("code", code), (rs, rowNum) -> new LoadedVersion(Integer.valueOf(rs.getInt("id")), rs.getString("code"), rs.getString("version"), rs.getTimestamp("publication_dt").toLocalDateTime(), this.toLocalDateTime(rs.getTimestamp("close_dt")), rs.getTimestamp("load_dt").toLocalDateTime(), Boolean.valueOf(rs.getBoolean("is_actual"))));
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        return (LoadedVersion)result.get(0);
    }

    @Override
    public boolean existsLoadedVersion(String code) {
        return (Boolean)this.namedParameterJdbcTemplate.queryForObject("select exists(select 1 from rdm_sync.loaded_version where code = :code)", Map.of("code", code), Boolean.class);
    }

    @Override
    public VersionMapping getVersionMapping(String refbookCode, String version) {
        String sql = "SELECT m.id, code, name, version, \n       sys_table, sys_pk_field, (SELECT s.code FROM rdm_sync.source s WHERE s.id = r.source_id), unique_sys_field, deleted_field, \n       mapping_last_updated, mapping_version, mapping_id, sync_type, range \n  FROM rdm_sync.version v \n INNER JOIN rdm_sync.mapping m ON m.id = v.mapping_id \n INNER JOIN rdm_sync.refbook r ON r.id = v.ref_id \n WHERE code = :code and version = :version \n";
        List list = this.namedParameterJdbcTemplate.query("SELECT m.id, code, name, version, \n       sys_table, sys_pk_field, (SELECT s.code FROM rdm_sync.source s WHERE s.id = r.source_id), unique_sys_field, deleted_field, \n       mapping_last_updated, mapping_version, mapping_id, sync_type, range \n  FROM rdm_sync.version v \n INNER JOIN rdm_sync.mapping m ON m.id = v.mapping_id \n INNER JOIN rdm_sync.refbook r ON r.id = v.ref_id \n WHERE code = :code and version = :version \n", Map.of("code", refbookCode, "version", version), (rs, rowNum) -> new VersionMapping(Integer.valueOf(rs.getInt(1)), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(9), this.toLocalDateTime(rs, 10, LocalDateTime.MIN), rs.getInt(11), Integer.valueOf(rs.getInt(12)), SyncTypeEnum.valueOf((String)rs.getString(13)), rs.getString(14)));
        return !list.isEmpty() ? (VersionMapping)list.get(0) : null;
    }

    @Override
    public int getLastMappingVersion(String refbookCode) {
        String sql = "select m.mapping_version from rdm_sync.refbook r\ninner join rdm_sync.version v on v.ref_id = r.id and v.version = 'CURRENT'\ninner join rdm_sync.mapping m on m.id = v.mapping_id\nwhere r.code = :code";
        List list = this.namedParameterJdbcTemplate.query("select m.mapping_version from rdm_sync.refbook r\ninner join rdm_sync.version v on v.ref_id = r.id and v.version = 'CURRENT'\ninner join rdm_sync.mapping m on m.id = v.mapping_id\nwhere r.code = :code", Map.of("code", refbookCode), (rs, rowNum) -> rs.getInt(1));
        return !list.isEmpty() ? (Integer)list.get(0) : 0;
    }

    @Override
    public List<FieldMapping> getFieldMappings(String refbookCode) {
        String sql = "SELECT m.sys_field, m.sys_data_type, m.rdm_field \n  FROM rdm_sync.field_mapping m \n WHERE m.mapping_id = ( \n       SELECT v.mapping_id \n         FROM rdm_sync.version v \n        WHERE v.ref_id = ( \n              SELECT r.id FROM rdm_sync.refbook r WHERE r.code = :code \n              )          AND v.version = :version \n       ) \n";
        return this.namedParameterJdbcTemplate.query("SELECT m.sys_field, m.sys_data_type, m.rdm_field \n  FROM rdm_sync.field_mapping m \n WHERE m.mapping_id = ( \n       SELECT v.mapping_id \n         FROM rdm_sync.version v \n        WHERE v.ref_id = ( \n              SELECT r.id FROM rdm_sync.refbook r WHERE r.code = :code \n              )          AND v.version = :version \n       ) \n", Map.of("code", refbookCode, "version", "CURRENT"), (rs, rowNum) -> new FieldMapping(rs.getString(1), rs.getString(2), rs.getString(3)));
    }

    @Override
    public List<FieldMapping> getFieldMappings(Integer mappingId) {
        String sql = "SELECT m.sys_field, m.sys_data_type, m.rdm_field \n  FROM rdm_sync.field_mapping m \n WHERE m.mapping_id = :mappingId";
        return this.namedParameterJdbcTemplate.query("SELECT m.sys_field, m.sys_data_type, m.rdm_field \n  FROM rdm_sync.field_mapping m \n WHERE m.mapping_id = :mappingId", Map.of("mappingId", mappingId), (rs, rowNum) -> new FieldMapping(rs.getString(1), rs.getString(2), rs.getString(3)));
    }

    @Override
    public List<Pair<String, String>> getLocalColumnTypes(String schemaTable) {
        String table;
        String sql = "SELECT column_name, data_type \n  FROM information_schema.columns \n WHERE table_schema = :schemaName \n   AND table_name = :tableName \n   AND column_name != :internal_local_row_state_column";
        String[] split = schemaTable.split("\\.");
        String schema = split[0];
        List list = this.namedParameterJdbcTemplate.query(sql, Map.of("schemaName", schema, "tableName", table = split[1], "internal_local_row_state_column", "rdm_sync_internal_local_row_state"), (rs, rowNum) -> Pair.of((Object)rs.getString(1), (Object)rs.getString(2)));
        if (list.isEmpty()) {
            throw new RdmException("No table '" + table + "' in schema '" + schema + "'.");
        }
        return list;
    }

    @Override
    public List<Object> getDataIds(String schemaTable, FieldMapping primaryFieldMapping) {
        String sql = String.format("SELECT %s FROM %s", StringUtils.addDoubleQuotes((String)primaryFieldMapping.getSysField()), this.escapeName(schemaTable));
        DataTypeEnum dataType = DataTypeEnum.getByDataType(primaryFieldMapping.getSysDataType());
        return this.namedParameterJdbcTemplate.query(sql, (rs, rowNum) -> this.rdmMappingService.map(AttributeTypeEnum.STRING, dataType, rs.getObject(1)));
    }

    @Override
    public boolean isIdExists(String schemaTable, String primaryField, Object primaryValue) {
        String sql = String.format("SELECT count(*) > 0 FROM %s WHERE %s = :primary", this.escapeName(schemaTable), StringUtils.addDoubleQuotes((String)primaryField));
        Boolean result = (Boolean)this.namedParameterJdbcTemplate.queryForObject(sql, Map.of("primary", primaryValue), Boolean.class);
        return Boolean.TRUE.equals(result);
    }

    @Override
    public Integer insertLoadedVersion(String code, String version, LocalDateTime publishDate, LocalDateTime closeDate, boolean actual) {
        String sql = "INSERT INTO rdm_sync.loaded_version(code, version, publication_dt, close_dt, load_dt, is_actual) \n   VALUES(:code, :version, :publishDate, :closeDate, :updateDate, :actual) RETURNING id";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("version", version);
        params.put("publishDate", publishDate);
        params.put("closeDate", closeDate);
        params.put("updateDate", LocalDateTime.now(Clock.systemUTC()));
        params.put("code", code);
        params.put("actual", actual);
        return (Integer)this.namedParameterJdbcTemplate.queryForObject("INSERT INTO rdm_sync.loaded_version(code, version, publication_dt, close_dt, load_dt, is_actual) \n   VALUES(:code, :version, :publishDate, :closeDate, :updateDate, :actual) RETURNING id", params, Integer.class);
    }

    @Override
    public void updateLoadedVersion(Integer id, String version, LocalDateTime publishDate, LocalDateTime closeDate) {
        String sql = "UPDATE rdm_sync.loaded_version \n   SET version = :version, \n       publication_dt = :publication_dt, \n       close_dt = :close_dt, \n       load_dt = :load_dt \n WHERE id = :id";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("version", version);
        params.put("publication_dt", publishDate);
        params.put("close_dt", closeDate);
        params.put("load_dt", LocalDateTime.now(Clock.systemUTC()));
        params.put("id", id);
        this.namedParameterJdbcTemplate.update("UPDATE rdm_sync.loaded_version \n   SET version = :version, \n       publication_dt = :publication_dt, \n       close_dt = :close_dt, \n       load_dt = :load_dt \n WHERE id = :id", params);
    }

    @Override
    public void closeLoadedVersion(String code, String version, LocalDateTime closeDate) {
        String sql = "UPDATE rdm_sync.loaded_version \n   SET close_dt = :closeDate, is_actual=false \n WHERE version = :version and code = :code";
        this.namedParameterJdbcTemplate.update("UPDATE rdm_sync.loaded_version \n   SET close_dt = :closeDate, is_actual=false \n WHERE version = :version and code = :code", Map.of("version", version, "closeDate", closeDate, "code", code));
    }

    @Override
    public void insertRow(String schemaTable, Map<String, Object> row, boolean markSynced) {
        this.insertRows(schemaTable, List.of(row), markSynced);
    }

    @Override
    public void insertRows(String schemaTable, List<Map<String, Object>> rows, boolean markSynced) {
        List<Map<String, Object>> newRows = rows.stream().map(map -> {
            HashMap<String, String> newMap = new HashMap<String, String>((Map<String, String>)map);
            newMap.put("rdm_sync_internal_local_row_state", RdmSyncLocalRowState.SYNCED.name());
            return newMap;
        }).collect(Collectors.toList());
        this.insertRows(schemaTable, newRows);
    }

    @Override
    public void insertVersionedRows(String schemaTable, List<Map<String, Object>> rows, String version) {
        this.insertRows(schemaTable, this.convertToVersionedRows(rows, version));
    }

    @Override
    public void insertSimpleVersionedRows(String schemaTable, List<Map<String, Object>> rows, Integer loadedVersionId) {
        this.insertRows(schemaTable, this.convertToSimpleVersionedRows(rows, loadedVersionId));
    }

    @Override
    public void updateRow(String schemaTable, String primaryField, Map<String, Object> row, boolean markSynced) {
        if (markSynced) {
            row = new HashMap<String, Object>(row);
            row.put("rdm_sync_internal_local_row_state", RdmSyncLocalRowState.SYNCED.name());
        }
        this.executeUpdate(schemaTable, Collections.singletonList(row), primaryField);
    }

    @Override
    public void updateRows(String schemaTable, String primaryField, List<Map<String, Object>> rows, boolean markSynced) {
        this.executeUpdate(schemaTable, rows, primaryField);
    }

    @Override
    public void markDeleted(String schemaTable, String primaryField, String isDeletedField, Object primaryValue, LocalDateTime deletedTime, boolean markSynced) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(primaryField, primaryValue);
        args.put(isDeletedField, deletedTime);
        if (markSynced) {
            args.put("rdm_sync_internal_local_row_state", RdmSyncLocalRowState.SYNCED.name());
        }
        this.executeUpdate(schemaTable, Collections.singletonList(args), primaryField);
    }

    @Override
    public void markDeleted(String schemaTable, String isDeletedField, LocalDateTime deletedTime, boolean markSynced) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (markSynced) {
            args.put("rdm_sync_internal_local_row_state", RdmSyncLocalRowState.SYNCED.name());
        }
        args.put(isDeletedField, deletedTime);
        List rows = Collections.singletonList(args);
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        String sqlFormat = "UPDATE %s SET %s WHERE %s IS NULL";
        String fields = ((Map)rows.get(0)).keySet().stream().map(field -> StringUtils.addDoubleQuotes((String)field) + " = :" + field).collect(Collectors.joining(", "));
        String sql = String.format(sqlFormat, schemaTable, fields, this.escapeName(isDeletedField));
        Map[] batchValues = new Map[rows.size()];
        this.namedParameterJdbcTemplate.batchUpdate(sql, rows.toArray(batchValues));
    }

    @Override
    public void markDeleted(String schemaTable, String primaryField, String deletedField, List<Object> primaryValues, @Nullable LocalDateTime deletedTime) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("primaryFieldValues", primaryValues);
        args.put("deletedValue", deletedTime);
        String sql = "UPDATE " + this.escapeName(schemaTable) + "SET rdm_sync_internal_local_row_state='" + RdmSyncLocalRowState.SYNCED.name() + "'," + this.escapeName(deletedField) + "= :deletedValue  WHERE " + this.escapeName(primaryField) + "in (:primaryFieldValues)";
        this.namedParameterJdbcTemplate.update(sql, args);
    }

    private List<Map<String, Object>> convertToVersionedRows(List<Map<String, Object>> rows, String version) {
        return rows.stream().map(row -> {
            HashMap<String, Object> newMap = new HashMap<String, Object>((Map<String, Object>)row);
            StringBuilder stringBuilder = new StringBuilder();
            row.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> stringBuilder.append((String)entry.getKey()).append("=").append(entry.getValue()).append(";"));
            newMap.put(HASH_SYS_COL, DigestUtils.md5DigestAsHex((byte[])stringBuilder.toString().getBytes(StandardCharsets.UTF_8)));
            newMap.put(VERSIONS_SYS_COL, "{" + version + "}");
            return newMap;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> convertToSimpleVersionedRows(List<Map<String, Object>> rows, Integer loadedVersionId) {
        return rows.stream().map(row -> {
            HashMap<String, Integer> newMap = new HashMap<String, Integer>((Map<String, Integer>)row);
            StringBuilder stringBuilder = new StringBuilder();
            row.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> stringBuilder.append((String)entry.getKey()).append("=").append(entry.getValue()).append(";"));
            newMap.put(LOADED_VERSION_REF, loadedVersionId);
            return newMap;
        }).collect(Collectors.toList());
    }

    private void insertRows(String schemaTable, List<Map<String, Object>> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        StringJoiner columns = new StringJoiner(",");
        StringJoiner values = new StringJoiner(",");
        Map[] batchValues = new Map[rows.size()];
        this.concatColumnsAndValues(columns, values, batchValues, rows);
        String sql = String.format("INSERT INTO %s (%s) VALUES(%s)", this.escapeName(schemaTable), columns, values);
        this.namedParameterJdbcTemplate.batchUpdate(sql, batchValues);
    }

    private void executeUpdate(String table, List<Map<String, Object>> rows, String primaryField) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        Object sqlFormat = "UPDATE %s SET %s";
        if (primaryField != null) {
            sqlFormat = (String)sqlFormat + " WHERE %s = :%s";
        }
        String fields = rows.get(0).keySet().stream().filter(field -> !field.equals(primaryField)).map(field -> StringUtils.addDoubleQuotes((String)field) + " = :" + field).collect(Collectors.joining(", "));
        String sql = String.format((String)sqlFormat, this.escapeName(table), fields, StringUtils.addDoubleQuotes((String)primaryField), primaryField);
        Map[] batchValues = new Map[rows.size()];
        this.namedParameterJdbcTemplate.batchUpdate(sql, rows.toArray(batchValues));
    }

    @Override
    public void log(String status, String refbookCode, String oldVersion, String newVersion, String message, String stack) {
        String sql = "INSERT INTO rdm_sync.log \n      (code, current_version, new_version, status, date, message, stack) \nVALUES(?,?,?,?,?,?,?)";
        this.getJdbcTemplate().update("INSERT INTO rdm_sync.log \n      (code, current_version, new_version, status, date, message, stack) \nVALUES(?,?,?,?,?,?,?)", new Object[]{refbookCode, oldVersion, newVersion, status, new Date(), message, stack});
    }

    @Override
    public List<Log> getList(LocalDate date, String refbookCode) {
        LocalDate end = date.plusDays(1L);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(date);
        args.add(end);
        if (refbookCode != null) {
            args.add(refbookCode);
        }
        String sqlFormat = "SELECT id, code, current_version, new_version, \n       status, date, message, stack \n  FROM rdm_sync.log \n WHERE date >= ? \n   AND date < ? \n%s";
        String sql = String.format("SELECT id, code, current_version, new_version, \n       status, date, message, stack \n  FROM rdm_sync.log \n WHERE date >= ? \n   AND date < ? \n%s", refbookCode != null ? "   AND code = ?" : "");
        return this.getJdbcTemplate().query(sql, (rs, rowNum) -> new Log(Long.valueOf(rs.getLong(1)), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getTimestamp(6).toLocalDateTime(), rs.getString(7), rs.getString(8)), args.toArray());
    }

    @Override
    @Transactional
    public Integer insertVersionMapping(VersionMapping versionMapping) {
        String insMappingSql = "insert into rdm_sync.mapping (\n    deleted_field,\n    mapping_version,\n    sys_table,\n    sys_pk_field,\n    unique_sys_field)\nvalues (\n    :deleted_field,\n    :mapping_version,\n    :sys_table,\n    :sys_pk_field,\n    :unique_sys_field) RETURNING id";
        Integer mappingId = (Integer)this.namedParameterJdbcTemplate.queryForObject("insert into rdm_sync.mapping (\n    deleted_field,\n    mapping_version,\n    sys_table,\n    sys_pk_field,\n    unique_sys_field)\nvalues (\n    :deleted_field,\n    :mapping_version,\n    :sys_table,\n    :sys_pk_field,\n    :unique_sys_field) RETURNING id", this.toInsertMappingValues(versionMapping), Integer.class);
        String insRefSql = "insert into rdm_sync.refbook(code, name, source_id, sync_type, range) values(:code, :name, (SELECT id FROM rdm_sync.source WHERE code=:source_code), :type, :range)  RETURNING id";
        String refBookName = versionMapping.getRefBookName();
        HashMap<String, String> params = new HashMap<String, String>(Map.of("code", versionMapping.getCode(), "name", refBookName != null ? refBookName : versionMapping.getCode(), "source_code", versionMapping.getSource(), "type", versionMapping.getType().name()));
        params.put("range", versionMapping.getRange());
        Integer refBookId = (Integer)this.namedParameterJdbcTemplate.queryForObject("insert into rdm_sync.refbook(code, name, source_id, sync_type, range) values(:code, :name, (SELECT id FROM rdm_sync.source WHERE code=:source_code), :type, :range)  RETURNING id", params, Integer.class);
        this.namedParameterJdbcTemplate.update("insert into rdm_sync.version(ref_id, mapping_id, version) values(:refId, :mappingId, :version)", Map.of("refId", refBookId, "mappingId", mappingId, "version", versionMapping.getRefBookVersion() != null ? versionMapping.getRefBookVersion() : "CURRENT"));
        return mappingId;
    }

    private Map<String, Object> toInsertMappingValues(VersionMapping versionMapping) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("mapping_version", versionMapping.getMappingVersion());
        result.put("sys_table", versionMapping.getTable());
        result.put("sys_pk_field", versionMapping.getSysPkColumn());
        result.put("unique_sys_field", versionMapping.getPrimaryField());
        result.put("deleted_field", versionMapping.getDeletedField());
        return result;
    }

    @Override
    public void updateCurrentMapping(VersionMapping versionMapping) {
        String sql = "update rdm_sync.mapping set deleted_field = :deleted_field, mapping_version = :mapping_version, sys_table = :sys_table, unique_sys_field = :unique_sys_field where id = (select mapping_id from rdm_sync.version where version = :version and ref_id = (select id from rdm_sync.refbook where code = :code))";
        this.namedParameterJdbcTemplate.update("update rdm_sync.mapping set deleted_field = :deleted_field, mapping_version = :mapping_version, sys_table = :sys_table, unique_sys_field = :unique_sys_field where id = (select mapping_id from rdm_sync.version where version = :version and ref_id = (select id from rdm_sync.refbook where code = :code))", this.toUpdateMappingValues(versionMapping));
        String updateRefbook = "update rdm_sync.refbook set (name, source_id, sync_type, range) = (:name, (select id from rdm_sync.source where code = :source_code), :sync_type, :range)  where code = :code";
        HashMap<String, String> updateParams = new HashMap<String, String>(Map.of("code", versionMapping.getCode(), "source_code", versionMapping.getSource(), "sync_type", versionMapping.getType().toString(), "name", versionMapping.getRefBookName()));
        updateParams.put("range", versionMapping.getRange());
        this.namedParameterJdbcTemplate.update("update rdm_sync.refbook set (name, source_id, sync_type, range) = (:name, (select id from rdm_sync.source where code = :source_code), :sync_type, :range)  where code = :code", updateParams);
    }

    private Map<String, Object> toUpdateMappingValues(VersionMapping versionMapping) {
        HashMap<String, Object> result = new HashMap<String, Object>(6);
        result.put("code", versionMapping.getCode());
        result.put("version", versionMapping.getRefBookVersion() != null ? versionMapping.getRefBookVersion() : "CURRENT");
        result.put("mapping_version", versionMapping.getMappingVersion());
        result.put("sys_table", versionMapping.getTable());
        result.put("unique_sys_field", versionMapping.getPrimaryField());
        result.put("deleted_field", versionMapping.getDeletedField());
        return result;
    }

    @Override
    public void insertFieldMapping(final Integer mappingId, final List<FieldMapping> fieldMappings) {
        String sqlDelete = "DELETE FROM rdm_sync.field_mapping WHERE mapping_id = ?";
        this.getJdbcTemplate().update("DELETE FROM rdm_sync.field_mapping WHERE mapping_id = ?", new Object[]{mappingId});
        String sqlInsert = "INSERT INTO rdm_sync.field_mapping \n      (mapping_id, sys_field, sys_data_type, rdm_field) \nVALUES(?, ?, ?, ?)";
        this.getJdbcTemplate().batchUpdate("INSERT INTO rdm_sync.field_mapping \n      (mapping_id, sys_field, sys_data_type, rdm_field) \nVALUES(?, ?, ?, ?)", new BatchPreparedStatementSetter(){

            public void setValues(@Nonnull PreparedStatement ps, int i) throws SQLException {
                ps.setInt(1, mappingId);
                ps.setString(2, ((FieldMapping)fieldMappings.get(i)).getSysField());
                ps.setString(3, ((FieldMapping)fieldMappings.get(i)).getSysDataType());
                ps.setString(4, ((FieldMapping)fieldMappings.get(i)).getRdmField());
            }

            public int getBatchSize() {
                return fieldMappings.size();
            }
        });
    }

    @Override
    public boolean lockRefBookForUpdate(String code, boolean blocking) {
        logger.info("lock {} for update", (Object)code);
        Object sql = "SELECT 1 FROM rdm_sync.refbook WHERE code = :code FOR UPDATE";
        if (!blocking) {
            sql = (String)sql + " NOWAIT";
        }
        try {
            this.namedParameterJdbcTemplate.queryForObject((String)sql, Map.of("code", code), Integer.class);
            logger.info("Lock for refbook {} successfully acquired.", (Object)code);
            return true;
        }
        catch (CannotAcquireLockException ex) {
            logger.info("Lock for refbook {} cannot be acquired.", (Object)code, (Object)ex);
            return false;
        }
    }

    @Override
    public void addInternalLocalRowStateUpdateTrigger(String schema, String table) {
        String triggerName = this.escapeName(this.getInternalLocalStateUpdateTriggerName(schema, table));
        String schemaTable = this.escapeName(schema + "." + table);
        String sqlExists = "SELECT EXISTS(SELECT 1 FROM pg_trigger WHERE NOT tgisinternal AND tgname = :tgname)";
        Boolean exists = (Boolean)this.namedParameterJdbcTemplate.queryForObject("SELECT EXISTS(SELECT 1 FROM pg_trigger WHERE NOT tgisinternal AND tgname = :tgname)", Map.of("tgname", triggerName), Boolean.class);
        if (Boolean.TRUE.equals(exists)) {
            return;
        }
        String sqlCreateFormat = "CREATE TRIGGER %s \n  BEFORE INSERT OR UPDATE \n  ON %s \n  FOR EACH ROW \n  EXECUTE PROCEDURE %s;";
        String sqlCreate = String.format("CREATE TRIGGER %s \n  BEFORE INSERT OR UPDATE \n  ON %s \n  FOR EACH ROW \n  EXECUTE PROCEDURE %s;", triggerName, schemaTable, INTERNAL_FUNCTION);
        this.getJdbcTemplate().execute(sqlCreate);
    }

    @Override
    public void createOrReplaceLocalRowStateUpdateFunction() {
        String sql = String.format(LOCAL_ROW_STATE_UPDATE_FUNC, new Object[]{INTERNAL_FUNCTION, "rdm_sync_internal_local_row_state", RdmSyncLocalRowState.DIRTY});
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public void addInternalLocalRowStateColumnIfNotExists(String schema, String table) {
        String schemaTable = this.escapeName(schema + "." + table);
        Boolean exists = (Boolean)this.namedParameterJdbcTemplate.queryForObject("SELECT EXISTS(SELECT 1 FROM information_schema.columns WHERE table_schema = :schema AND table_name = :table AND column_name = :internal_state_column)", Map.of("schema", schema, "table", table, "internal_state_column", "rdm_sync_internal_local_row_state"), Boolean.class);
        if (Boolean.TRUE.equals(exists)) {
            return;
        }
        String query = String.format("ALTER TABLE %s ADD COLUMN %s VARCHAR NOT NULL DEFAULT '%s'", new Object[]{schemaTable, "rdm_sync_internal_local_row_state", RdmSyncLocalRowState.DIRTY});
        this.getJdbcTemplate().execute(query);
        query = String.format("CREATE INDEX ON %s (%s)", schemaTable, StringUtils.addDoubleQuotes((String)"rdm_sync_internal_local_row_state"));
        this.getJdbcTemplate().execute(query);
        int n = this.namedParameterJdbcTemplate.update(String.format("UPDATE %s SET %s = :synced", schemaTable, StringUtils.addDoubleQuotes((String)"rdm_sync_internal_local_row_state")), Map.of("synced", RdmSyncLocalRowState.SYNCED.name()));
        if (n != 0) {
            logger.info("{} records updated internal state to {} in table {}", new Object[]{n, RdmSyncLocalRowState.SYNCED, schemaTable});
        }
    }

    @Override
    public void disableInternalLocalRowStateUpdateTrigger(String table) {
        String[] split = table.split("\\.");
        String triggerName = this.escapeName(this.getInternalLocalStateUpdateTriggerName(split[0], split[1]));
        String query = String.format("ALTER TABLE %s DISABLE TRIGGER %s", this.escapeName(table), triggerName);
        this.getJdbcTemplate().execute(query);
    }

    @Override
    public void enableInternalLocalRowStateUpdateTrigger(String table) {
        String[] split = table.split("\\.");
        String triggerName = this.escapeName(this.getInternalLocalStateUpdateTriggerName(split[0], split[1]));
        String query = String.format("ALTER TABLE %s ENABLE TRIGGER %s", this.escapeName(table), triggerName);
        this.getJdbcTemplate().execute(query);
    }

    @Override
    public boolean existsInternalLocalRowStateUpdateTrigger(String table) {
        String[] split = table.split("\\.");
        String sql = "select exists(select 1 from pg_trigger where tgname = :triggerName)";
        return Objects.equals(Boolean.TRUE, this.namedParameterJdbcTemplate.queryForObject(sql, Map.of("triggerName", this.getInternalLocalStateUpdateTriggerName(split[0], split[1])), Boolean.class));
    }

    @Override
    public Page<Map<String, Object>> getData(LocalDataCriteria localDataCriteria) {
        HashMap<String, Serializable> args = new HashMap<String, Serializable>();
        Object sql = String.format("  FROM %s %n WHERE %s = :state", this.escapeName(localDataCriteria.getSchemaTable()), StringUtils.addDoubleQuotes((String)"rdm_sync_internal_local_row_state"));
        if (localDataCriteria.getRecordId() != null) {
            String sysPkColumn = localDataCriteria.getSysPkColumn();
            sql = (String)sql + "\n AND " + sysPkColumn + " = :" + sysPkColumn;
            args.put(sysPkColumn, localDataCriteria.getRecordId());
        }
        args.put("state", (Serializable)((Object)localDataCriteria.getState().name()));
        if (localDataCriteria.getDeleted() != null) {
            String deletedFieldName = StringUtils.addDoubleQuotes((String)localDataCriteria.getDeleted().getFieldName());
            sql = Boolean.TRUE.equals(localDataCriteria.getDeleted().isDeleted()) ? (String)sql + "\n AND " + deletedFieldName + " is not null" : (String)sql + "\n AND " + deletedFieldName + " is null";
        }
        Page<Map<String, Object>> data = this.getData0((String)sql, args, localDataCriteria);
        data.getContent().forEach(row -> row.remove("rdm_sync_internal_local_row_state"));
        return data;
    }

    @Override
    public Page<Map<String, Object>> getSimpleVersionedData(VersionedLocalDataCriteria criteria) {
        HashMap<String, Serializable> args = new HashMap<String, Serializable>();
        Object sql = String.format("%n  FROM %s %n WHERE 1=1 %n", this.escapeName(criteria.getSchemaTable()));
        if (criteria.getVersion() != null) {
            if (criteria.getRefBookCode() == null) {
                throw new BadRequestException("refBookCode required if version not null");
            }
            sql = (String)sql + " AND version_id=(SELECT id from rdm_sync.loaded_version WHERE code = :code AND version = :version)";
            args.put("code", (Serializable)((Object)criteria.getRefBookCode()));
            args.put("version", (Serializable)((Object)criteria.getVersion()));
        }
        Page<Map<String, Object>> data = this.getData0((String)sql, args, criteria);
        data.getContent().forEach(row -> row.remove(LOADED_VERSION_REF));
        return data;
    }

    @Override
    public Page<Map<String, Object>> getVersionedData(VersionedLocalDataCriteria localDataCriteria) {
        HashMap<String, Serializable> args = new HashMap<String, Serializable>();
        Object sql = String.format("%n  FROM %s %n WHERE 1=1 %n", this.escapeName(localDataCriteria.getSchemaTable()));
        if (localDataCriteria.getVersion() != null) {
            sql = (String)sql + " AND _versions LIKE :_versions";
            args.put(VERSIONS_SYS_COL, (Serializable)((Object)("%{" + localDataCriteria.getVersion() + "}%")));
        }
        Page<Map<String, Object>> data = this.getData0((String)sql, args, localDataCriteria);
        data.getContent().forEach(row -> {
            row.remove(VERSIONS_SYS_COL);
            row.remove(HASH_SYS_COL);
        });
        return data;
    }

    @Override
    public void upsertVersionedRows(String schemaTable, List<Map<String, Object>> rows, String version) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        StringJoiner columns = new StringJoiner(",");
        StringJoiner values = new StringJoiner(",");
        Map[] batchValues = new Map[rows.size()];
        this.concatColumnsAndValues(columns, values, batchValues, this.convertToVersionedRows(rows, version));
        String sql = String.format("INSERT INTO %s (%s) VALUES(%s) ON CONFLICT ON CONSTRAINT  %s DO UPDATE SET _versions = %s._versions||'{%s}'", schemaTable, columns, values, "unique_hash", schemaTable, version);
        this.namedParameterJdbcTemplate.batchUpdate(sql, batchValues);
    }

    @Override
    public void upsertVersionedRows(String schemaTable, List<Map<String, Object>> rows, Integer loadedVersionId, String primaryKey) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        StringJoiner columns = new StringJoiner(",");
        StringJoiner values = new StringJoiner(",");
        Map[] batchValues = new Map[rows.size()];
        this.concatColumnsAndValues(columns, values, batchValues, rows);
        columns.add(this.escapeName(LOADED_VERSION_REF));
        values.add(String.valueOf(loadedVersionId));
        this.namedParameterJdbcTemplate.batchUpdate(String.format("INSERT INTO %s (%s) VALUES (%s) ON CONFLICT (%s, %s) DO UPDATE SET (%s) = (%s);", this.escapeName(schemaTable), columns, values, this.escapeName(primaryKey), this.escapeName(LOADED_VERSION_REF), columns, values), batchValues);
    }

    private void concatColumnsAndValues(StringJoiner columns, StringJoiner values, Map<String, Object>[] batchValues, List<Map<String, Object>> rows) {
        int maxColumns = 0;
        Map<String, Object> longestRow = rows.get(0);
        for (Map<String, Object> row : rows) {
            if (row.keySet().size() <= maxColumns) continue;
            maxColumns = row.keySet().size();
            longestRow = row;
        }
        for (int i = 0; i < rows.size(); ++i) {
            Map<String, Object> row;
            row = rows.get(i);
            HashMap<String, Object> batchValue = new HashMap<String, Object>();
            for (String key : longestRow.keySet()) {
                batchValue.put(key, row.get(key));
            }
            batchValues[i] = batchValue;
        }
        for (String key : longestRow.keySet()) {
            columns.add(this.escapeName(key));
            values.add(":" + key);
        }
    }

    private Page<Map<String, Object>> getData0(String sql, Map<String, Serializable> args, BaseDataCriteria dataCriteria) {
        Integer count;
        SqlFilterBuilder filterBuilder = this.getFiltersClause(dataCriteria.getFilters());
        if (filterBuilder != null) {
            sql = (String)sql + "\n AND " + filterBuilder.build();
            args.putAll(filterBuilder.getParams());
        }
        if ((count = (Integer)this.namedParameterJdbcTemplate.queryForObject("SELECT count(*)" + (String)sql, args, Integer.class)) == null || count == 0) {
            return Page.empty();
        }
        int limit = dataCriteria.getLimit();
        if (limit != 1) {
            sql = (String)sql + String.format("%n ORDER BY %s ", StringUtils.addDoubleQuotes((String)dataCriteria.getPk()));
        }
        sql = (String)sql + String.format("%n LIMIT %d OFFSET %d", limit, dataCriteria.getOffset());
        sql = "SELECT *" + (String)sql;
        if (logger.isDebugEnabled()) {
            logger.debug("getData0 sql:\n{}\n binding args:\n{}\n.", sql, args);
        }
        List result = this.namedParameterJdbcTemplate.query((String)sql, args, (rs, rowNum) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                Object val = rs.getObject(i);
                String key = rs.getMetaData().getColumnName(i);
                if (val instanceof Timestamp) {
                    val = ((Timestamp)val).toLocalDateTime();
                }
                map.put(key, val);
            }
            return map;
        });
        AbstractCriteria restCriteria = new AbstractCriteria();
        restCriteria.setPageNumber(dataCriteria.getOffset() / limit);
        restCriteria.setPageSize(limit);
        restCriteria.setOrders(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)dataCriteria.getPk())}).get().collect(Collectors.toList()));
        return new PageImpl(result, (Pageable)restCriteria, (long)count.intValue());
    }

    private SqlFilterBuilder getFiltersClause(List<FieldFilter> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return null;
        }
        SqlFilterBuilder builder = new SqlFilterBuilder();
        filters.forEach(builder::parse);
        return builder;
    }

    @Override
    public <T> boolean setLocalRecordsState(String schemaTable, String pk, List<? extends T> primaryValues, RdmSyncLocalRowState expectedState, RdmSyncLocalRowState toState) {
        if (primaryValues.isEmpty()) {
            return false;
        }
        String query = String.format("SELECT COUNT(*) FROM %s WHERE %s IN (:primaryValues)", schemaTable, StringUtils.addDoubleQuotes((String)pk));
        Integer count = (Integer)this.namedParameterJdbcTemplate.queryForObject(query, Map.of("primaryValues", primaryValues), Integer.class);
        if (count == null || count == 0) {
            return false;
        }
        query = String.format("UPDATE %1$s SET %2$s = :toState WHERE %3$s IN (:primaryValues) AND %2$s = :expectedState", schemaTable, StringUtils.addDoubleQuotes((String)"rdm_sync_internal_local_row_state"), StringUtils.addDoubleQuotes((String)pk));
        int numUpdatedRecords = this.namedParameterJdbcTemplate.update(query, Map.of("toState", toState.name(), "primaryValues", primaryValues, "expectedState", expectedState.name()));
        return numUpdatedRecords == count;
    }

    @Override
    public RdmSyncLocalRowState getLocalRowState(String schemaTable, String pk, Object pv) {
        String query = String.format("SELECT %s FROM %s WHERE %s = :pv", StringUtils.addDoubleQuotes((String)"rdm_sync_internal_local_row_state"), schemaTable, StringUtils.addDoubleQuotes((String)pk));
        List list = this.namedParameterJdbcTemplate.query(query, Map.of("pv", pv), (rs, rowNum) -> rs.getString(1));
        if (list.size() > 1) {
            throw new RdmException("Cannot identify record by " + pk);
        }
        return list.stream().findAny().map(RdmSyncLocalRowState::valueOf).orElse(null);
    }

    @Override
    public void createSchemaIfNotExists(String schema) {
        this.getJdbcTemplate().execute(String.format("CREATE SCHEMA IF NOT EXISTS %s", schema));
    }

    @Override
    public void createTableIfNotExists(String schema, String table, List<FieldMapping> fieldMappings, String isDeletedFieldName, String sysPkColumn) {
        this.createTable(schema, table, fieldMappings, Map.of(isDeletedFieldName, "timestamp without time zone", sysPkColumn, RECORD_SYS_COL_INFO));
    }

    @Override
    public void createTableWithNaturalPrimaryKeyIfNotExists(String schema, String table, List<FieldMapping> fieldMappings, String isDeletedFieldName, String sysPkColumn) {
        this.createTable(schema, table, fieldMappings, Map.of(isDeletedFieldName, "timestamp without time zone"));
        Boolean pkIsExists = (Boolean)this.getJdbcTemplate().queryForObject("SELECT EXISTS (SELECT * FROM pg_constraint                    WHERE conrelid = ?::regclass and contype = 'p')", Boolean.class, new Object[]{schema + "." + table});
        if (!pkIsExists.booleanValue()) {
            String sql = "ALTER TABLE " + this.escapeName(schema) + "." + this.escapeName(table) + " ADD CONSTRAINT " + this.escapeName(table + "_pk") + " PRIMARY KEY (" + this.escapeName(sysPkColumn) + ");";
            this.getJdbcTemplate().execute(sql);
        }
    }

    @Override
    public void createVersionedTableIfNotExists(String schema, String table, List<FieldMapping> fieldMappings, String sysPkColumn) {
        this.createTable(schema, table, fieldMappings, Map.of(VERSIONS_SYS_COL, "text NOT NULL", HASH_SYS_COL, "text NOT NULL", sysPkColumn, RECORD_SYS_COL_INFO));
        this.getJdbcTemplate().execute(String.format("ALTER TABLE %s.%s ADD CONSTRAINT unique_hash UNIQUE (\"_hash\")", this.escapeName(schema), this.escapeName(table)));
    }

    @Override
    public void createSimpleVersionedTables(String schema, String table, List<FieldMapping> fieldMappings, String primaryField) {
        Boolean tableExists = (Boolean)this.getJdbcTemplate().queryForObject("SELECT EXISTS (SELECT FROM pg_tables  WHERE  schemaname = ? AND tablename  = ?)", Boolean.class, new Object[]{schema, table});
        if (Boolean.FALSE.equals(tableExists)) {
            this.createTable(schema, table, fieldMappings, Map.of(LOADED_VERSION_REF, "integer NOT NULL", RECORD_SYS_COL, RECORD_SYS_COL_INFO));
            String escapedSchemaTable = this.escapeName(schema) + "." + this.escapeName(table);
            this.getJdbcTemplate().execute(String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES rdm_sync.loaded_version(id)", escapedSchemaTable, this.escapeName(table + "_version_id_fk"), LOADED_VERSION_REF));
            this.getJdbcTemplate().execute(String.format("ALTER TABLE %s ADD CONSTRAINT %s UNIQUE (%s, %s);", escapedSchemaTable, this.escapeName(table + "_uq"), this.escapeName(primaryField), LOADED_VERSION_REF));
        }
    }

    @Override
    public SyncRefBook getSyncRefBook(String code) {
        List result = this.namedParameterJdbcTemplate.query("select * from rdm_sync.refbook where code = :code", Map.of("code", code), (rs, rowNum) -> new SyncRefBook(Integer.valueOf(rs.getInt("id")), rs.getString("code"), SyncTypeEnum.valueOf((String)rs.getString("sync_type")), rs.getString("name"), rs.getString("range")));
        if (result.isEmpty()) {
            return null;
        }
        return (SyncRefBook)result.get(0);
    }

    private void createTable(String schema, String table, List<FieldMapping> fieldMappings, Map<String, String> additionalColumns) {
        StringBuilder ddl = new StringBuilder(String.format("CREATE TABLE IF NOT EXISTS %s.%s (", this.escapeName(schema), this.escapeName(table)));
        ddl.append(fieldMappings.stream().map(mapping -> String.format("%s %s", this.escapeName(mapping.getSysField()), mapping.getSysDataType())).collect(Collectors.joining(", ")));
        for (Map.Entry<String, String> entry : additionalColumns.entrySet()) {
            ddl.append(String.format(", %s %s", this.escapeName(entry.getKey()), entry.getValue()));
        }
        ddl.append(")");
        this.getJdbcTemplate().execute(ddl.toString());
    }

    private JdbcTemplate getJdbcTemplate() {
        return this.namedParameterJdbcTemplate.getJdbcTemplate();
    }

    private LocalDateTime toLocalDateTime(ResultSet rs, int columnIndex, LocalDateTime defaultValue) throws SQLException {
        Timestamp value = rs.getTimestamp(columnIndex);
        return value != null ? value.toLocalDateTime() : defaultValue;
    }

    private String getInternalLocalStateUpdateTriggerName(String schema, String table) {
        return schema + "_" + table + "_intrnl_lcl_rw_stt_updt";
    }

    private String escapeName(String name) {
        if (name.contains(";")) {
            throw new IllegalArgumentException(name + "illegal value");
        }
        if (name.contains(".")) {
            String firstPart = this.escapeName(name.split("\\.")[0]);
            String secondPart = this.escapeName(name.split("\\.")[1]);
            return firstPart + "." + secondPart;
        }
        return "\"" + name + "\"";
    }

    private LocalDateTime toLocalDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.toLocalDateTime();
    }
}

