/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.dao.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.sync.dao.builder.ClauseBuilder;

public class SqlClauseBuilder
implements ClauseBuilder {
    private final List<String> clauses = new ArrayList<String>();
    private final Map<String, Serializable> params = new HashMap<String, Serializable>();

    public SqlClauseBuilder() {
    }

    public SqlClauseBuilder(List<String> clauses, Map<String, Serializable> params) {
        if (!CollectionUtils.isEmpty(clauses)) {
            this.clauses.addAll(clauses);
        }
        if (!CollectionUtils.isEmpty(params)) {
            this.params.putAll(params);
        }
    }

    @Override
    public List<String> getClauses() {
        return this.clauses;
    }

    @Override
    public Map<String, Serializable> getParams() {
        return this.params;
    }

    @Override
    public String build() {
        return this.collect(Collectors.joining());
    }

    protected <A> String collect(Collector<CharSequence, A, String> collector) {
        return this.clauses.stream().collect(collector);
    }

    @Override
    public SqlClauseBuilder append(String clause) {
        if (!StringUtils.isEmpty((Object)clause)) {
            this.clauses.add(clause);
        }
        return this;
    }

    @Override
    public SqlClauseBuilder append(List<String> clauses) {
        if (!CollectionUtils.isEmpty(clauses)) {
            this.clauses.addAll(clauses);
        }
        return this;
    }

    @Override
    public SqlClauseBuilder bind(String name, Serializable value) {
        if (!StringUtils.isEmpty((Object)name) && value != null) {
            this.params.put(name, value);
        }
        return this;
    }

    @Override
    public SqlClauseBuilder bind(Map.Entry<String, Serializable> param) {
        return param != null ? this.bind(param.getKey(), param.getValue()) : this;
    }

    @Override
    public SqlClauseBuilder bind(Map<String, Serializable> params) {
        if (!CollectionUtils.isEmpty(params)) {
            this.params.putAll(params);
        }
        return this;
    }

    @Override
    public void concat(String clause, Map<String, Serializable> params) {
        this.append(clause);
        this.bind((Map)params);
    }

    @Override
    public void concat(ClauseBuilder builder) {
        if (builder == null) {
            return;
        }
        String clause = builder.build();
        this.concat(clause, builder.getParams());
    }
}

