/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.dao.builder;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.sync.dao.builder.ClauseBuilder;
import ru.i_novus.ms.rdm.sync.dao.builder.SqlClauseBuilder;
import ru.i_novus.ms.rdm.sync.dao.builder.SqlValueFilterBuilder;
import ru.i_novus.ms.rdm.sync.model.filter.FieldFilter;
import ru.i_novus.ms.rdm.sync.model.filter.FieldValueFilter;

public class SqlFilterBuilder
extends SqlClauseBuilder {
    public SqlFilterBuilder() {
    }

    public SqlFilterBuilder(List<String> clauses, Map<String, Serializable> params) {
        super(clauses, params);
    }

    @Override
    public String build() {
        return this.collect(Collectors.joining("\n AND "));
    }

    public void parse(FieldFilter filter) {
        String field = filter.getField();
        List<FieldValueFilter> valueFilters = filter.getFilters();
        if (CollectionUtils.isEmpty(valueFilters)) {
            return;
        }
        SqlValueFilterBuilder builder = new SqlValueFilterBuilder();
        IntStream.range(0, valueFilters.size()).forEach(index -> {
            String bindName = field + "_" + index;
            builder.parse(field, filter.getType(), bindName, (FieldValueFilter)valueFilters.get(index));
        });
        this.concat(builder);
    }

    @Override
    public void concat(ClauseBuilder builder) {
        if (builder == null) {
            return;
        }
        Object clause = builder.build();
        if (!StringUtils.isEmpty((Object)clause)) {
            clause = ((String)clause).contains("\n") ? "(\n" + (String)clause + "\n)" : clause;
        }
        this.concat((String)clause, builder.getParams());
    }
}

