/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.quartz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.dao.criteria.LocalDataCriteria;
import ru.i_novus.ms.rdm.sync.service.RdmSyncLocalRowState;
import ru.i_novus.ms.rdm.sync.service.change_data.RdmChangeDataClient;
import ru.i_novus.ms.rdm.sync.util.RdmSyncDataUtils;

@Component
@DisallowConcurrentExecution
public final class RdmSyncExportDirtyRecordsToRdmJob
implements Job {
    public static final String NAME = "ExportDirtyRecordsToRdm";
    @Autowired
    private RdmSyncDao dao;
    @Autowired(required=false)
    private RdmChangeDataClient rdmChangeDataClient;
    @Value(value="${rdm-sync.export.to_rdm.batch_size:100}")
    private int exportToRdmBatchSize;

    public void execute(JobExecutionContext context) {
        if (this.rdmChangeDataClient == null) {
            return;
        }
        int limit = this.exportToRdmBatchSize;
        List<VersionMapping> versionMappings = this.dao.getVersionMappings();
        block0: for (VersionMapping vm : versionMappings) {
            int offset = 0;
            String table = vm.getTable();
            List<FieldMapping> fieldMappings = this.dao.getFieldMappings(vm.getCode());
            String deletedKey = vm.getDeletedField();
            while (true) {
                LocalDataCriteria criteria = new LocalDataCriteria(table, vm.getPrimaryField(), limit, offset, null);
                criteria.setState(RdmSyncLocalRowState.DIRTY);
                Page<Map<String, Object>> dirtyBatch = this.dao.getData(criteria);
                if (dirtyBatch.getContent().isEmpty()) continue block0;
                ArrayList<HashMap<String, Object>> addUpdate = new ArrayList<HashMap<String, Object>>();
                ArrayList<HashMap> delete = new ArrayList<HashMap>();
                for (Map map : dirtyBatch.getContent()) {
                    Boolean isDeleted = (Boolean)map.get(deletedKey);
                    if (Boolean.TRUE.equals(isDeleted)) {
                        delete.add((HashMap)map);
                        continue;
                    }
                    addUpdate.add((HashMap)map);
                }
                addUpdate.add(RdmSyncDataUtils.INTERNAL_TAG);
                this.rdmChangeDataClient.changeData(vm.getCode(), addUpdate, delete, record -> {
                    HashMap<String, Object> map = new HashMap<String, Object>((Map<String, Object>)record);
                    RdmSyncDataUtils.reindex(fieldMappings, map);
                    return map;
                });
                offset += limit;
            }
        }
    }
}

