/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.sync.api.log.Log;
import ru.i_novus.ms.rdm.sync.api.log.LogCriteria;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.SyncRefBook;
import ru.i_novus.ms.rdm.sync.api.service.RdmSyncService;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.model.loader.XmlMapping;
import ru.i_novus.ms.rdm.sync.model.loader.XmlMappingField;
import ru.i_novus.ms.rdm.sync.model.loader.XmlMappingRefBook;
import ru.i_novus.ms.rdm.sync.service.RdmLoggingService;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookUpdater;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookUpdaterException;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookUpdaterLocator;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookVersionsDeterminator;

public class RdmSyncServiceImpl
implements RdmSyncService {
    private static final Logger logger = LoggerFactory.getLogger(RdmSyncServiceImpl.class);
    @Value(value="${rdm-sync.load.size: 1000}")
    private int MAX_SIZE = 1000;
    @Value(value="${rdm-sync.threads.count:3}")
    private int threadsCount = 3;
    private static final String LOG_NO_MAPPING_FOR_REFBOOK = "No mapping found for reference book with code '{}'.";
    @Autowired
    private RdmLoggingService loggingService;
    @Autowired
    private RdmSyncDao dao;
    @Autowired
    private SyncSourceService syncSourceService;
    private ExecutorService executorService;
    @Autowired
    private RefBookUpdaterLocator refBookUpdaterLocator;

    @PostConstruct
    public void init() {
        this.executorService = Executors.newFixedThreadPool(this.threadsCount);
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdownNow();
        logger.info("executor was shutdowned");
    }

    public void update() {
        List<VersionMapping> versionMappings = this.dao.getVersionMappings();
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (VersionMapping mapping : versionMappings) {
            tasks.add(() -> {
                this.update(mapping.getCode());
                return null;
            });
        }
        try {
            this.executorService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info("Interrupted, sync stopping");
            this.executorService.shutdownNow();
        }
    }

    public void update(String refBookCode) {
        List<String> versions;
        SyncRefBook syncRefBook = this.dao.getSyncRefBook(refBookCode);
        if (syncRefBook == null) {
            logger.error(LOG_NO_MAPPING_FOR_REFBOOK, (Object)refBookCode);
            return;
        }
        RefBookUpdater refBookUpdater = this.refBookUpdaterLocator.getRefBookUpdater(syncRefBook.getType());
        RefBookVersionsDeterminator determinator = new RefBookVersionsDeterminator(syncRefBook, this.dao, this.syncSourceService);
        try {
            versions = determinator.getVersions();
        }
        catch (Exception e) {
            logger.error("cannot get versions for refbook " + refBookCode, (Throwable)e);
            versions = Collections.emptyList();
        }
        for (String version : versions) {
            try {
                refBookUpdater.update(refBookCode, version);
            }
            catch (RefBookUpdaterException e) {
                Throwable cause = e.getCause();
                logger.error(String.format("Error while updating new version with code '%s'.", refBookCode), cause);
                this.loggingService.logError(refBookCode, e.getVersionMapping().getRefBookVersion(), e.getNewVersion().getVersion(), cause.getMessage(), ExceptionUtils.getStackTrace((Throwable)cause));
                return;
            }
        }
    }

    public List<Log> getLog(LogCriteria criteria) {
        return this.loggingService.getList(criteria.getDate(), criteria.getRefbookCode());
    }

    @Transactional(readOnly=true)
    public Response downloadXmlFieldMapping(List<String> refBookCodes) {
        List<Object> versionMappings = this.dao.getVersionMappings();
        if (refBookCodes.stream().noneMatch("all"::equalsIgnoreCase)) {
            versionMappings = versionMappings.stream().filter(mapping -> refBookCodes.contains(mapping.getCode())).collect(Collectors.toList());
        }
        XmlMapping xmlMapping = new XmlMapping();
        xmlMapping.setRefbooks(new ArrayList<XmlMappingRefBook>());
        for (VersionMapping versionMapping : versionMappings) {
            XmlMappingRefBook xmlMappingRefBook = XmlMappingRefBook.createBy(versionMapping);
            List<XmlMappingField> fields = this.dao.getFieldMappings(versionMapping.getId()).stream().map(XmlMappingField::createBy).collect(Collectors.toList());
            xmlMappingRefBook.setFields(fields);
            xmlMapping.getRefbooks().add(xmlMappingRefBook);
        }
        StreamingOutput stream = out -> {
            try {
                Marshaller marshaller = XmlMapping.JAXB_CONTEXT.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)xmlMapping, out);
                out.flush();
            }
            catch (JAXBException e) {
                throw new RdmException((Throwable)e);
            }
        };
        return Response.ok((Object)stream, (String)"application/octet-stream").header("Content-Disposition", (Object)"filename=\"rdm-mapping.xml\"").entity((Object)stream).build();
    }
}

