/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSource;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSourceDao;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.DataCriteria;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersionItem;
import ru.i_novus.ms.rdm.sync.api.model.VersionsDiff;
import ru.i_novus.ms.rdm.sync.api.model.VersionsDiffCriteria;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceServiceFactory;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;

@Component
public class RedirectingSyncSourceService
implements SyncSourceService {
    private final SyncSourceDao syncSourceDao;
    private final RdmSyncDao syncDao;
    private final Set<SyncSourceServiceFactory> syncSourceServiceFactorySet;

    @Autowired
    public RedirectingSyncSourceService(SyncSourceDao syncSourceDao, RdmSyncDao syncDao, Set<SyncSourceServiceFactory> syncSourceServiceFactorySet) {
        this.syncSourceDao = syncSourceDao;
        this.syncDao = syncDao;
        this.syncSourceServiceFactorySet = syncSourceServiceFactorySet;
    }

    public RefBookVersion getRefBook(String code, String version) {
        return this.getSyncSourceService(code).getRefBook(code, version);
    }

    public List<RefBookVersionItem> getVersions(String code) {
        return this.getSyncSourceService(code).getVersions(code);
    }

    public Page<Map<String, Object>> getData(DataCriteria dataCriteria) {
        return this.getSyncSourceService(dataCriteria.getCode()).getData(dataCriteria);
    }

    public VersionsDiff getDiff(VersionsDiffCriteria criteria) {
        return this.getSyncSourceService(criteria.getRefBookCode()).getDiff(criteria);
    }

    private SyncSourceService getSyncSourceService(String refBookCode) {
        SyncSource source = this.getSource(refBookCode);
        return ((SyncSourceServiceFactory)this.syncSourceServiceFactorySet.stream().filter(factory -> factory.isSatisfied(source)).findAny().orElse(null)).createService(source);
    }

    private SyncSource getSource(String refBookCode) {
        VersionMapping versionMapping = this.syncDao.getVersionMapping(refBookCode, "CURRENT");
        return this.syncSourceDao.findByCode(versionMapping.getSource());
    }
}

