/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.change_data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.transaction.annotation.Transactional;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.api.model.refdata.RdmChangeDataRequest;
import ru.i_novus.ms.rdm.api.model.refdata.Row;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.RdmSyncLocalRowState;
import ru.i_novus.ms.rdm.sync.service.change_data.RdmChangeDataRequestCallback;
import ru.i_novus.ms.rdm.sync.util.RdmSyncDataUtils;

public abstract class RdmChangeDataClient {
    private static final Logger logger = LoggerFactory.getLogger(RdmChangeDataClient.class);
    @Autowired
    protected RdmSyncDao dao;
    @Autowired
    protected RdmChangeDataRequestCallback callback;

    @Transactional
    public <T extends Serializable> void changeData(String refBookCode, List<? extends T> addUpdate, List<? extends T> delete) {
        List<FieldMapping> fieldMappings = this.dao.getFieldMappings(refBookCode);
        this.changeData(refBookCode, addUpdate, delete, t -> {
            Map<String, Object> map = RdmSyncDataUtils.tToMap(t, true, null);
            if (!fieldMappings.isEmpty()) {
                RdmSyncDataUtils.reindex(fieldMappings, map);
            }
            return map;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public <T extends Serializable> void changeData(String refBookCode, List<? extends T> addUpdate, List<? extends T> delete, Function<? super T, Map<String, Object>> map) {
        VersionMapping mapping = this.dao.getVersionMapping(refBookCode, "CURRENT");
        if (mapping == null || addUpdate.isEmpty() && delete.isEmpty()) {
            return;
        }
        boolean ensureState = false;
        boolean haveTrigger = this.dao.existsInternalLocalRowStateUpdateTrigger(mapping.getTable());
        ListIterator<T> it = addUpdate.listIterator(addUpdate.size());
        if (it.hasPrevious() && it.previous() == RdmSyncDataUtils.INTERNAL_TAG) {
            ensureState = true;
            it.remove();
        }
        if (ensureState) {
            ArrayList<Object> list = new ArrayList<Object>(RdmSyncDataUtils.extractSnakeCaseKey(mapping.getPrimaryField(), addUpdate));
            list.addAll(RdmSyncDataUtils.extractSnakeCaseKey(mapping.getPrimaryField(), delete));
            if (haveTrigger) {
                this.dao.disableInternalLocalRowStateUpdateTrigger(mapping.getTable());
            }
            try {
                boolean stateChanged = this.dao.setLocalRecordsState(mapping.getTable(), mapping.getPrimaryField(), list, RdmSyncLocalRowState.DIRTY, RdmSyncLocalRowState.PENDING);
                if (!stateChanged) {
                    logger.info("State change did not pass. Skipping request on {}.", (Object)refBookCode);
                    throw new RdmException();
                }
            }
            finally {
                if (haveTrigger) {
                    this.dao.enableInternalLocalRowStateUpdateTrigger(mapping.getTable());
                }
            }
        }
        this.changeData0(refBookCode, addUpdate, delete, map);
    }

    abstract <T extends Serializable> void changeData0(String var1, List<? extends T> var2, List<? extends T> var3, Function<? super T, Map<String, Object>> var4);

    @Transactional
    public <T extends Serializable> void lazyUpdateData(List<? extends T> addUpdate, String localTable) {
        VersionMapping versionMapping = this.getVersionMappingByTableOrElseThrow(localTable);
        List<Pair<String, String>> columnTypes = this.dao.getLocalColumnTypes(versionMapping.getTable());
        this.lazyUpdateData(addUpdate, localTable, t -> RdmSyncDataUtils.mapForPgInsert(t, columnTypes));
    }

    @Transactional
    public <T extends Serializable> void lazyUpdateData(List<? extends T> addUpdate, String localTable, Function<? super T, Map<String, Object>> toMap) {
        VersionMapping versionMapping = this.getVersionMappingByTableOrElseThrow(localTable);
        String primaryField = versionMapping.getPrimaryField();
        String isDeletedField = versionMapping.getDeletedField();
        IdentityHashMap<Serializable, Map<String, Object>> identityHashMap = new IdentityHashMap<Serializable, Map<String, Object>>();
        for (Serializable t2 : addUpdate) {
            Map<String, Object> map = toMap.apply(t2);
            Object primaryValue = map.get(primaryField);
            if (primaryValue == null) {
                throw new RdmException("No primary key found. Primary field: " + primaryField);
            }
            if (!this.dao.isIdExists(localTable, primaryField, primaryValue)) {
                this.dao.insertRow(localTable, map, false);
            } else {
                this.dao.markDeleted(localTable, primaryField, isDeletedField, primaryValue, null, false);
                this.dao.updateRow(localTable, primaryField, map, false);
            }
            identityHashMap.put(t2, map);
        }
        List<FieldMapping> fieldMappings = this.dao.getFieldMappings(versionMapping.getCode());
        this.changeData(versionMapping.getCode(), addUpdate, Collections.emptyList(), t -> {
            Map map = (Map)identityHashMap.get(t);
            RdmSyncDataUtils.reindex(fieldMappings, map);
            return map;
        });
    }

    private VersionMapping getVersionMappingByTableOrElseThrow(String table) {
        return this.dao.getVersionMappings().stream().filter(vm -> vm.getTable().equals(table)).findAny().orElseThrow(() -> new RdmException("No table " + table + " found."));
    }

    static <T extends Serializable> RdmChangeDataRequest toRdmChangeDataRequest(String refBookCode, List<? extends T> addUpdate, List<? extends T> delete, Function<? super T, Map<String, Object>> toMap) {
        ArrayList<Row> addUpdateRows = new ArrayList<Row>();
        ArrayList<Row> toDeleteRows = new ArrayList<Row>();
        for (Serializable t : addUpdate) {
            addUpdateRows.add(new Row(toMap.apply(t)));
        }
        for (Serializable t : delete) {
            toDeleteRows.add(new Row(toMap.apply(t)));
        }
        return new RdmChangeDataRequest(refBookCode, addUpdateRows, toDeleteRows);
    }
}

