/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.init;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSourceDao;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.init.BaseLocalRefBookCreator;

@Component
public class NotVersionedLocalRefBookCreator
extends BaseLocalRefBookCreator {
    private static final Logger logger = LoggerFactory.getLogger(NotVersionedLocalRefBookCreator.class);

    public NotVersionedLocalRefBookCreator(@Value(value="${rdm-sync.auto-create.schema:rdm}") String schema, @Value(value="${rdm-sync.auto-create.ignore-case:true}") Boolean caseIgnore, RdmSyncDao dao, SyncSourceDao syncSourceDao) {
        super(schema, caseIgnore, dao, syncSourceDao);
    }

    @Override
    protected void createTable(String refBookCode, VersionMapping mapping) {
        String[] split = this.getTableNameWithSchema(refBookCode, mapping.getTable()).split("\\.");
        String schemaName = split[0];
        String tableName = split[1];
        this.dao.createSchemaIfNotExists(schemaName);
        this.dao.createTableIfNotExists(schemaName, tableName, this.dao.getFieldMappings(mapping.getId()), mapping.getDeletedField(), mapping.getSysPkColumn());
        logger.info("Preparing table {} in schema {}.", (Object)tableName, (Object)schemaName);
        this.dao.addInternalLocalRowStateColumnIfNotExists(schemaName, tableName);
        this.dao.createOrReplaceLocalRowStateUpdateFunction();
        this.dao.addInternalLocalRowStateUpdateTrigger(schemaName, tableName);
        logger.info("Table {} in schema {} successfully prepared.", (Object)tableName, (Object)schemaName);
    }
}

