/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.init;

import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.sync.quartz.RdmSyncExportDirtyRecordsToRdmJob;
import ru.i_novus.ms.rdm.sync.quartz.RdmSyncImportRecordsFromRdmJob;
import ru.i_novus.ms.rdm.sync.quartz.RdmSyncInitJob;
import ru.i_novus.ms.rdm.sync.service.RdmSyncLocalRowState;
import ru.i_novus.ms.rdm.sync.service.init.ClusterLockService;
import ru.i_novus.ms.rdm.sync.service.init.RdmSyncInitializer;

@Component
@ConditionalOnClass(name={"org.quartz.Scheduler"})
@ConditionalOnProperty(name={"rdm-sync.scheduling"}, havingValue="true")
class RdmSyncJobConfigurer {
    private final Logger logger = LoggerFactory.getLogger(RdmSyncJobConfigurer.class);
    private static final String LOG_SCHEDULER_NON_CLUSTERED = "Scheduler is configured in non clustered mode. There is may be concurrency issues.";
    private static final String LOG_TRIGGER_NOT_CHANGED = "Trigger's {} expression is not changed.";
    private static final String LOG_TRIGGER_IS_NOT_CRON = "Trigger {} is not CronTrigger instance. Leave it as it is.";
    private static final String LOG_JOB_CANNOT_SCHEDULE = "Cannot schedule %s job.";
    private static final String JOB_GROUP = "RDM_SYNC_INTERNAL";
    private static final String LOG_ALL_RECORDS_WILL_REMAIN = "All records in the %s state will remain the same.";
    @Autowired(required=false)
    protected Scheduler scheduler;
    @Autowired
    private ClusterLockService clusterLockService;
    @Autowired
    private RdmSyncInitializer rdmSyncInitializer;
    @Value(value="${rdm-sync.init.delay:#{null}}")
    private Integer rdmSyncInitDelay;
    @Value(value="${rdm-sync.import.from_rdm.cron:}")
    private String importFromRdmCron;
    @Value(value="${rdm-sync.import.from_rdm.delay:0}")
    private Integer importFromRdmDelay;
    @Value(value="${rdm-sync.export.to_rdm.cron:0/5 * * * * ?}")
    private String exportToRdmCron;
    @Value(value="${rdm-sync.export.to_rdm.delay:0}")
    private Integer exportToRdmDelay;
    @Value(value="${rdm-sync.change_data.mode:#{null}}")
    private String changeDataMode;

    RdmSyncJobConfigurer() {
    }

    @Transactional
    public void setupJobs() {
        if (this.scheduler == null) {
            return;
        }
        this.setupRdmSyncInitJob();
    }

    @Transactional
    public void setupImportJob() {
        String jobName = "ImportRecordsFromRdm";
        try {
            if (!this.scheduler.getMetaData().isJobStoreClustered()) {
                this.logger.warn(LOG_SCHEDULER_NON_CLUSTERED);
            }
            JobKey jobKey = JobKey.jobKey((String)"ImportRecordsFromRdm", (String)JOB_GROUP);
            if (StringUtils.isEmpty((Object)this.importFromRdmCron)) {
                this.deleteJob(jobKey);
                return;
            }
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup());
            Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
            JobDetail newJob = JobBuilder.newJob(RdmSyncImportRecordsFromRdmJob.class).withIdentity(jobKey).build();
            Trigger newTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).forJob(newJob).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.importFromRdmCron)).startAt(this.nowDelayed(this.importFromRdmDelay)).build();
            this.addJob(triggerKey, oldTrigger, newJob, newTrigger, this.importFromRdmCron);
        }
        catch (SchedulerException e) {
            String message = String.format(LOG_JOB_CANNOT_SCHEDULE, "ImportRecordsFromRdm");
            this.logger.error(message, (Throwable)e);
        }
    }

    @Transactional
    public void setupExportJob() {
        if (!this.clusterLockService.tryLock()) {
            return;
        }
        String jobName = "ExportDirtyRecordsToRdm";
        try {
            if (!this.scheduler.getMetaData().isJobStoreClustered()) {
                this.logger.warn(LOG_SCHEDULER_NON_CLUSTERED);
            }
            JobKey jobKey = JobKey.jobKey((String)"ExportDirtyRecordsToRdm", (String)JOB_GROUP);
            if (StringUtils.isEmpty((Object)this.exportToRdmCron) || StringUtils.isEmpty((Object)this.changeDataMode)) {
                this.deleteJob(jobKey);
                return;
            }
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup());
            Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
            JobDetail newJob = JobBuilder.newJob(RdmSyncExportDirtyRecordsToRdmJob.class).withIdentity(jobKey).build();
            Trigger newTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).forJob(newJob).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.exportToRdmCron)).startAt(this.nowDelayed(this.exportToRdmDelay)).build();
            this.addJob(triggerKey, oldTrigger, newJob, newTrigger, this.exportToRdmCron);
        }
        catch (SchedulerException e) {
            String message = String.format(LOG_JOB_CANNOT_SCHEDULE, "ExportDirtyRecordsToRdm") + "\n" + String.format(LOG_ALL_RECORDS_WILL_REMAIN, new Object[]{RdmSyncLocalRowState.DIRTY});
            this.logger.error(message, (Throwable)e);
        }
    }

    private void setupRdmSyncInitJob() {
        String jobName = "RdmSyncInitialize";
        try {
            if (!this.scheduler.getMetaData().isJobStoreClustered()) {
                this.logger.warn(LOG_SCHEDULER_NON_CLUSTERED);
            }
            JobKey jobKey = JobKey.jobKey((String)"RdmSyncInitialize", (String)JOB_GROUP);
            if (this.rdmSyncInitDelay == null) {
                this.rdmSyncInitializer.init();
            }
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup());
            Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
            JobDetail newJob = JobBuilder.newJob(RdmSyncInitJob.class).withIdentity(jobKey).build();
            Trigger newTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).forJob(newJob).startAt(this.nowDelayed(this.rdmSyncInitDelay)).build();
            this.addJob(triggerKey, oldTrigger, newJob, newTrigger, String.valueOf(this.rdmSyncInitDelay));
        }
        catch (SchedulerException e) {
            String message = String.format(LOG_JOB_CANNOT_SCHEDULE, "RdmSyncInitialize");
            this.logger.error(message, (Throwable)e);
        }
    }

    private Date nowDelayed(Integer delayMillis) {
        return new Date(System.currentTimeMillis() + (delayMillis != null ? delayMillis.longValue() : 0L));
    }

    private void addJob(TriggerKey triggerKey, Trigger oldTrigger, JobDetail newJob, Trigger newTrigger, String cronExpression) throws SchedulerException {
        if (oldTrigger == null) {
            this.scheduler.scheduleJob(newJob, newTrigger);
            return;
        }
        if (oldTrigger instanceof CronTrigger) {
            CronTrigger trigger = (CronTrigger)oldTrigger;
            if (!trigger.getCronExpression().equals(cronExpression)) {
                this.scheduler.rescheduleJob(triggerKey, newTrigger);
            } else {
                this.logger.info(LOG_TRIGGER_NOT_CHANGED, (Object)triggerKey);
            }
        } else {
            this.logger.warn(LOG_TRIGGER_IS_NOT_CRON, (Object)triggerKey);
        }
    }

    private void deleteJob(JobKey jobKey) throws SchedulerException {
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
        }
    }
}

