/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.init;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSourceDao;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionAndFieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.init.BaseLocalRefBookCreator;

@Component
public class VersionedLocalRefBookCreator
extends BaseLocalRefBookCreator {
    private static final Logger logger = LoggerFactory.getLogger(VersionedLocalRefBookCreator.class);
    private final RdmSyncDao rdmSyncDao;

    public VersionedLocalRefBookCreator(@Value(value="${rdm-sync.auto-create.schema:rdm}") String schema, @Value(value="${rdm-sync.auto-create.ignore-case:true}") Boolean caseIgnore, RdmSyncDao rdmSyncDao, SyncSourceDao syncSourceDao) {
        super(schema, caseIgnore, rdmSyncDao, syncSourceDao);
        this.rdmSyncDao = rdmSyncDao;
    }

    @Override
    public void create(VersionAndFieldMapping versionAndFieldMapping) {
        String refBookCode = versionAndFieldMapping.getVersionMapping().getCode();
        String refBookName = versionAndFieldMapping.getVersionMapping().getRefBookName();
        String source = versionAndFieldMapping.getVersionMapping().getSource();
        SyncTypeEnum type = versionAndFieldMapping.getVersionMapping().getType();
        String table = versionAndFieldMapping.getVersionMapping().getTable();
        String sysPkColumn = versionAndFieldMapping.getVersionMapping().getSysPkColumn();
        String range = versionAndFieldMapping.getVersionMapping().getRange();
        String pk = ((FieldMapping)versionAndFieldMapping.getFieldMapping().get(0)).getSysField();
        if (this.rdmSyncDao.existsLoadedVersion(refBookCode)) {
            logger.info("auto create for code {} was skipped", (Object)refBookCode);
            return;
        }
        logger.info("starting auto create for code {}", (Object)refBookCode);
        VersionMapping versionMapping = this.rdmSyncDao.getVersionMapping(refBookCode, "CURRENT");
        if (versionMapping == null) {
            String schemaTable = this.getTableNameWithSchema(refBookCode, table);
            versionMapping = new VersionMapping(null, refBookCode, refBookName, "CURRENT", schemaTable, sysPkColumn, source, pk, null, null, -1, null, type, range);
            this.rdmSyncDao.insertVersionMapping(versionMapping);
        }
        this.createTable(refBookCode, versionMapping);
        logger.info("auto create for code {} was finished", (Object)refBookCode);
    }

    @Override
    protected void createTable(String code, VersionMapping versionMapping) {
        String[] split = this.getTableNameWithSchema(code, versionMapping.getTable()).split("\\.");
        String schemaName = split[0];
        String tableName = split[1];
        this.rdmSyncDao.createSchemaIfNotExists(schemaName);
        this.rdmSyncDao.createVersionedTableIfNotExists(schemaName, tableName, this.rdmSyncDao.getFieldMappings(versionMapping.getId()), versionMapping.getSysPkColumn());
    }
}

