/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSource;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSourceDao;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionAndFieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.api.model.RefBookStructure;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceServiceFactory;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.model.loader.AutoCreateRefBookProperty;
import ru.i_novus.ms.rdm.sync.model.loader.AutoCreateRefBookPropertyValue;
import ru.i_novus.ms.rdm.sync.service.init.RdmSyncInitUtils;
import ru.i_novus.ms.rdm.sync.service.mapping.MappingSourceService;

@Component
public class PropMappingSourceService
implements MappingSourceService {
    private static final int DEFAULT_VERSION_FOR_PROPERTY_MAPPING = -2;
    private final SyncSourceDao syncSourceDao;
    protected final RdmSyncDao dao;
    private final Set<SyncSourceServiceFactory> syncSourceServiceFactories;
    private final boolean caseIgnore;
    private final String defaultSchema;
    private AutoCreateRefBookProperty autoCreateRefBookProperties;

    @Autowired
    public PropMappingSourceService(SyncSourceDao syncSourceDao, RdmSyncDao dao, Set<SyncSourceServiceFactory> syncSourceServiceFactories, @Value(value="${rdm-sync.auto-create.ignore-case:true}") Boolean caseIgnore, @Value(value="${rdm-sync.auto-create.schema:rdm}") String defaultSchema, AutoCreateRefBookProperty autoCreateRefBookProperties) {
        this.syncSourceDao = syncSourceDao;
        this.dao = dao;
        this.syncSourceServiceFactories = syncSourceServiceFactories;
        this.caseIgnore = caseIgnore;
        this.defaultSchema = defaultSchema;
        this.autoCreateRefBookProperties = autoCreateRefBookProperties;
    }

    @Override
    public List<VersionAndFieldMapping> getVersionAndFieldMappingList() {
        ArrayList autoCreateOnPropValues = this.autoCreateRefBookProperties == null || this.autoCreateRefBookProperties.getRefbooks() == null ? new ArrayList() : this.autoCreateRefBookProperties.getRefbooks();
        ArrayList<VersionAndFieldMapping> versionAndFieldMappings = new ArrayList<VersionAndFieldMapping>();
        autoCreateOnPropValues.forEach(refbook -> versionAndFieldMappings.add(this.createMapping((AutoCreateRefBookPropertyValue)refbook)));
        return versionAndFieldMappings;
    }

    private VersionAndFieldMapping createMapping(AutoCreateRefBookPropertyValue refbook) {
        RefBookVersion lastPublished = this.getSyncSourceService(refbook.getSource()).getRefBook(refbook.getCode(), null);
        if (lastPublished == null) {
            throw new IllegalArgumentException(refbook.getCode() + " not found in " + refbook.getCode());
        }
        return new VersionAndFieldMapping(this.generateVersionMapping(refbook, lastPublished.getStructure()), this.generateFieldMappings(lastPublished.getStructure()));
    }

    private VersionMapping generateVersionMapping(AutoCreateRefBookPropertyValue refbook, RefBookStructure structure) {
        String schemaTable = RdmSyncInitUtils.buildTableNameWithSchema(refbook.getCode(), refbook.getTable(), this.defaultSchema, Boolean.TRUE.equals(this.caseIgnore));
        String uniqueSysField = this.caseIgnore ? ((String)structure.getPrimaries().get(0)).toLowerCase() : (String)structure.getPrimaries().get(0);
        Object isDeletedField = "deleted_ts";
        if (structure.getAttributesAndTypes().containsKey(isDeletedField)) {
            isDeletedField = "rdm_sync_internal_" + (String)isDeletedField;
        }
        return new VersionMapping(null, refbook.getCode(), refbook.getName(), null, schemaTable, refbook.getSysPkColumn(), refbook.getSource(), uniqueSysField, (String)isDeletedField, null, -2, null, refbook.getType(), refbook.getRange());
    }

    private List<FieldMapping> generateFieldMappings(RefBookStructure structure) {
        ArrayList<FieldMapping> fieldMappings = new ArrayList<FieldMapping>(structure.getAttributesAndTypes().size() + 1);
        for (Map.Entry attr : structure.getAttributesAndTypes().entrySet()) {
            fieldMappings.add(new FieldMapping(this.caseIgnore ? ((String)attr.getKey()).toLowerCase() : (String)attr.getKey(), DataTypeEnum.getByRdmAttr((AttributeTypeEnum)attr.getValue()).getDataTypes().get(0), (String)attr.getKey()));
        }
        return fieldMappings;
    }

    private SyncSourceService getSyncSourceService(String sourceCode) {
        SyncSource source = this.syncSourceDao.findByCode(sourceCode);
        return this.syncSourceServiceFactories.stream().filter(factory -> factory.isSatisfied(source)).findAny().orElseThrow(() -> new IllegalArgumentException("cannot find factory by " + source.getFactoryName())).createService(source);
    }
}

