/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.mapping;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionAndFieldMapping;
import ru.i_novus.ms.rdm.sync.model.loader.XmlMapping;
import ru.i_novus.ms.rdm.sync.model.loader.XmlMappingRefBook;
import ru.i_novus.ms.rdm.sync.service.init.RdmSyncInitUtils;
import ru.i_novus.ms.rdm.sync.service.init.RdmSyncInitializer;
import ru.i_novus.ms.rdm.sync.service.mapping.MappingSourceService;

@Component
public class XmlMappingSourceService
implements MappingSourceService {
    private static final Logger logger = LoggerFactory.getLogger(XmlMappingSourceService.class);
    @Value(value="${rdm-sync.rdm-mapping.xml.path:/rdm-mapping.xml}")
    private String rdmMappingXmlPath;
    @Value(value="${rdm-sync.auto-create.schema:rdm}")
    private String defaultSchema;
    @Value(value="${rdm-sync.auto-create.ignore-case:true}")
    private Boolean caseIgnore;

    public void setRdmMappingXmlPath(String rdmMappingXmlPath) {
        this.rdmMappingXmlPath = rdmMappingXmlPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<VersionAndFieldMapping> getVersionAndFieldMappingList() {
        try (InputStream io = RdmSyncInitializer.class.getResourceAsStream(this.rdmMappingXmlPath);){
            if (io == null) {
                logger.info("rdm-mapping.xml not found, xml mapping loader skipped");
                List<VersionAndFieldMapping> list2 = Collections.emptyList();
                return list2;
            }
            Unmarshaller jaxbUnmarshaller = XmlMapping.JAXB_CONTEXT.createUnmarshaller();
            XmlMapping mapping = (XmlMapping)jaxbUnmarshaller.unmarshal(io);
            this.normalizeSysTable(mapping);
            List<VersionAndFieldMapping> list = this.toVersionMappingList(mapping.getRefbooks());
            return list;
        }
        catch (IOException | JAXBException e) {
            logger.error("xml mapping load error ", e);
            throw new RdmException(e);
        }
    }

    private List<VersionAndFieldMapping> toVersionMappingList(List<XmlMappingRefBook> refBooks) {
        return refBooks.stream().map(XmlMappingRefBook::convertToVersionAndFieldMapping).collect(Collectors.toList());
    }

    private void normalizeSysTable(XmlMapping mapping) {
        mapping.getRefbooks().forEach(v -> {
            String tableName = RdmSyncInitUtils.buildTableNameWithSchema(v.getCode(), v.getSysTable(), this.defaultSchema, Boolean.TRUE.equals(this.caseIgnore));
            v.setSysTable(tableName);
        });
    }
}

