/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.persister;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import lombok.Lombok;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;

public class RetryingPageIterator<T>
implements Iterator<Page<? extends T>> {
    private static final Logger logger = LoggerFactory.getLogger(RetryingPageIterator.class);
    private final Iterator<Page<? extends T>> original;
    private final int tries;
    private final int timeout;

    public RetryingPageIterator(Iterator<Page<? extends T>> original, int tries, int timeout) {
        this.original = original;
        this.timeout = timeout;
        this.tries = tries;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.retry(this.original::hasNext);
        }
        catch (Throwable $ex) {
            throw Lombok.sneakyThrow((Throwable)$ex);
        }
    }

    @Override
    public Page<? extends T> next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.retry(this.original::next);
        }
        catch (Throwable $ex) {
            throw Lombok.sneakyThrow((Throwable)$ex);
        }
    }

    private <E> E retry(Supplier<? extends E> supplier) {
        try {
            int count = 0;
            while (count++ < this.tries) {
                try {
                    return supplier.get();
                }
                catch (RuntimeException e) {
                    logger.warn(String.format("An error occurred, we will try again in %s seconds (%s tries left)", this.timeout / 1000, this.tries - count));
                    Thread.sleep(this.timeout);
                }
            }
            return supplier.get();
        }
        catch (Throwable $ex) {
            throw Lombok.sneakyThrow((Throwable)$ex);
        }
    }
}

