/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.persister;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.LoadedVersion;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.api.model.DataCriteria;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.service.RdmMappingService;
import ru.i_novus.ms.rdm.sync.service.persister.PersisterService;
import ru.i_novus.ms.rdm.sync.service.persister.RetryingPageIterator;
import ru.i_novus.ms.rdm.sync.util.PageIterator;

@Service
public class SimpleVersionedPersisterService
implements PersisterService {
    private final RdmSyncDao rdmSyncDao;
    private final int maxSize;
    private final RdmMappingService mappingService;
    private final int tries;
    private final int timeout;

    public SimpleVersionedPersisterService(RdmSyncDao rdmSyncDao, @Value(value="${rdm-sync.load.size: 1000}") int maxSize, RdmMappingService mappingService, @Value(value="${rdm-sync.load.retry.tries: 5}") int tries, @Value(value="${rdm-sync.load.retry.timeout: 30000}") int timeout) {
        this.rdmSyncDao = rdmSyncDao;
        this.maxSize = maxSize;
        this.mappingService = mappingService;
        this.timeout = timeout;
        this.tries = tries;
    }

    @Override
    public void firstWrite(RefBookVersion newVersion, VersionMapping versionMapping, SyncSourceService syncSourceService) {
        List<FieldMapping> fieldMappings = this.rdmSyncDao.getFieldMappings(versionMapping.getId());
        DataCriteria searchDataCriteria = new DataCriteria();
        searchDataCriteria.setCode(versionMapping.getCode());
        searchDataCriteria.setVersion(newVersion.getVersion());
        searchDataCriteria.setPageSize(this.maxSize);
        this.insertVersion(newVersion, versionMapping, syncSourceService, fieldMappings, searchDataCriteria);
    }

    @Override
    public void merge(RefBookVersion newVersion, String synchedVersion, VersionMapping versionMapping, SyncSourceService syncSourceService) {
        List<FieldMapping> fieldMappings = this.rdmSyncDao.getFieldMappings(versionMapping.getId());
        DataCriteria searchDataCriteria = new DataCriteria();
        searchDataCriteria.setCode(versionMapping.getCode());
        searchDataCriteria.setVersion(newVersion.getVersion());
        searchDataCriteria.setPageSize(this.maxSize);
        this.insertVersion(newVersion, versionMapping, syncSourceService, fieldMappings, searchDataCriteria);
    }

    @Override
    public void repeatVersion(RefBookVersion refBookVersion, VersionMapping versionMapping, SyncSourceService syncSourceService) {
        DataCriteria searchDataCriteria = new DataCriteria();
        searchDataCriteria.setCode(versionMapping.getCode());
        searchDataCriteria.setVersion(refBookVersion.getVersion());
        searchDataCriteria.setVersion(refBookVersion.getVersion());
        searchDataCriteria.setPageSize(this.maxSize);
        this.updateVersion(refBookVersion, versionMapping, syncSourceService, this.rdmSyncDao.getFieldMappings(versionMapping.getId()), searchDataCriteria);
    }

    private void insertVersion(RefBookVersion newVersion, VersionMapping versionMapping, SyncSourceService syncSourceService, List<FieldMapping> fieldMappings, DataCriteria searchDataCriteria) {
        this.processRows(newVersion, syncSourceService, fieldMappings, searchDataCriteria, rows -> this.rdmSyncDao.insertSimpleVersionedRows(versionMapping.getTable(), (List<Map<String, Object>>)rows, this.rdmSyncDao.getLoadedVersion(newVersion.getCode(), newVersion.getVersion()).getId()));
    }

    private void updateVersion(RefBookVersion newVersion, VersionMapping versionMapping, SyncSourceService syncSourceService, List<FieldMapping> fieldMappings, DataCriteria searchDataCriteria) {
        this.processRows(newVersion, syncSourceService, fieldMappings, searchDataCriteria, rows -> this.rdmSyncDao.upsertVersionedRows(versionMapping.getTable(), (List<Map<String, Object>>)rows, this.rdmSyncDao.getLoadedVersion(newVersion.getCode(), newVersion.getVersion()).getId(), versionMapping.getPrimaryField()));
    }

    private void processRows(RefBookVersion newVersion, SyncSourceService syncSourceService, List<FieldMapping> fieldMappings, DataCriteria searchDataCriteria, Consumer<List<Map<String, Object>>> rowProcessing) {
        RetryingPageIterator iter = new RetryingPageIterator(new PageIterator(arg_0 -> ((SyncSourceService)syncSourceService).getData(arg_0), searchDataCriteria, true), this.tries, this.timeout);
        while (iter.hasNext()) {
            Page page = iter.next();
            List mappedRows = page.getContent().stream().map(row -> this.mapRow((Map<String, ?>)row, newVersion, fieldMappings)).collect(Collectors.toList());
            rowProcessing.accept(mappedRows);
        }
    }

    private Map<String, Object> mapRow(Map<String, ?> row, RefBookVersion refBookVersion, List<FieldMapping> fieldMappings) {
        HashMap<String, Object> mappedRow = new HashMap<String, Object>();
        for (Map.Entry<String, ?> fieldValue : row.entrySet()) {
            Map<String, Object> mappedValue = this.mapValue(refBookVersion, fieldValue.getKey(), fieldValue.getValue(), fieldMappings);
            if (mappedValue == null) continue;
            mappedRow.putAll(mappedValue);
        }
        fieldMappings.forEach(mapping -> {
            if (!mappedRow.containsKey(mapping.getSysField())) {
                mappedRow.put(mapping.getSysField(), null);
            }
        });
        LoadedVersion loadedVersion = this.rdmSyncDao.getLoadedVersion(refBookVersion.getCode(), refBookVersion.getVersion());
        return mappedRow;
    }

    private Map<String, Object> mapValue(RefBookVersion newVersion, String rdmField, Object value, List<FieldMapping> fieldMappings) {
        FieldMapping fieldMapping = fieldMappings.stream().filter(mapping -> mapping.getRdmField().equals(rdmField)).findAny().orElse(null);
        if (fieldMapping == null) {
            return null;
        }
        AttributeTypeEnum attributeType = (AttributeTypeEnum)newVersion.getStructure().getAttributesAndTypes().get(fieldMapping.getRdmField());
        DataTypeEnum clientType = DataTypeEnum.getByDataType(fieldMapping.getSysDataType());
        HashMap<String, Object> mappedValue = new HashMap<String, Object>();
        mappedValue.put(fieldMapping.getSysField(), this.mappingService.map(attributeType, clientType, value));
        return mappedValue;
    }
}

