/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.updater;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.LoadedVersion;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersionItem;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.RdmLoggingService;
import ru.i_novus.ms.rdm.sync.service.persister.PersisterService;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookUpdater;
import ru.i_novus.ms.rdm.sync.service.updater.RefBookUpdaterException;

public abstract class BaseRefBookUpdater
implements RefBookUpdater {
    private static final Logger logger = LoggerFactory.getLogger(BaseRefBookUpdater.class);
    protected final RdmSyncDao dao;
    protected final SyncSourceService syncSourceService;
    private final RdmLoggingService loggingService;

    protected abstract PersisterService getPersisterService();

    protected BaseRefBookUpdater(RdmSyncDao dao, SyncSourceService syncSourceService, RdmLoggingService loggingService) {
        this.dao = dao;
        this.syncSourceService = syncSourceService;
        this.loggingService = loggingService;
    }

    @Override
    public void update(String refCode, String version) throws RefBookUpdaterException {
        RefBookVersion newVersion;
        logger.info("try to load {} version: {}", (Object)refCode, (Object)version);
        try {
            newVersion = this.getRefBookVersion(refCode, version);
        }
        catch (Exception e) {
            logger.error(String.format("Error while fetching new version with code '%s'.", refCode), (Throwable)e);
            return;
        }
        VersionMapping versionMapping = this.getVersionMapping(newVersion);
        if (versionMapping == null) {
            logger.error("No version mapping found for reference book with code '{}'.", (Object)refCode);
            return;
        }
        LoadedVersion loadedVersion = this.dao.getLoadedVersion(refCode, newVersion.getVersion());
        try {
            if (!this.dao.existsLoadedVersion(refCode) || loadedVersion == null || this.isMappingChanged(versionMapping, loadedVersion) || this.isNewVersionPublished((RefBookVersionItem)newVersion, loadedVersion) && versionMapping.getType().equals((Object)SyncTypeEnum.RDM_NOT_VERSIONED)) {
                this.update(newVersion, versionMapping);
                this.loggingService.logOk(refCode, versionMapping.getRefBookVersion(), newVersion.getVersion());
            } else {
                logger.info("Skipping update on '{}'. No changes.", (Object)refCode);
            }
        }
        catch (Exception e) {
            throw new RefBookUpdaterException(e, versionMapping, newVersion);
        }
    }

    private RefBookVersion getRefBookVersion(String refBookCode, String version) {
        RefBookVersion refBook = this.syncSourceService.getRefBook(refBookCode, version);
        if (refBook == null) {
            throw new IllegalArgumentException(String.format("Reference book with code '%s' not found.", refBookCode));
        }
        if (!refBook.getStructure().hasPrimary()) {
            throw new IllegalStateException(String.format("Reference book with code '%s' has not primary key.", refBookCode));
        }
        return refBook;
    }

    private VersionMapping getVersionMapping(RefBookVersion refBookVersion) {
        VersionMapping versionMapping = this.dao.getVersionMapping(refBookVersion.getCode(), refBookVersion.getVersion());
        if (versionMapping == null) {
            versionMapping = this.dao.getVersionMapping(refBookVersion.getCode(), "CURRENT");
        }
        if (versionMapping == null) {
            return null;
        }
        List<FieldMapping> fieldMappings = this.dao.getFieldMappings(versionMapping.getId());
        String primaryField = versionMapping.getPrimaryField();
        if (fieldMappings.stream().noneMatch(mapping -> mapping.getSysField().equals(primaryField))) {
            throw new IllegalArgumentException(String.format("No mapping found for primary key '%s'.", primaryField));
        }
        return versionMapping;
    }

    protected boolean isMappingChanged(VersionMapping versionMapping, LoadedVersion loadedVersion) {
        return versionMapping.getMappingLastUpdated().isAfter(loadedVersion.getLastSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(RefBookVersion newVersion, VersionMapping versionMapping) {
        logger.info("{} sync started", (Object)newVersion.getCode());
        List<FieldMapping> fieldMappings = this.dao.getFieldMappings(versionMapping.getId());
        this.validateStructureAndMapping(newVersion, fieldMappings);
        boolean haveTrigger = this.dao.existsInternalLocalRowStateUpdateTrigger(versionMapping.getTable());
        if (haveTrigger) {
            this.dao.disableInternalLocalRowStateUpdateTrigger(versionMapping.getTable());
        }
        try {
            this.updateProcessing(newVersion, versionMapping);
        }
        finally {
            if (haveTrigger) {
                this.dao.enableInternalLocalRowStateUpdateTrigger(versionMapping.getTable());
            }
        }
    }

    private void validateStructureAndMapping(RefBookVersion newVersion, List<FieldMapping> fieldMappings) {
        List clientRdmFields = fieldMappings.stream().map(FieldMapping::getRdmField).collect(Collectors.toList());
        Set actualFields = newVersion.getStructure().getAttributesAndTypes().keySet();
        if (!actualFields.containsAll(clientRdmFields)) {
            clientRdmFields.removeAll(actualFields);
            throw new IllegalStateException(String.format("Field '%s' was deleted in version with code '%s'. Update your mappings.", String.join((CharSequence)",", clientRdmFields), newVersion.getCode()));
        }
    }

    private boolean isNewVersionPublished(RefBookVersionItem newVersion, LoadedVersion loadedVersion) {
        return loadedVersion.getPublicationDate().isBefore(newVersion.getFrom());
    }

    protected void updateProcessing(RefBookVersion newVersion, VersionMapping versionMapping) {
        LoadedVersion loadedVersion = this.dao.getLoadedVersion(newVersion.getCode(), newVersion.getVersion());
        if (loadedVersion == null && !this.dao.existsLoadedVersion(newVersion.getCode())) {
            this.addFirstVersion(newVersion, versionMapping);
        } else if (loadedVersion == null) {
            this.addNewVersion(newVersion, versionMapping);
        } else if (this.isMappingChanged(versionMapping, loadedVersion) || newVersion.getFrom().isAfter(loadedVersion.getPublicationDate())) {
            this.editVersion(newVersion, versionMapping, loadedVersion);
        }
        logger.info("{}, version {} sync finished", (Object)newVersion.getCode(), (Object)newVersion.getVersion());
    }

    protected void editVersion(RefBookVersion newVersion, VersionMapping versionMapping, LoadedVersion loadedVersion) {
        logger.info("{} repeat version {}", (Object)newVersion.getCode(), (Object)newVersion.getVersion());
        this.getPersisterService().repeatVersion(newVersion, versionMapping, this.syncSourceService);
        this.dao.updateLoadedVersion(loadedVersion.getId(), newVersion.getVersion(), newVersion.getFrom(), newVersion.getTo());
    }

    protected void addNewVersion(RefBookVersion newVersion, VersionMapping versionMapping) {
        logger.info("{} sync new version {}", (Object)newVersion.getCode(), (Object)newVersion.getVersion());
        LoadedVersion actualLoadedVersion = this.dao.getActualLoadedVersion(newVersion.getCode());
        if (newVersion.getFrom().isAfter(actualLoadedVersion.getPublicationDate())) {
            this.dao.closeLoadedVersion(actualLoadedVersion.getCode(), actualLoadedVersion.getVersion(), newVersion.getFrom());
        }
        this.dao.insertLoadedVersion(newVersion.getCode(), newVersion.getVersion(), newVersion.getFrom(), newVersion.getTo(), newVersion.getFrom().isAfter(actualLoadedVersion.getPublicationDate()));
        this.getPersisterService().merge(newVersion, actualLoadedVersion.getVersion(), versionMapping, this.syncSourceService);
    }

    protected void addFirstVersion(RefBookVersion newVersion, VersionMapping versionMapping) {
        logger.info("{} first sync", (Object)newVersion.getCode());
        this.dao.insertLoadedVersion(newVersion.getCode(), newVersion.getVersion(), newVersion.getFrom(), newVersion.getTo(), true);
        this.getPersisterService().firstWrite(newVersion, versionMapping, this.syncSourceService);
    }
}

