/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.updater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.i_novus.ms.rdm.sync.api.mapping.LoadedVersion;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersionItem;
import ru.i_novus.ms.rdm.sync.api.model.SyncRefBook;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;

public class RefBookVersionsDeterminator {
    private final SyncRefBook refBook;
    private final RdmSyncDao rdmSyncDao;
    private final SyncSourceService syncSourceService;

    public RefBookVersionsDeterminator(SyncRefBook refBook, RdmSyncDao rdmSyncDao, SyncSourceService syncSourceService) {
        this.refBook = refBook;
        this.rdmSyncDao = rdmSyncDao;
        this.syncSourceService = syncSourceService;
    }

    public List<String> getVersions() {
        Stream<RefBookVersion> refBookVersionStream;
        List<LoadedVersion> loadedVersions = this.rdmSyncDao.getLoadedVersions(this.refBook.getCode());
        ArrayList<String> loadedVersionsStringValues = new ArrayList<String>();
        String actualLoadedVersion = null;
        for (LoadedVersion loadedVersion : loadedVersions) {
            if (Boolean.TRUE.equals(loadedVersion.getActual())) {
                actualLoadedVersion = loadedVersion.getVersion();
            }
            loadedVersionsStringValues.add(loadedVersion.getVersion());
        }
        if (this.refBook.getRange() == null) {
            refBookVersionStream = Stream.of(this.syncSourceService.getRefBook(this.refBook.getCode(), null));
        } else {
            List allVersions = this.syncSourceService.getVersions(this.refBook.getCode());
            List<VersionsRange> ranges = this.getRanges(this.refBook.getRange(), allVersions);
            refBookVersionStream = allVersions.stream().filter(refBookVersion -> ranges.stream().anyMatch(range -> range.contains((RefBookVersionItem)refBookVersion)));
        }
        String finalActualVersion = actualLoadedVersion;
        return refBookVersionStream.filter(refBookVersion -> this.isNeedToLoad((RefBookVersionItem)refBookVersion, (List<String>)loadedVersionsStringValues, finalActualVersion)).map(RefBookVersionItem::getVersion).collect(Collectors.toList());
    }

    private boolean isNeedToLoad(RefBookVersionItem refBookVersion, List<String> loadedVersions, String actualVersion) {
        VersionMapping versionMapping = this.rdmSyncDao.getVersionMapping(this.refBook.getCode(), refBookVersion.getVersion());
        if (versionMapping == null) {
            versionMapping = this.rdmSyncDao.getVersionMapping(this.refBook.getCode(), "CURRENT");
        }
        return !loadedVersions.contains(refBookVersion.getVersion()) || !versionMapping.getMappingLastUpdated().isBefore(refBookVersion.getFrom()) && refBookVersion.getVersion().equals(actualVersion) || versionMapping.getType().equals((Object)SyncTypeEnum.RDM_NOT_VERSIONED);
    }

    private List<VersionsRange> getRanges(String range, List<RefBookVersionItem> versions) {
        ArrayList<VersionsRange> result = new ArrayList<VersionsRange>();
        if (range.contains(",")) {
            Arrays.stream(range.split(",")).forEach(splitRange -> result.addAll(this.getRanges((String)splitRange, versions)));
        } else if (range.contains("-")) {
            RefBookVersionItem left = null;
            RefBookVersionItem right = null;
            String[] splitRange2 = range.split("-");
            if (splitRange2.length != 2) {
                throw new IllegalArgumentException("cannot parse " + range);
            }
            for (RefBookVersionItem version2 : versions) {
                if (version2.getVersion().equals(splitRange2[0])) {
                    left = version2;
                }
                if (!version2.getVersion().equals(splitRange2[1])) continue;
                right = version2;
            }
            if (left != null || right != null) {
                result.add(new VersionsRange(left, right));
            }
        } else if (range.equals("*")) {
            result.add(new VersionsRange(null, null));
        } else {
            Optional<RefBookVersionItem> refBookVersion = versions.stream().filter(version -> version.getVersion().equals(range)).findAny();
            refBookVersion.ifPresent(version -> result.add(new VersionsRange((RefBookVersionItem)version, (RefBookVersionItem)version)));
        }
        return result;
    }

    private static class VersionsRange {
        private RefBookVersionItem left;
        private RefBookVersionItem right;

        VersionsRange(RefBookVersionItem left, RefBookVersionItem right) {
            this.left = left;
            this.right = right;
        }

        boolean contains(RefBookVersionItem refBookVersion) {
            return !(this.left != null && this.left.getFrom().isAfter(refBookVersion.getFrom()) || this.right != null && this.right.getFrom().isBefore(refBookVersion.getFrom()));
        }
    }
}

