/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.n2oapp.platform.jaxrs.RestCriteria;
import org.springframework.data.domain.Page;

public class PageIterator<T, C extends RestCriteria>
implements Iterator<Page<? extends T>> {
    private final Function<? super C, Page<? extends T>> pageSource;
    private final C criteria;
    private int currentPage;
    private Page<? extends T> nextPage;

    public PageIterator(Function<? super C, Page<? extends T>> pageSource, C criteria) {
        this(pageSource, (C)criteria, false);
    }

    public PageIterator(Function<? super C, Page<? extends T>> pageSource, C criteria, boolean defaultSortProvied) {
        if (!defaultSortProvied && criteria.getSort() == null) {
            throw new IllegalArgumentException("You must either ensure that default sort is provided by pageSource or set some sorting in your criteria.");
        }
        this.pageSource = pageSource;
        this.criteria = criteria;
        this.currentPage = criteria.getPageNumber() - 1;
    }

    @Override
    public boolean hasNext() {
        if (this.nextPage != null) {
            return true;
        }
        this.criteria.setPageNumber(this.currentPage + 1);
        this.nextPage = this.pageSource.apply(this.criteria);
        List content = this.nextPage.getContent();
        return !content.isEmpty();
    }

    @Override
    public Page<? extends T> next() {
        Page<? extends T> result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nextPage != null) {
            result = this.nextPage;
            this.nextPage = null;
        } else {
            this.criteria.setPageNumber(this.currentPage + 1);
            result = this.pageSource.apply(this.criteria);
        }
        ++this.currentPage;
        return result;
    }
}

