/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are the details of the specified hypervisor. A hypervisor is hardware, software, or firmware that creates and
 * manages virtual machines, and allocates resources to them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HypervisorDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<HypervisorDetails.Builder, HypervisorDetails> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(HypervisorDetails::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HypervisorArn").getter(getter(HypervisorDetails::hypervisorArn)).setter(setter(Builder::hypervisorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(HypervisorDetails::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_METADATA_SYNC_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulMetadataSyncTime")
            .getter(getter(HypervisorDetails::lastSuccessfulMetadataSyncTime))
            .setter(setter(Builder::lastSuccessfulMetadataSyncTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulMetadataSyncTime")
                    .build()).build();

    private static final SdkField<String> LATEST_METADATA_SYNC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestMetadataSyncStatus").getter(getter(HypervisorDetails::latestMetadataSyncStatusAsString))
            .setter(setter(Builder::latestMetadataSyncStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestMetadataSyncStatus").build())
            .build();

    private static final SdkField<String> LATEST_METADATA_SYNC_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestMetadataSyncStatusMessage")
            .getter(getter(HypervisorDetails::latestMetadataSyncStatusMessage))
            .setter(setter(Builder::latestMetadataSyncStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestMetadataSyncStatusMessage")
                    .build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupArn").getter(getter(HypervisorDetails::logGroupArn)).setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(HypervisorDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(HypervisorDetails::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD,
            HYPERVISOR_ARN_FIELD, KMS_KEY_ARN_FIELD, LAST_SUCCESSFUL_METADATA_SYNC_TIME_FIELD, LATEST_METADATA_SYNC_STATUS_FIELD,
            LATEST_METADATA_SYNC_STATUS_MESSAGE_FIELD, LOG_GROUP_ARN_FIELD, NAME_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String host;

    private final String hypervisorArn;

    private final String kmsKeyArn;

    private final Instant lastSuccessfulMetadataSyncTime;

    private final String latestMetadataSyncStatus;

    private final String latestMetadataSyncStatusMessage;

    private final String logGroupArn;

    private final String name;

    private final String state;

    private HypervisorDetails(BuilderImpl builder) {
        this.host = builder.host;
        this.hypervisorArn = builder.hypervisorArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastSuccessfulMetadataSyncTime = builder.lastSuccessfulMetadataSyncTime;
        this.latestMetadataSyncStatus = builder.latestMetadataSyncStatus;
        this.latestMetadataSyncStatusMessage = builder.latestMetadataSyncStatusMessage;
        this.logGroupArn = builder.logGroupArn;
        this.name = builder.name;
        this.state = builder.state;
    }

    /**
     * <p>
     * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
     * </p>
     * 
     * @return The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
     *         (FQDN).
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hypervisor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hypervisor.
     */
    public final String hypervisorArn() {
        return hypervisorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * This is the time when the most recent successful sync of metadata occurred.
     * </p>
     * 
     * @return This is the time when the most recent successful sync of metadata occurred.
     */
    public final Instant lastSuccessfulMetadataSyncTime() {
        return lastSuccessfulMetadataSyncTime;
    }

    /**
     * <p>
     * This is the most recent status for the indicated metadata sync.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestMetadataSyncStatus} will return {@link SyncMetadataStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestMetadataSyncStatusAsString}.
     * </p>
     * 
     * @return This is the most recent status for the indicated metadata sync.
     * @see SyncMetadataStatus
     */
    public final SyncMetadataStatus latestMetadataSyncStatus() {
        return SyncMetadataStatus.fromValue(latestMetadataSyncStatus);
    }

    /**
     * <p>
     * This is the most recent status for the indicated metadata sync.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestMetadataSyncStatus} will return {@link SyncMetadataStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestMetadataSyncStatusAsString}.
     * </p>
     * 
     * @return This is the most recent status for the indicated metadata sync.
     * @see SyncMetadataStatus
     */
    public final String latestMetadataSyncStatusAsString() {
        return latestMetadataSyncStatus;
    }

    /**
     * <p>
     * This is the most recent status for the indicated metadata sync.
     * </p>
     * 
     * @return This is the most recent status for the indicated metadata sync.
     */
    public final String latestMetadataSyncStatusMessage() {
        return latestMetadataSyncStatusMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the group of gateways within the requested log.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the group of gateways within the requested log.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    /**
     * <p>
     * This is the name of the specified hypervisor.
     * </p>
     * 
     * @return This is the name of the specified hypervisor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * This is the current state of the specified hypervisor.
     * </p>
     * <p>
     * The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or <code>ERROR</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link HypervisorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This is the current state of the specified hypervisor.</p>
     *         <p>
     *         The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or
     *         <code>ERROR</code>.
     * @see HypervisorState
     */
    public final HypervisorState state() {
        return HypervisorState.fromValue(state);
    }

    /**
     * <p>
     * This is the current state of the specified hypervisor.
     * </p>
     * <p>
     * The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or <code>ERROR</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link HypervisorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This is the current state of the specified hypervisor.</p>
     *         <p>
     *         The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or
     *         <code>ERROR</code>.
     * @see HypervisorState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulMetadataSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestMetadataSyncStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestMetadataSyncStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HypervisorDetails)) {
            return false;
        }
        HypervisorDetails other = (HypervisorDetails) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(hypervisorArn(), other.hypervisorArn())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(lastSuccessfulMetadataSyncTime(), other.lastSuccessfulMetadataSyncTime())
                && Objects.equals(latestMetadataSyncStatusAsString(), other.latestMetadataSyncStatusAsString())
                && Objects.equals(latestMetadataSyncStatusMessage(), other.latestMetadataSyncStatusMessage())
                && Objects.equals(logGroupArn(), other.logGroupArn()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HypervisorDetails").add("Host", host()).add("HypervisorArn", hypervisorArn())
                .add("KmsKeyArn", kmsKeyArn()).add("LastSuccessfulMetadataSyncTime", lastSuccessfulMetadataSyncTime())
                .add("LatestMetadataSyncStatus", latestMetadataSyncStatusAsString())
                .add("LatestMetadataSyncStatusMessage", latestMetadataSyncStatusMessage()).add("LogGroupArn", logGroupArn())
                .add("Name", name()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "HypervisorArn":
            return Optional.ofNullable(clazz.cast(hypervisorArn()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "LastSuccessfulMetadataSyncTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulMetadataSyncTime()));
        case "LatestMetadataSyncStatus":
            return Optional.ofNullable(clazz.cast(latestMetadataSyncStatusAsString()));
        case "LatestMetadataSyncStatusMessage":
            return Optional.ofNullable(clazz.cast(latestMetadataSyncStatusMessage()));
        case "LogGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HypervisorDetails, T> g) {
        return obj -> g.apply((HypervisorDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HypervisorDetails> {
        /**
         * <p>
         * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
         * </p>
         * 
         * @param host
         *        The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
         *        (FQDN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hypervisor.
         * </p>
         * 
         * @param hypervisorArn
         *        The Amazon Resource Name (ARN) of the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisorArn(String hypervisorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * This is the time when the most recent successful sync of metadata occurred.
         * </p>
         * 
         * @param lastSuccessfulMetadataSyncTime
         *        This is the time when the most recent successful sync of metadata occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulMetadataSyncTime(Instant lastSuccessfulMetadataSyncTime);

        /**
         * <p>
         * This is the most recent status for the indicated metadata sync.
         * </p>
         * 
         * @param latestMetadataSyncStatus
         *        This is the most recent status for the indicated metadata sync.
         * @see SyncMetadataStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncMetadataStatus
         */
        Builder latestMetadataSyncStatus(String latestMetadataSyncStatus);

        /**
         * <p>
         * This is the most recent status for the indicated metadata sync.
         * </p>
         * 
         * @param latestMetadataSyncStatus
         *        This is the most recent status for the indicated metadata sync.
         * @see SyncMetadataStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncMetadataStatus
         */
        Builder latestMetadataSyncStatus(SyncMetadataStatus latestMetadataSyncStatus);

        /**
         * <p>
         * This is the most recent status for the indicated metadata sync.
         * </p>
         * 
         * @param latestMetadataSyncStatusMessage
         *        This is the most recent status for the indicated metadata sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestMetadataSyncStatusMessage(String latestMetadataSyncStatusMessage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the group of gateways within the requested log.
         * </p>
         * 
         * @param logGroupArn
         *        The Amazon Resource Name (ARN) of the group of gateways within the requested log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);

        /**
         * <p>
         * This is the name of the specified hypervisor.
         * </p>
         * 
         * @param name
         *        This is the name of the specified hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This is the current state of the specified hypervisor.
         * </p>
         * <p>
         * The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or
         * <code>ERROR</code>.
         * </p>
         * 
         * @param state
         *        This is the current state of the specified hypervisor.</p>
         *        <p>
         *        The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or
         *        <code>ERROR</code>.
         * @see HypervisorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorState
         */
        Builder state(String state);

        /**
         * <p>
         * This is the current state of the specified hypervisor.
         * </p>
         * <p>
         * The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or
         * <code>ERROR</code>.
         * </p>
         * 
         * @param state
         *        This is the current state of the specified hypervisor.</p>
         *        <p>
         *        The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or
         *        <code>ERROR</code>.
         * @see HypervisorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorState
         */
        Builder state(HypervisorState state);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private String hypervisorArn;

        private String kmsKeyArn;

        private Instant lastSuccessfulMetadataSyncTime;

        private String latestMetadataSyncStatus;

        private String latestMetadataSyncStatusMessage;

        private String logGroupArn;

        private String name;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(HypervisorDetails model) {
            host(model.host);
            hypervisorArn(model.hypervisorArn);
            kmsKeyArn(model.kmsKeyArn);
            lastSuccessfulMetadataSyncTime(model.lastSuccessfulMetadataSyncTime);
            latestMetadataSyncStatus(model.latestMetadataSyncStatus);
            latestMetadataSyncStatusMessage(model.latestMetadataSyncStatusMessage);
            logGroupArn(model.logGroupArn);
            name(model.name);
            state(model.state);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getHypervisorArn() {
            return hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getLastSuccessfulMetadataSyncTime() {
            return lastSuccessfulMetadataSyncTime;
        }

        public final void setLastSuccessfulMetadataSyncTime(Instant lastSuccessfulMetadataSyncTime) {
            this.lastSuccessfulMetadataSyncTime = lastSuccessfulMetadataSyncTime;
        }

        @Override
        public final Builder lastSuccessfulMetadataSyncTime(Instant lastSuccessfulMetadataSyncTime) {
            this.lastSuccessfulMetadataSyncTime = lastSuccessfulMetadataSyncTime;
            return this;
        }

        public final String getLatestMetadataSyncStatus() {
            return latestMetadataSyncStatus;
        }

        public final void setLatestMetadataSyncStatus(String latestMetadataSyncStatus) {
            this.latestMetadataSyncStatus = latestMetadataSyncStatus;
        }

        @Override
        public final Builder latestMetadataSyncStatus(String latestMetadataSyncStatus) {
            this.latestMetadataSyncStatus = latestMetadataSyncStatus;
            return this;
        }

        @Override
        public final Builder latestMetadataSyncStatus(SyncMetadataStatus latestMetadataSyncStatus) {
            this.latestMetadataSyncStatus(latestMetadataSyncStatus == null ? null : latestMetadataSyncStatus.toString());
            return this;
        }

        public final String getLatestMetadataSyncStatusMessage() {
            return latestMetadataSyncStatusMessage;
        }

        public final void setLatestMetadataSyncStatusMessage(String latestMetadataSyncStatusMessage) {
            this.latestMetadataSyncStatusMessage = latestMetadataSyncStatusMessage;
        }

        @Override
        public final Builder latestMetadataSyncStatusMessage(String latestMetadataSyncStatusMessage) {
            this.latestMetadataSyncStatusMessage = latestMetadataSyncStatusMessage;
            return this;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HypervisorState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public HypervisorDetails build() {
            return new HypervisorDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
