/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequestAdditionalModelResponseFieldPathsListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.Message;
import software.amazon.awssdk.services.bedrockruntime.model.MessagesCopier;
import software.amazon.awssdk.services.bedrockruntime.model.PerformanceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.PromptVariableMapCopier;
import software.amazon.awssdk.services.bedrockruntime.model.PromptVariableValues;
import software.amazon.awssdk.services.bedrockruntime.model.RequestMetadataCopier;
import software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlocksCopier;
import software.amazon.awssdk.services.bedrockruntime.model.ToolConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConverseRequest
extends BedrockRuntimeRequest
implements ToCopyableBuilder<Builder, ConverseRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(ConverseRequest.getter(ConverseRequest::modelId)).setter(ConverseRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()}).build();
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(ConverseRequest.getter(ConverseRequest::messages)).setter(ConverseRequest.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SystemContentBlock>> SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("system").getter(ConverseRequest.getter(ConverseRequest::system)).setter(ConverseRequest.setter(Builder::system)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("system").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SystemContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(ConverseRequest.getter(ConverseRequest::inferenceConfig)).setter(ConverseRequest.setter(Builder::inferenceConfig)).constructor(InferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<ToolConfiguration> TOOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolConfig").getter(ConverseRequest.getter(ConverseRequest::toolConfig)).setter(ConverseRequest.setter(Builder::toolConfig)).constructor(ToolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfig").build()}).build();
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfig").getter(ConverseRequest.getter(ConverseRequest::guardrailConfig)).setter(ConverseRequest.setter(Builder::guardrailConfig)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfig").build()}).build();
    private static final SdkField<Document> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("additionalModelRequestFields").getter(ConverseRequest.getter(ConverseRequest::additionalModelRequestFields)).setter(ConverseRequest.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build()}).build();
    private static final SdkField<Map<String, PromptVariableValues>> PROMPT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("promptVariables").getter(ConverseRequest.getter(ConverseRequest::promptVariables)).setter(ConverseRequest.setter(Builder::promptVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptVariableValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_MODEL_RESPONSE_FIELD_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalModelResponseFieldPaths").getter(ConverseRequest.getter(ConverseRequest::additionalModelResponseFieldPaths)).setter(ConverseRequest.setter(Builder::additionalModelResponseFieldPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelResponseFieldPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestMetadata").getter(ConverseRequest.getter(ConverseRequest::requestMetadata)).setter(ConverseRequest.setter(Builder::requestMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performanceConfig").getter(ConverseRequest.getter(ConverseRequest::performanceConfig)).setter(ConverseRequest.setter(Builder::performanceConfig)).constructor(PerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MESSAGES_FIELD, SYSTEM_FIELD, INFERENCE_CONFIG_FIELD, TOOL_CONFIG_FIELD, GUARDRAIL_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, PROMPT_VARIABLES_FIELD, ADDITIONAL_MODEL_RESPONSE_FIELD_PATHS_FIELD, REQUEST_METADATA_FIELD, PERFORMANCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConverseRequest.memberNameToFieldInitializer();
    private final String modelId;
    private final List<Message> messages;
    private final List<SystemContentBlock> system;
    private final InferenceConfiguration inferenceConfig;
    private final ToolConfiguration toolConfig;
    private final GuardrailConfiguration guardrailConfig;
    private final Document additionalModelRequestFields;
    private final Map<String, PromptVariableValues> promptVariables;
    private final List<String> additionalModelResponseFieldPaths;
    private final Map<String, String> requestMetadata;
    private final PerformanceConfiguration performanceConfig;

    private ConverseRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.messages = builder.messages;
        this.system = builder.system;
        this.inferenceConfig = builder.inferenceConfig;
        this.toolConfig = builder.toolConfig;
        this.guardrailConfig = builder.guardrailConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.promptVariables = builder.promptVariables;
        this.additionalModelResponseFieldPaths = builder.additionalModelResponseFieldPaths;
        this.requestMetadata = builder.requestMetadata;
        this.performanceConfig = builder.performanceConfig;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final boolean hasSystem() {
        return this.system != null && !(this.system instanceof SdkAutoConstructList);
    }

    public final List<SystemContentBlock> system() {
        return this.system;
    }

    public final InferenceConfiguration inferenceConfig() {
        return this.inferenceConfig;
    }

    public final ToolConfiguration toolConfig() {
        return this.toolConfig;
    }

    public final GuardrailConfiguration guardrailConfig() {
        return this.guardrailConfig;
    }

    public final Document additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public final boolean hasPromptVariables() {
        return this.promptVariables != null && !(this.promptVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, PromptVariableValues> promptVariables() {
        return this.promptVariables;
    }

    public final boolean hasAdditionalModelResponseFieldPaths() {
        return this.additionalModelResponseFieldPaths != null && !(this.additionalModelResponseFieldPaths instanceof SdkAutoConstructList);
    }

    public final List<String> additionalModelResponseFieldPaths() {
        return this.additionalModelResponseFieldPaths;
    }

    public final boolean hasRequestMetadata() {
        return this.requestMetadata != null && !(this.requestMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestMetadata() {
        return this.requestMetadata;
    }

    public final PerformanceConfiguration performanceConfig() {
        return this.performanceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystem() ? this.system() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalModelRequestFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromptVariables() ? this.promptVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelResponseFieldPaths() ? this.additionalModelResponseFieldPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestMetadata() ? this.requestMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseRequest)) {
            return false;
        }
        ConverseRequest other = (ConverseRequest)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && this.hasSystem() == other.hasSystem() && Objects.equals(this.system(), other.system()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && Objects.equals(this.toolConfig(), other.toolConfig()) && Objects.equals(this.guardrailConfig(), other.guardrailConfig()) && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields()) && this.hasPromptVariables() == other.hasPromptVariables() && Objects.equals(this.promptVariables(), other.promptVariables()) && this.hasAdditionalModelResponseFieldPaths() == other.hasAdditionalModelResponseFieldPaths() && Objects.equals(this.additionalModelResponseFieldPaths(), other.additionalModelResponseFieldPaths()) && this.hasRequestMetadata() == other.hasRequestMetadata() && Objects.equals(this.requestMetadata(), other.requestMetadata()) && Objects.equals(this.performanceConfig(), other.performanceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ConverseRequest").add("ModelId", (Object)this.modelId()).add("Messages", this.hasMessages() ? this.messages() : null).add("System", this.hasSystem() ? this.system() : null).add("InferenceConfig", (Object)this.inferenceConfig()).add("ToolConfig", (Object)this.toolConfig()).add("GuardrailConfig", (Object)this.guardrailConfig()).add("AdditionalModelRequestFields", (Object)this.additionalModelRequestFields()).add("PromptVariables", (Object)(this.promptVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("AdditionalModelResponseFieldPaths", this.hasAdditionalModelResponseFieldPaths() ? this.additionalModelResponseFieldPaths() : null).add("RequestMetadata", (Object)(this.requestMetadata() == null ? null : "*** Sensitive Data Redacted ***")).add("PerformanceConfig", (Object)this.performanceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "system": {
                return Optional.ofNullable(clazz.cast(this.system()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "toolConfig": {
                return Optional.ofNullable(clazz.cast(this.toolConfig()));
            }
            case "guardrailConfig": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfig()));
            }
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
            case "promptVariables": {
                return Optional.ofNullable(clazz.cast(this.promptVariables()));
            }
            case "additionalModelResponseFieldPaths": {
                return Optional.ofNullable(clazz.cast(this.additionalModelResponseFieldPaths()));
            }
            case "requestMetadata": {
                return Optional.ofNullable(clazz.cast(this.requestMetadata()));
            }
            case "performanceConfig": {
                return Optional.ofNullable(clazz.cast(this.performanceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("messages", MESSAGES_FIELD);
        map.put("system", SYSTEM_FIELD);
        map.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("toolConfig", TOOL_CONFIG_FIELD);
        map.put("guardrailConfig", GUARDRAIL_CONFIG_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("promptVariables", PROMPT_VARIABLES_FIELD);
        map.put("additionalModelResponseFieldPaths", ADDITIONAL_MODEL_RESPONSE_FIELD_PATHS_FIELD);
        map.put("requestMetadata", REQUEST_METADATA_FIELD);
        map.put("performanceConfig", PERFORMANCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConverseRequest, T> g) {
        return obj -> g.apply((ConverseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeRequest.BuilderImpl
    implements Builder {
        private String modelId;
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private List<SystemContentBlock> system = DefaultSdkAutoConstructList.getInstance();
        private InferenceConfiguration inferenceConfig;
        private ToolConfiguration toolConfig;
        private GuardrailConfiguration guardrailConfig;
        private Document additionalModelRequestFields;
        private Map<String, PromptVariableValues> promptVariables = DefaultSdkAutoConstructMap.getInstance();
        private List<String> additionalModelResponseFieldPaths = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> requestMetadata = DefaultSdkAutoConstructMap.getInstance();
        private PerformanceConfiguration performanceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseRequest model) {
            super(model);
            this.modelId(model.modelId);
            this.messages(model.messages);
            this.system(model.system);
            this.inferenceConfig(model.inferenceConfig);
            this.toolConfig(model.toolConfig);
            this.guardrailConfig(model.guardrailConfig);
            this.additionalModelRequestFields(model.additionalModelRequestFields);
            this.promptVariables(model.promptVariables);
            this.additionalModelResponseFieldPaths(model.additionalModelResponseFieldPaths);
            this.requestMetadata(model.requestMetadata);
            this.performanceConfig(model.performanceConfig);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SystemContentBlock.Builder> getSystem() {
            List<SystemContentBlock.Builder> result = SystemContentBlocksCopier.copyToBuilder(this.system);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystem(Collection<SystemContentBlock.BuilderImpl> system) {
            this.system = SystemContentBlocksCopier.copyFromBuilder(system);
        }

        @Override
        public final Builder system(Collection<SystemContentBlock> system) {
            this.system = SystemContentBlocksCopier.copy(system);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(SystemContentBlock ... system) {
            this.system(Arrays.asList(system));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(Consumer<SystemContentBlock.Builder> ... system) {
            this.system(Stream.of(system).map(c -> (SystemContentBlock)((SystemContentBlock.Builder)SystemContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(InferenceConfiguration.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(InferenceConfiguration inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final ToolConfiguration.Builder getToolConfig() {
            return this.toolConfig != null ? this.toolConfig.toBuilder() : null;
        }

        public final void setToolConfig(ToolConfiguration.BuilderImpl toolConfig) {
            this.toolConfig = toolConfig != null ? toolConfig.build() : null;
        }

        @Override
        public final Builder toolConfig(ToolConfiguration toolConfig) {
            this.toolConfig = toolConfig;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfig() {
            return this.guardrailConfig != null ? this.guardrailConfig.toBuilder() : null;
        }

        public final void setGuardrailConfig(GuardrailConfiguration.BuilderImpl guardrailConfig) {
            this.guardrailConfig = guardrailConfig != null ? guardrailConfig.build() : null;
        }

        @Override
        public final Builder guardrailConfig(GuardrailConfiguration guardrailConfig) {
            this.guardrailConfig = guardrailConfig;
            return this;
        }

        public final Document getAdditionalModelRequestFields() {
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
        }

        @Override
        public final Builder additionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        public final Map<String, PromptVariableValues.Builder> getPromptVariables() {
            Map<String, PromptVariableValues.Builder> result = PromptVariableMapCopier.copyToBuilder(this.promptVariables);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPromptVariables(Map<String, PromptVariableValues.BuilderImpl> promptVariables) {
            this.promptVariables = PromptVariableMapCopier.copyFromBuilder(promptVariables);
        }

        @Override
        public final Builder promptVariables(Map<String, PromptVariableValues> promptVariables) {
            this.promptVariables = PromptVariableMapCopier.copy(promptVariables);
            return this;
        }

        public final Collection<String> getAdditionalModelResponseFieldPaths() {
            if (this.additionalModelResponseFieldPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalModelResponseFieldPaths;
        }

        public final void setAdditionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths = ConverseRequestAdditionalModelResponseFieldPathsListCopier.copy(additionalModelResponseFieldPaths);
        }

        @Override
        public final Builder additionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths = ConverseRequestAdditionalModelResponseFieldPathsListCopier.copy(additionalModelResponseFieldPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalModelResponseFieldPaths(String ... additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths(Arrays.asList(additionalModelResponseFieldPaths));
            return this;
        }

        public final Map<String, String> getRequestMetadata() {
            if (this.requestMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestMetadata;
        }

        public final void setRequestMetadata(Map<String, String> requestMetadata) {
            this.requestMetadata = RequestMetadataCopier.copy(requestMetadata);
        }

        @Override
        public final Builder requestMetadata(Map<String, String> requestMetadata) {
            this.requestMetadata = RequestMetadataCopier.copy(requestMetadata);
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfig() {
            return this.performanceConfig != null ? this.performanceConfig.toBuilder() : null;
        }

        public final void setPerformanceConfig(PerformanceConfiguration.BuilderImpl performanceConfig) {
            this.performanceConfig = performanceConfig != null ? performanceConfig.build() : null;
        }

        @Override
        public final Builder performanceConfig(PerformanceConfiguration performanceConfig) {
            this.performanceConfig = performanceConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConverseRequest build() {
            return new ConverseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConverseRequest> {
        public Builder modelId(String var1);

        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder system(Collection<SystemContentBlock> var1);

        public Builder system(SystemContentBlock ... var1);

        public Builder system(Consumer<SystemContentBlock.Builder> ... var1);

        public Builder inferenceConfig(InferenceConfiguration var1);

        default public Builder inferenceConfig(Consumer<InferenceConfiguration.Builder> inferenceConfig) {
            return this.inferenceConfig((InferenceConfiguration)((InferenceConfiguration.Builder)InferenceConfiguration.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder toolConfig(ToolConfiguration var1);

        default public Builder toolConfig(Consumer<ToolConfiguration.Builder> toolConfig) {
            return this.toolConfig((ToolConfiguration)((ToolConfiguration.Builder)ToolConfiguration.builder().applyMutation(toolConfig)).build());
        }

        public Builder guardrailConfig(GuardrailConfiguration var1);

        default public Builder guardrailConfig(Consumer<GuardrailConfiguration.Builder> guardrailConfig) {
            return this.guardrailConfig((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfig)).build());
        }

        public Builder additionalModelRequestFields(Document var1);

        public Builder promptVariables(Map<String, PromptVariableValues> var1);

        public Builder additionalModelResponseFieldPaths(Collection<String> var1);

        public Builder additionalModelResponseFieldPaths(String ... var1);

        public Builder requestMetadata(Map<String, String> var1);

        public Builder performanceConfig(PerformanceConfiguration var1);

        default public Builder performanceConfig(Consumer<PerformanceConfiguration.Builder> performanceConfig) {
            return this.performanceConfig((PerformanceConfiguration)((PerformanceConfiguration.Builder)PerformanceConfiguration.builder().applyMutation(performanceConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

