/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationConfiguredModelAlgorithmAssociationSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse;

public class ListCollaborationConfiguredModelAlgorithmAssociationsPublisher
implements SdkPublisher<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListCollaborationConfiguredModelAlgorithmAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationConfiguredModelAlgorithmAssociationsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationConfiguredModelAlgorithmAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationConfiguredModelAlgorithmAssociationsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationConfiguredModelAlgorithmAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationConfiguredModelAlgorithmAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationConfiguredModelAlgorithmAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationConfiguredModelAlgorithmAssociationSummary> collaborationConfiguredModelAlgorithmAssociations() {
        Function<ListCollaborationConfiguredModelAlgorithmAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationConfiguredModelAlgorithmAssociations() != null) {
                return response.collaborationConfiguredModelAlgorithmAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationConfiguredModelAlgorithmAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationConfiguredModelAlgorithmAssociationsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> {
        private ListCollaborationConfiguredModelAlgorithmAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationConfiguredModelAlgorithmAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> nextPage(ListCollaborationConfiguredModelAlgorithmAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationConfiguredModelAlgorithmAssociationsPublisher.this.client.listCollaborationConfiguredModelAlgorithmAssociations(ListCollaborationConfiguredModelAlgorithmAssociationsPublisher.this.firstRequest);
            }
            return ListCollaborationConfiguredModelAlgorithmAssociationsPublisher.this.client.listCollaborationConfiguredModelAlgorithmAssociations((ListCollaborationConfiguredModelAlgorithmAssociationsRequest)((Object)ListCollaborationConfiguredModelAlgorithmAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

