/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse;

public class ListCollaborationTrainedModelExportJobsPublisher
implements SdkPublisher<ListCollaborationTrainedModelExportJobsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListCollaborationTrainedModelExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationTrainedModelExportJobsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationTrainedModelExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationTrainedModelExportJobsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationTrainedModelExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationTrainedModelExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationTrainedModelExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs() {
        Function<ListCollaborationTrainedModelExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationTrainedModelExportJobs() != null) {
                return response.collaborationTrainedModelExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationTrainedModelExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationTrainedModelExportJobsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationTrainedModelExportJobsResponse> {
        private ListCollaborationTrainedModelExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationTrainedModelExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationTrainedModelExportJobsResponse> nextPage(ListCollaborationTrainedModelExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationTrainedModelExportJobsPublisher.this.client.listCollaborationTrainedModelExportJobs(ListCollaborationTrainedModelExportJobsPublisher.this.firstRequest);
            }
            return ListCollaborationTrainedModelExportJobsPublisher.this.client.listCollaborationTrainedModelExportJobs((ListCollaborationTrainedModelExportJobsRequest)((Object)ListCollaborationTrainedModelExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

