/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Permissions {
    OWNER("owner"),
    READ_WRITE("read-write"),
    READ_ONLY("read-only"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Permissions> VALUE_MAP;
    private final String value;

    private Permissions(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Permissions fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Permissions> knownValues() {
        EnumSet<Permissions> knownValues = EnumSet.allOf(Permissions.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Permissions.class, Permissions::toString);
    }
}

